/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryregistry.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibraryRegistryPackage;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.PluginProvidedJAXRSLibrary;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ArchiveFileImpl
extends EObjectImpl
implements ArchiveFile {
    protected static final boolean RELATIVE_TO_WORKSPACE_EDEFAULT = true;
    protected boolean relativeToWorkspace = true;
    protected static final String SOURCE_LOCATION_EDEFAULT = null;
    protected String sourceLocation = SOURCE_LOCATION_EDEFAULT;
    protected static final String RELATIVE_DEST_LOCATION_EDEFAULT = null;
    protected String relativeDestLocation = RELATIVE_DEST_LOCATION_EDEFAULT;

    protected ArchiveFileImpl() {
    }

    protected EClass eStaticClass() {
        return JAXRSLibraryRegistryPackage.Literals.ARCHIVE_FILE;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String newSourceLocation) {
        String oldSourceLocation = this.sourceLocation;
        if (this.relativeToWorkspace) {
            IWorkspaceRoot workspaceRoot = this.getWorkspaceRoot();
            if (workspaceRoot != null) {
                IPath wsRootPath = workspaceRoot.getLocation();
                Path srcPath = new Path(newSourceLocation);
                if (workspaceRoot.findMember((IPath)srcPath) != null) {
                    this.sourceLocation = newSourceLocation;
                } else if (wsRootPath.isPrefixOf((IPath)srcPath)) {
                    int segmentsMatched = wsRootPath.matchingFirstSegments((IPath)srcPath);
                    srcPath = srcPath.removeFirstSegments(segmentsMatched).setDevice(null);
                    this.sourceLocation = srcPath.toOSString();
                } else {
                    this.sourceLocation = newSourceLocation;
                    this.relativeToWorkspace = false;
                }
            }
        } else {
            this.sourceLocation = newSourceLocation;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSourceLocation, (Object)this.sourceLocation));
        }
    }

    public boolean isRelativeToWorkspace() {
        return this.relativeToWorkspace;
    }

    public void setRelativeToWorkspace(boolean newRelativeToWorkspace) {
        boolean oldRelativeToWorkspace = this.relativeToWorkspace;
        this.relativeToWorkspace = newRelativeToWorkspace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldRelativeToWorkspace, this.relativeToWorkspace));
        }
    }

    public String getRelativeDestLocation() {
        return this.relativeDestLocation;
    }

    public void setRelativeDestLocation(String newRelativeDestLocation) {
        String oldRelativeDestLocation = this.relativeDestLocation;
        this.relativeDestLocation = newRelativeDestLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldRelativeDestLocation, (Object)this.relativeDestLocation));
        }
    }

    public JAXRSLibrary getJAXRSLibrary() {
        if (this.eContainerFeatureID != 3) {
            return null;
        }
        return (JAXRSLibrary)this.eContainer();
    }

    public NotificationChain basicSetJAXRSLibrary(JAXRSLibrary newJAXRSLibrary, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newJAXRSLibrary, 3, msgs);
        return msgs;
    }

    public void setJAXRSLibrary(JAXRSLibrary newJAXRSLibrary) {
        if (newJAXRSLibrary != this.eInternalContainer() || this.eContainerFeatureID != 3 && newJAXRSLibrary != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newJAXRSLibrary)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newJAXRSLibrary != null) {
                msgs = ((InternalEObject)newJAXRSLibrary).eInverseAdd((InternalEObject)this, 3, JAXRSLibrary.class, msgs);
            }
            if ((msgs = this.basicSetJAXRSLibrary(newJAXRSLibrary, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newJAXRSLibrary, (Object)newJAXRSLibrary));
        }
    }

    public String getPath() {
        String path = null;
        String resolvedSourceLocation = this.getResolvedSourceLocation();
        if (resolvedSourceLocation != null) {
            int iPos = resolvedSourceLocation.lastIndexOf(47);
            if (iPos < 0) {
                iPos = resolvedSourceLocation.lastIndexOf(92);
            }
            path = iPos < 1 ? "" : resolvedSourceLocation.substring(0, iPos);
        }
        return path;
    }

    public String getName() {
        String name = null;
        String resolvedSourceLocation = this.getResolvedSourceLocation();
        if (resolvedSourceLocation != null) {
            int iPos = resolvedSourceLocation.lastIndexOf(47);
            if (iPos < 0) {
                iPos = resolvedSourceLocation.lastIndexOf(92);
            }
            name = iPos < 0 || iPos == resolvedSourceLocation.length() - 1 ? resolvedSourceLocation : resolvedSourceLocation.substring(iPos + 1);
        }
        return name;
    }

    public boolean exists() {
        boolean exists = false;
        if (this.getJAXRSLibrary() instanceof PluginProvidedJAXRSLibrary && this.isRelativeToWorkspace()) {
            Bundle bundle = this.getBundle();
            if (bundle != null) {
                exists = bundle.getEntry(this.sourceLocation) != null;
            }
        } else {
            String resolvedSourceLocation = this.getResolvedSourceLocation();
            if (resolvedSourceLocation != null) {
                exists = new File(resolvedSourceLocation).exists();
            }
        }
        return exists;
    }

    public boolean equals(Object object) {
        boolean equal = false;
        if (object instanceof ArchiveFile) {
            String resolvedSourceLocation = this.getResolvedSourceLocation();
            String objResolvedSourceLocation = ((ArchiveFile)object).getResolvedSourceLocation();
            if (resolvedSourceLocation == null && objResolvedSourceLocation == null) {
                equal = true;
            } else if (resolvedSourceLocation != null) {
                equal = resolvedSourceLocation.equals(objResolvedSourceLocation);
            }
        }
        return equal;
    }

    public int hashCode() {
        return this.getResolvedSourceLocation() != null ? this.getResolvedSourceLocation().hashCode() : 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean copyTo(String baseDestLocation) {
        copied = false;
        in = null;
        out = null;
        outPath = new Path(baseDestLocation);
        if (this.relativeDestLocation != null) {
            outPath = outPath.append(this.relativeDestLocation);
        }
        outPath = outPath.append(this.getName());
        try {
            block27: {
                block28: {
                    if (outPath.toFile().exists()) {
                        var9_6 = copied;
                        return var9_6;
                    }
                    out = new FileOutputStream(outPath.toOSString());
                    if (!(this.getJAXRSLibrary() instanceof PluginProvidedJAXRSLibrary)) break block27;
                    bundle = this.getBundle();
                    inURL = bundle.getEntry(this.sourceLocation);
                    if (inURL == null) break block28;
                    in = inURL.openStream();
                    ** GOTO lbl26
                }
                JAXRSCorePlugin.log(4, NLS.bind((String)Messages.ArchiveFileImpl_CannotLocatePluginRelativeFile, (Object)this.sourceLocation));
                var9_7 = copied;
                return var9_7;
            }
            try {
                in = new FileInputStream(this.getResolvedSourceLocation());
lbl26:
                // 2 sources

                buf = new byte[1024];
                len = 0;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                copied = true;
            }
            catch (FileNotFoundException fnfe) {
                JAXRSCorePlugin.log(4, Messages.ArchiveFileImpl_CannotCopyFile, fnfe);
            }
            catch (IOException ioe) {
                JAXRSCorePlugin.log(4, Messages.ArchiveFileImpl_CannotCopyFile, ioe);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                JAXRSCorePlugin.log(2, Messages.ArchiveFileImpl_CannotCloseFile, ioe);
            }
        }
        return copied;
    }

    public String getResolvedSourceLocation() {
        String resolvedSourceLocation;
        block7: {
            resolvedSourceLocation = null;
            if (this.getJAXRSLibrary() instanceof PluginProvidedJAXRSLibrary) {
                PluginProvidedJAXRSLibrary cfr_ignored_0 = (PluginProvidedJAXRSLibrary)this.getJAXRSLibrary();
                Bundle bundle = this.getBundle();
                if (bundle != null && this.isRelativeToWorkspace()) {
                    try {
                        Path srcPath = new Path(this.sourceLocation);
                        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)srcPath, null);
                        if (fileURL != null) {
                            URL url = FileLocator.resolve((URL)fileURL);
                            resolvedSourceLocation = url.getPath();
                            break block7;
                        }
                        resolvedSourceLocation = this.sourceLocation;
                    }
                    catch (IOException iOException) {
                        resolvedSourceLocation = this.sourceLocation;
                    }
                } else {
                    resolvedSourceLocation = this.sourceLocation;
                }
            } else {
                String workspaceLocation;
                IWorkspaceRoot workspaceRoot;
                resolvedSourceLocation = this.isRelativeToWorkspace() ? ((workspaceRoot = this.getWorkspaceRoot()) != null ? ((workspaceLocation = workspaceRoot.getLocation().toOSString()) != null ? String.valueOf(this.appendSeparator(workspaceLocation)) + this.sourceLocation : this.sourceLocation) : this.sourceLocation) : this.sourceLocation;
            }
        }
        return resolvedSourceLocation;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetJAXRSLibrary((JAXRSLibrary)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetJAXRSLibrary(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 3, JAXRSLibrary.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isRelativeToWorkspace() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getSourceLocation();
            }
            case 2: {
                return this.getRelativeDestLocation();
            }
            case 3: {
                return this.getJAXRSLibrary();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRelativeToWorkspace((Boolean)newValue);
                return;
            }
            case 1: {
                this.setSourceLocation((String)newValue);
                return;
            }
            case 2: {
                this.setRelativeDestLocation((String)newValue);
                return;
            }
            case 3: {
                this.setJAXRSLibrary((JAXRSLibrary)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRelativeToWorkspace(true);
                return;
            }
            case 1: {
                this.setSourceLocation(SOURCE_LOCATION_EDEFAULT);
                return;
            }
            case 2: {
                this.setRelativeDestLocation(RELATIVE_DEST_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setJAXRSLibrary(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.relativeToWorkspace;
            }
            case 1: {
                return SOURCE_LOCATION_EDEFAULT == null ? this.sourceLocation != null : !SOURCE_LOCATION_EDEFAULT.equals(this.sourceLocation);
            }
            case 2: {
                return RELATIVE_DEST_LOCATION_EDEFAULT == null ? this.relativeDestLocation != null : !RELATIVE_DEST_LOCATION_EDEFAULT.equals(this.relativeDestLocation);
            }
            case 3: {
                return this.getJAXRSLibrary() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    protected Bundle getBundle() {
        String pluginID;
        Bundle bundle = null;
        if (this.getJAXRSLibrary() instanceof PluginProvidedJAXRSLibrary && (pluginID = ((PluginProvidedJAXRSLibrary)this.getJAXRSLibrary()).getPluginID()) != null) {
            bundle = Platform.getBundle((String)pluginID);
        }
        return bundle;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        IWorkspaceRoot workspaceRoot = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspaceRoot = workspace.getRoot();
        }
        return workspaceRoot;
    }

    protected String appendSeparator(String path) {
        String newPath = null;
        newPath = !path.endsWith("\\") && !path.endsWith("/") ? String.valueOf(path) + System.getProperty("file.separator") : path;
        return newPath;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (RelativeToWorkspace: ");
        result.append(this.relativeToWorkspace);
        result.append(", SourceLocation: ");
        result.append(this.sourceLocation);
        result.append(", RelativeDestLocation: ");
        result.append(this.relativeDestLocation);
        result.append(')');
        return result.toString();
    }
}

