/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumn
extends AbstractJavaNamedColumn<PrimaryKeyJoinColumnAnnotation>
implements JavaPrimaryKeyJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;

    public GenericJavaPrimaryKeyJoinColumn(JavaJpaContextNode parent, JavaBaseJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(PrimaryKeyJoinColumnAnnotation column) {
        super.initialize(column);
        this.specifiedReferencedColumnName = this.getResourceReferencedColumnName();
        this.defaultReferencedColumnName = this.buildDefaultReferencedColumnName();
    }

    @Override
    public void update(PrimaryKeyJoinColumnAnnotation resourceColumn) {
        super.update(resourceColumn);
        this.setSpecifiedReferencedColumnName_(this.getResourceReferencedColumnName());
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public JavaBaseJoinColumn.Owner getOwner() {
        return (JavaBaseJoinColumn.Owner)super.getOwner();
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        ((PrimaryKeyJoinColumnAnnotation)this.getResourceColumn()).setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public String getTable() {
        return this.getOwner().getDefaultTableName();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return ((PrimaryKeyJoinColumnAnnotation)this.getResourceColumn()).referencedColumnNameTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.getJavaCandidateReferencedColumnNames(filter).iterator();
        }
        return null;
    }

    private Iterable<String> getJavaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateReferencedColumnNames(filter));
    }

    private Iterable<String> getCandidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateReferencedColumnNames(), filter);
    }

    private Iterable<String> getCandidateReferencedColumnNames() {
        Table table = this.getOwner().getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = ((PrimaryKeyJoinColumnAnnotation)this.getResourceColumn()).getReferencedColumnNameTextRange(astRoot);
        return textRange != null ? textRange : this.getValidationTextRange(astRoot);
    }

    protected String getResourceReferencedColumnName() {
        return ((PrimaryKeyJoinColumnAnnotation)this.getResourceColumn()).getReferencedColumnName();
    }

    protected String buildDefaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append("=>");
        sb.append(this.getReferencedColumnName());
    }

    @Override
    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        this.validateJoinColumnName(messages, astRoot);
        this.validateReferencedColumnName(messages, astRoot);
    }

    protected void validateJoinColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getSpecifiedName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedNameMultipleJoinColumnsMessage(astRoot));
        } else if (this.getName() != null) {
            super.validateName(messages, astRoot);
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getSpecifiedReferencedColumnName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(astRoot));
        } else if (this.getReferencedColumnName() != null && this.getReferencedColumnDbTable() != null && !this.isReferencedColumnResolved()) {
            messages.add(this.getOwner().buildUnresolvedReferencedColumnNameMessage(this, this.getReferencedColumnNameTextRange(astRoot)));
        }
    }

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(CompilationUnit astRoot) {
        return this.getOwner().buildUnspecifiedNameMultipleJoinColumnsMessage(this, this.getNameTextRange(astRoot));
    }

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(CompilationUnit astRoot) {
        return this.getOwner().buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(this, this.getReferencedColumnNameTextRange(astRoot));
    }
}

