/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.cleanup;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.StructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.cleanup.ElementNodeCleanupHandler;
import org.eclipse.wst.xml.core.internal.cleanup.NodeCleanupHandler;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormatterFormatProcessor;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CleanupProcessorXML
extends AbstractStructuredCleanupProcessor {
    protected IStructuredCleanupPreferences fCleanupPreferences = null;

    public void cleanupModel(IStructuredModel structuredModel) {
        IDOMDocument document;
        Preferences preferences = this.getModelPreferences();
        if (preferences != null && preferences.getBoolean("fixXMLDeclaration") && !this.fixExistingXmlDecl(document = ((DOMModelImpl)structuredModel).getDocument())) {
            String encoding = preferences.getString("outputCodeset");
            ProcessingInstruction xml = document.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + encoding + "\"");
            document.insertBefore(xml, document.getFirstChild());
        }
        super.cleanupModel(structuredModel);
    }

    private boolean isXMLDecl(IDOMNode node) {
        return node != null && node.getNodeType() == 7 && "xml".equalsIgnoreCase(((ProcessingInstruction)((Object)node)).getTarget());
    }

    private boolean fixExistingXmlDecl(IDOMDocument document) {
        IDOMNode node = (IDOMNode)document.getFirstChild();
        while (node != null && node.getNodeType() == 3 && ((TextImpl)node).isWhitespace()) {
            node = (IDOMNode)node.getNextSibling();
        }
        if (this.isXMLDecl(node)) {
            document.insertBefore(node, document.getFirstChild());
            return true;
        }
        return false;
    }

    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        short nodeType = node.getNodeType();
        NodeCleanupHandler cleanupHandler = null;
        switch (nodeType) {
            case 1: {
                cleanupHandler = new ElementNodeCleanupHandler();
                break;
            }
            case 3: {
                cleanupHandler = new NodeCleanupHandler();
                break;
            }
            default: {
                cleanupHandler = new NodeCleanupHandler();
            }
        }
        cleanupHandler.setCleanupPreferences(this.getCleanupPreferences());
        return cleanupHandler;
    }

    public IStructuredCleanupPreferences getCleanupPreferences() {
        if (this.fCleanupPreferences == null) {
            this.fCleanupPreferences = new StructuredCleanupPreferences();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fCleanupPreferences.setCompressEmptyElementTags(preferences.getBoolean("compressEmptyElementTags"));
                this.fCleanupPreferences.setInsertRequiredAttrs(preferences.getBoolean("insertRequiredAttrs"));
                this.fCleanupPreferences.setInsertMissingTags(preferences.getBoolean("insertMissingTags"));
                this.fCleanupPreferences.setQuoteAttrValues(preferences.getBoolean("quoteAttrValues"));
                this.fCleanupPreferences.setFormatSource(preferences.getBoolean("formatSource"));
                this.fCleanupPreferences.setConvertEOLCodes(preferences.getBoolean("convertEOLCodes"));
                this.fCleanupPreferences.setEOLCode(preferences.getString("cleanupEOLCode"));
            }
        }
        return this.fCleanupPreferences;
    }

    protected String getContentType() {
        return ContentTypeIdForXML.ContentTypeID_XML;
    }

    protected IStructuredFormatProcessor getFormatProcessor() {
        return new XMLFormatterFormatProcessor();
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void refreshCleanupPreferences() {
        this.fCleanupPreferences = null;
    }
}

