/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.util.Comparator;
import org.eclipse.jface.util.Assert;

public class TwoArrayQuickSorter {
    private Comparator fComparator;

    public TwoArrayQuickSorter(boolean ignoreCase) {
        this.fComparator = new StringComparator(ignoreCase);
    }

    public TwoArrayQuickSorter(Comparator comparator) {
        this.fComparator = comparator;
    }

    public void sort(Object[] keys, Object[] values) {
        if (keys == null || values == null) {
            Assert.isTrue((boolean)false, (String)"Either keys or values in null");
            return;
        }
        if (keys.length <= 1) {
            return;
        }
        this.internalSort(keys, values, 0, keys.length - 1);
    }

    private void internalSort(Object[] keys, Object[] values, int left, int right) {
        int localLeft = left;
        int localRight = right;
        int original_left = localLeft;
        int original_right = localRight;
        Object mid = keys[(localLeft + localRight) / 2];
        while (true) {
            if (this.fComparator.compare(keys[localLeft], mid) < 0) {
                ++localLeft;
                continue;
            }
            while (this.fComparator.compare(mid, keys[localRight]) < 0) {
                --localRight;
            }
            if (localLeft <= localRight) {
                TwoArrayQuickSorter.swap(keys, localLeft, localRight);
                TwoArrayQuickSorter.swap(values, localLeft, localRight);
                ++localLeft;
                --localRight;
            }
            if (localLeft > localRight) break;
        }
        if (original_left < localRight) {
            this.internalSort(keys, values, original_left, localRight);
        }
        if (localLeft < original_right) {
            this.internalSort(keys, values, localLeft, original_right);
        }
    }

    private static final void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static final class StringComparator
    implements Comparator {
        private boolean fIgnoreCase;

        StringComparator(boolean ignoreCase) {
            this.fIgnoreCase = ignoreCase;
        }

        public int compare(Object left, Object right) {
            return this.fIgnoreCase ? ((String)left).compareToIgnoreCase((String)right) : ((String)left).compareTo((String)right);
        }
    }
}

