/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTAttribute;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.FieldAttribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTFieldAttribute
extends JDTAttribute
implements FieldAttribute {
    protected static final Selector<FieldDeclaration> FIELD_DECLARATION_SELECTOR = new Selector<FieldDeclaration>(){

        @Override
        public FieldDeclaration select(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclarationFragment) {
            return fieldDeclaration;
        }

        @Override
        public String getDescription() {
            return "field declaration";
        }

        public String toString() {
            return "FIELD_DECLARATION_SELECTOR";
        }
    };
    protected static final Selector<VariableDeclarationFragment> VARIABLE_DECLARATION_FRAGMENT_SELECTOR = new Selector<VariableDeclarationFragment>(){

        @Override
        public VariableDeclarationFragment select(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclarationFragment) {
            return variableDeclarationFragment;
        }

        @Override
        public String getDescription() {
            return "variable declaration fragment";
        }

        public String toString() {
            return "VARIABLE_DECLARATION_FRAGMENT_SELECTOR";
        }
    };

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, DefaultAnnotationEditFormatter.instance());
    }

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringType, name, occurrence, compilationUnit, CommandExecutor.Default.instance(), DefaultAnnotationEditFormatter.instance());
    }

    @Override
    public IVariableBinding getBinding(CompilationUnit astRoot) {
        return this.getFragment(astRoot).resolveBinding();
    }

    @Override
    public FieldDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        return this.getSelectedDeclaration(astRoot, FIELD_DECLARATION_SELECTOR);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return new ASTNodeTextRange((ASTNode)this.getFragment(astRoot).getName());
    }

    @Override
    public String getAttributeName() {
        return this.getName_();
    }

    @Override
    public ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getType().resolveBinding();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        IVariableBinding binding = this.getBinding(astRoot);
        return binding == null ? false : JPTTools.fieldIsPersistable(new JPTToolsAdapter(binding));
    }

    protected VariableDeclarationFragment getFragment(CompilationUnit astRoot) {
        return this.getSelectedDeclaration(astRoot, VARIABLE_DECLARATION_FRAGMENT_SELECTOR);
    }

    protected <T extends ASTNode> T getSelectedDeclaration(CompilationUnit astRoot, Selector<T> selector) {
        String name = this.getName_();
        int occurrence = this.getOccurrence();
        int count = 0;
        FieldDeclaration[] fieldDeclarationArray = this.getDeclaringTypeFieldDeclarations(astRoot);
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JDTFieldAttribute.fragments(fieldDeclaration)) {
                if (!fragment.getName().getFullyQualifiedName().equals(name) || ++count != occurrence) continue;
                return selector.select(fieldDeclaration, fragment);
            }
            ++n2;
        }
        return null;
    }

    protected FieldDeclaration[] getDeclaringTypeFieldDeclarations(CompilationUnit astRoot) {
        return this.getDeclaringTypeDeclaration(astRoot).getFields();
    }

    protected static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    protected static class JPTToolsAdapter
    implements JPTTools.FieldAdapter {
        private final IVariableBinding fieldBinding;

        protected JPTToolsAdapter(IVariableBinding fieldBinding) {
            if (fieldBinding == null) {
                throw new NullPointerException();
            }
            this.fieldBinding = fieldBinding;
        }

        public int getModifiers() {
            return this.fieldBinding.getModifiers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Selector<T extends ASTNode> {
        public T select(FieldDeclaration var1, VariableDeclarationFragment var2);

        public String getDescription();
    }
}

