/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.ui.project.facet.EarSelectionPanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public abstract class J2EEComponentFacetCreationWizardPage
extends DataModelFacetCreationWizardPage {
    private static final String STORE_LABEL = "LASTEARNAME_";
    protected EarSelectionPanel earPanel;
    private boolean shouldAddEARComposite = true;

    public J2EEComponentFacetCreationWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = super.createTopLevelComposite(parent);
        if (this.isShouldAddEARComposite()) {
            this.createEarComposite(top);
            this.createWorkingSetGroupPanel(top, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
        }
        return top;
    }

    private void createEarComposite(Composite top) {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        String moduleFacetId = this.getModuleFacetID();
        IProjectFacet moduleFacet = ProjectFacetsManager.getProjectFacet((String)moduleFacetId);
        IFacetedProject.Action action = fpjwc.getProjectFacetAction(moduleFacet);
        this.earPanel = new EarSelectionPanel((IDataModel)action.getConfig(), top);
    }

    protected abstract String getModuleFacetID();

    protected String getModuleTypeID() {
        return this.getModuleFacetID();
    }

    public void dispose() {
        super.dispose();
        if (this.earPanel != null) {
            this.earPanel.dispose();
        }
    }

    public void storeDefaultSettings() {
        String facetID;
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map;
        IDataModel j2eeModel;
        super.storeDefaultSettings();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (j2eeModel = (map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).getFacetDataModel(facetID = this.getModuleFacetID())).getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            String lastEARName = j2eeModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
            settings.put(STORE_LABEL, lastEARName);
        }
    }

    public void restoreDefaultSettings() {
        IProject selectedEARProject = this.getSelectedEAR();
        if (selectedEARProject != null) {
            IRuntime earRuntime = J2EEComponentFacetCreationWizardPage.getTargetRuntime(selectedEARProject);
            if (this.runtimeSupportFacets(earRuntime)) {
                this.restoreEARName(selectedEARProject);
                this.restoreEARRuntime(selectedEARProject);
            }
        } else {
            this.restoreStoredLabelEARName();
        }
        super.restoreDefaultSettings();
    }

    private void restoreEARName(IProject earProject) {
        String earName = earProject.getName();
        if (earName != null) {
            this.setEarName(earName, false);
        }
    }

    private void restoreStoredLabelEARName() {
        IProject earProject;
        IDialogSettings settings = this.getDialogSettings();
        String earName = settings.get(STORE_LABEL);
        if (earName != null && (earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earName)) != null) {
            this.setEarName(earName, true);
        }
    }

    private boolean runtimeSupportFacets(IRuntime runtime) {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (runtime != null) {
            for (IProjectFacet facet : fpjwc.getFixedProjectFacets()) {
                try {
                    IProjectFacetVersion facetVersion = facet.getLatestSupportedVersion(runtime);
                    if (facetVersion != null) continue;
                    return false;
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    private void setEarName(String earName, boolean lastEAROnly) {
        if (earName != null) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            String facetID = this.getModuleFacetID();
            IDataModel j2eeModel = map.getFacetDataModel(facetID);
            j2eeModel.setProperty("IJ2EEModuleFacetInstallDataModelProperties.LAST_EAR_NAME", (Object)earName);
            if (!lastEAROnly) {
                j2eeModel.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
            }
        }
    }

    public void restoreEARRuntime(IProject proj) {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        String facetID = this.getModuleFacetID();
        IDataModel j2eeModel = map.getFacetDataModel(facetID);
        IRuntime currentRuntime = J2EEComponentFacetCreationWizardPage.getTargetRuntime(proj);
        if (currentRuntime != null) {
            j2eeModel.setProperty("IJ2EEFacetInstallDataModelProperties.RUNTIME_TARGET_ID", (Object)currentRuntime);
            this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)currentRuntime);
        }
    }

    public static IRuntime getTargetRuntime(IProject project) {
        IFacetedProject fProject = null;
        try {
            fProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException ex) {
            J2EEUIPlugin.logError(ex);
        }
        if (fProject != null) {
            return fProject.getRuntime();
        }
        return null;
    }

    private IProject getSelectedEAR() {
        IProject selProject;
        IProject retVal = null;
        ISelection selection = this.getSelectionFromWorkbenchWindow();
        if (selection instanceof IStructuredSelection && (selProject = this.getEARProjectFromSelection((IStructuredSelection)selection)) != null && JavaEEProjectUtilities.isEARProject((IProject)selProject)) {
            retVal = selProject;
        }
        return retVal;
    }

    private ISelection getSelectionFromWorkbenchWindow() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        return selection;
    }

    private IProject getEARProjectFromSelection(IStructuredSelection selection) {
        Object firstSelectedElement;
        if (selection != null && !selection.isEmpty() && (firstSelectedElement = selection.getFirstElement()) instanceof IProject) {
            return (IProject)firstSelectedElement;
        }
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        return J2EEUIPlugin.getDefault().getDialogSettings();
    }

    protected String[] getValidationPropertyNames() {
        String[] superProperties = super.getValidationPropertyNames();
        List<String> list = Arrays.asList(superProperties);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        arrayList.add("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
        arrayList.add("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR");
        arrayList.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        return arrayList.toArray(new String[0]);
    }

    protected boolean isShouldAddEARComposite() {
        return this.shouldAddEARComposite;
    }

    protected void setShouldAddEARComposite(boolean shouldAddEARComposite) {
        this.shouldAddEARComposite = shouldAddEARComposite;
    }
}

