/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumn
extends AbstractJavaBaseColumn<JoinColumnAnnotation>
implements JavaJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;

    public GenericJavaJoinColumn(JavaJpaContextNode parent, JavaJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(JoinColumnAnnotation annotation) {
        super.initialize(annotation);
        this.specifiedReferencedColumnName = annotation.getReferencedColumnName();
        this.defaultReferencedColumnName = this.buildDefaultReferencedColumnName();
    }

    @Override
    public void update(JoinColumnAnnotation annotation) {
        super.update(annotation);
        this.setSpecifiedReferencedColumnName_(annotation.getReferencedColumnName());
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        ((JoinColumnAnnotation)this.getResourceColumn()).setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public JavaJoinColumn.Owner getOwner() {
        return (JavaJoinColumn.Owner)super.getOwner();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return ((JoinColumnAnnotation)this.getResourceColumn()).referencedColumnNameTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.getJavaCandidateReferencedColumnNames(filter).iterator();
        }
        return null;
    }

    private Iterable<String> getJavaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateReferencedColumnNames(filter));
    }

    private Iterable<String> getCandidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateReferencedColumnNames(), filter);
    }

    private Iterable<String> getCandidateReferencedColumnNames() {
        Table table = this.getOwner().getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = ((JoinColumnAnnotation)this.getResourceColumn()).getReferencedColumnNameTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    protected String buildDefaultName() {
        return MappingTools.buildJoinColumnDefaultName(this, this.getOwner());
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this.getOwner());
    }

    @Override
    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        this.validateJoinColumnName(messages, astRoot);
        this.validateReferencedColumnName(messages, astRoot);
    }

    protected void validateJoinColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getSpecifiedName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedNameMultipleJoinColumnsMessage(astRoot));
        } else if (this.getName() != null) {
            super.validateName(messages, astRoot);
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getSpecifiedReferencedColumnName() == null && this.getOwner().joinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(astRoot));
        } else if (this.getSpecifiedReferencedColumnName() != null && this.getReferencedColumnDbTable() != null && !this.isReferencedColumnResolved()) {
            messages.add(this.getOwner().buildUnresolvedReferencedColumnNameMessage(this, this.getReferencedColumnNameTextRange(astRoot)));
        }
    }

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(CompilationUnit astRoot) {
        return this.getOwner().buildUnspecifiedNameMultipleJoinColumnsMessage(this, this.getNameTextRange(astRoot));
    }

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(CompilationUnit astRoot) {
        return this.getOwner().buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(this, this.getReferencedColumnNameTextRange(astRoot));
    }
}

