/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentassist.el;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.Region;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.core.internal.contentassist.el.FunctionCompletionStrategy;
import org.eclipse.jst.jsf.core.internal.contentassist.el.IdCompletionStrategy;
import org.eclipse.jst.jsf.core.internal.contentassist.el.SymbolInfo;
import org.eclipse.jst.jsf.core.internal.contentassist.el.SymbolResolveUtil;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;

public final class ContentAssistParser {
    public static ContentAssistStrategy getPrefix(int relativePosition, String elText) {
        if (elText == null) {
            return null;
        }
        if ("".equals(elText.trim())) {
            return new IdCompletionStrategy("", "");
        }
        PrefixVisitor visitor = ContentAssistParser.getVisitorForPosition(relativePosition, elText);
        return visitor != null ? visitor.getPrefix() : null;
    }

    public static SymbolInfo getSymbolInfo(IStructuredDocumentContext context, int relativePosition, String elText) {
        Region r;
        SymbolInfo symbolInfo;
        if (elText == null || "".equals(elText.trim())) {
            return null;
        }
        PrefixVisitor visitor = ContentAssistParser.getVisitorForPosition(relativePosition, elText);
        if (visitor != null && (symbolInfo = visitor.getSymbolInfo(context)) != null && relativePosition > (r = symbolInfo.getRelativeRegion()).getOffset() && relativePosition <= r.getOffset() + r.getLength()) {
            return symbolInfo;
        }
        return null;
    }

    private static PrefixVisitor getVisitorForPosition(int relativePosition, String elText) {
        StringReader reader = new StringReader(elText);
        JSPELParser parser = new JSPELParser((Reader)reader);
        try {
            ASTExpression expr = parser.Expression();
            PrefixVisitor visitor = new PrefixVisitor(relativePosition, elText);
            expr.jjtAccept((JSPELParserVisitor)visitor, null);
            return visitor;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static String substring(String s, Region r) {
        return s.substring(r.getOffset(), r.getOffset() + r.getLength());
    }

    private ContentAssistParser() {
    }

    private static class PrefixVisitor
    implements JSPELParserVisitor {
        private final int _relativePos;
        private final String _fullText;
        private String _symbolPrefix;
        private int _prefixType;
        private boolean _prefixResolved;
        private int _symbolStartPos = 1;
        private int _symbolEndPos = 0;

        PrefixVisitor(int relativePos, String fullText) {
            this._relativePos = relativePos;
            this._fullText = fullText;
        }

        public ContentAssistStrategy getPrefix() {
            if (this._prefixResolved) {
                switch (this._prefixType) {
                    case 0: {
                        return new FunctionCompletionStrategy(this._symbolPrefix, this.getProposalStart());
                    }
                    case 1: {
                        return new IdCompletionStrategy(this._symbolPrefix, this.getProposalStart());
                    }
                    case 2: {
                        return new IdCompletionStrategy("", this.getProposalStart());
                    }
                }
            }
            return null;
        }

        public SymbolInfo getSymbolInfo(IStructuredDocumentContext context) {
            if (this._prefixResolved && this._symbolStartPos < this._symbolEndPos) {
                Region region = new Region(this._symbolStartPos - 1, this._symbolEndPos - this._symbolStartPos + 1);
                ISymbol symbol = null;
                switch (this._prefixType) {
                    case 1: {
                        symbol = SymbolResolveUtil.getSymbolForVariable(context, ContentAssistParser.substring(this._fullText, region));
                        break;
                    }
                    case 0: {
                        symbol = SymbolResolveUtil.getSymbolForVariableSuffixExpr(context, String.valueOf(this._symbolPrefix) + "." + ContentAssistParser.substring(this._fullText, region), this._symbolEndPos == this._fullText.length());
                    }
                }
                if (symbol != null) {
                    return new SymbolInfo(symbol, region);
                }
            }
            return null;
        }

        private String getProposalStart() {
            if (this._symbolStartPos <= this._relativePos) {
                return this._fullText.substring(this._symbolStartPos - 1, this._relativePos - 1);
            }
            return "";
        }

        public Object visit(ASTAddExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTAndExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTChoiceExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTEqualityExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTFunctionInvocation node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTLiteral node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTMultiplyExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTOrExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTRelationalExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTUnaryExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValue node, Object data) {
            if (this.testContainsCursor((SimpleNode)node)) {
                return node.childrenAccept((JSPELParserVisitor)this, data);
            }
            return null;
        }

        public Object visit(ASTValuePrefix node, Object data) {
            if (!this._prefixResolved && node.jjtGetNumChildren() == 0 && node.getFirstToken().kind == 47) {
                this._symbolPrefix = node.getFirstToken().image;
                if (this.testContainsCursor((SimpleNode)node)) {
                    this._prefixType = 1;
                    this._symbolStartPos = node.getFirstToken().beginColumn;
                    this._symbolEndPos = node.getFirstToken().endColumn;
                    this._prefixResolved = true;
                }
            }
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValueSuffix node, Object data) {
            Token lastToken = node.getLastToken();
            if (node.jjtGetNumChildren() == 0) {
                if (!this._prefixResolved && node.getFirstToken().kind == 13) {
                    if (lastToken.kind == 47) {
                        if (this.testContainsCursor((SimpleNode)node)) {
                            this._prefixType = 0;
                            int proposalStartLength = this._relativePos - lastToken.beginColumn;
                            if (proposalStartLength < 0) {
                                proposalStartLength = 0;
                            }
                            this._symbolStartPos = lastToken.beginColumn;
                            this._symbolEndPos = lastToken.endColumn;
                            this._prefixResolved = true;
                        } else {
                            this._symbolPrefix = String.valueOf(this._symbolPrefix) + node.getFirstToken().image + lastToken.image;
                        }
                    } else if (lastToken == node.getFirstToken() && this.testCursorImmediatelyAfter((SimpleNode)node)) {
                        this._prefixType = 0;
                        this._symbolStartPos = lastToken.endColumn + 1;
                        this._symbolEndPos = lastToken.endColumn;
                        this._prefixResolved = true;
                    }
                }
                return null;
            }
            if (node.getFirstToken().kind == 30) {
                node.childrenAccept((JSPELParserVisitor)this, data);
            }
            Object retValue = node.childrenAccept((JSPELParserVisitor)this, data);
            if (!this._prefixResolved) {
                this._symbolPrefix = String.valueOf(this._symbolPrefix) + this._fullText.substring(node.getFirstToken().beginColumn - 1, node.getLastToken().endColumn);
            }
            return retValue;
        }

        public Object visit(SimpleNode node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        private boolean testCursorImmediatelyAfter(SimpleNode node) {
            return node.getLastToken().endColumn == this._relativePos - 1;
        }

        private boolean testContainsCursor(SimpleNode node) {
            return node.getFirstToken().beginColumn <= this._relativePos && node.getLastToken().endColumn + 1 >= this._relativePos;
        }
    }
}

