/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapterImpl;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class JSPActionValidator
extends JSPValidator {
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private IValidator fMessageOriginator;
    private IPreferencesService fPreferencesService = null;
    private IScopeContext[] fScopes = null;
    private int fSeverityMissingRequiredAttribute = 1;
    private int fSeverityNonEmptyInlineTag = 2;
    private int fSeverityUnknownAttribute = 2;
    private int fSeverityUnexpectedRuntimeExpression = 2;
    private HashSet fTaglibPrefixes = new HashSet();
    private boolean fIsELIgnored = false;
    static /* synthetic */ Class class$0;

    public JSPActionValidator() {
        this.fMessageOriginator = this;
    }

    public JSPActionValidator(IValidator validator) {
        this.fMessageOriginator = validator;
    }

    private void checkNonEmptyInlineTag(IDOMElement element, CMElementDeclaration cmElementDecl, IReporter reporter, IFile file, IStructuredDocument document) {
        if (cmElementDecl.getContentType() == 1 && element.getChildNodes().getLength() > 0) {
            String msgText = NLS.bind((String)JSPCoreMessages.JSPActionValidator_0, (Object)element.getNodeName());
            JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityNonEmptyInlineTag, msgText, (IResource)file);
            int start = element.getStartOffset();
            int length = element.getStartEndOffset() - start;
            int lineNo = document.getLineOfOffset(start);
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private boolean checkRuntimeValue(IDOMAttr a) {
        ITextRegion value = a.getValueRegion();
        if (value instanceof ITextRegionContainer) {
            Iterator it = ((ITextRegionContainer)value).getRegions().iterator();
            while (it.hasNext()) {
                String type = ((ITextRegion)it.next()).getType();
                if (type != "JSP_EL_OPEN") continue;
                return true;
            }
        }
        return false;
    }

    private boolean isElIgnored(IPath path, IStructuredModel model) {
        String directiveIsELIgnored;
        if (DeploymentDescriptorPropertyCache.getInstance().getJSPVersion(path) < 2.0f) {
            return true;
        }
        IDOMDocument iDOMDocument = ((IDOMModel)model).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((directiveIsELIgnored = ((PageDirectiveAdapterImpl)iDOMDocument.getAdapterFor((Object)clazz)).getElIgnored()) != null) {
            return Boolean.valueOf(directiveIsELIgnored);
        }
        DeploymentDescriptorPropertyCache.PropertyGroup[] groups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(path);
        if (groups.length > 0) {
            return groups[0].isELignored();
        }
        return false;
    }

    private void checkRequiredAttributes(IDOMElement element, CMNamedNodeMap attrMap, IReporter reporter, IFile file, IStructuredDocument document, IStructuredDocumentRegion documentRegion) {
        Iterator it = attrMap.iterator();
        CMAttributeDeclaration attr = null;
        while (it.hasNext()) {
            Attr a;
            attr = (CMAttributeDeclaration)it.next();
            if (attr.getUsage() != 2 || (a = element.getAttributeNode(attr.getAttrName())) != null || this.checkJSPAttributeAction(element, attr)) continue;
            String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_5, (Object)attr.getAttrName());
            JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityMissingRequiredAttribute, msgText, (IResource)file);
            int start = element.getStartOffset();
            int length = element.getStartEndOffset() - start;
            int lineNo = document.getLineOfOffset(start);
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private boolean checkJSPAttributeAction(IDOMElement element, CMAttributeDeclaration attr) {
        if (element != null && attr != null) {
            NodeList elements = element.getElementsByTagName("jsp:attribute");
            String neededAttrName = attr.getNodeName();
            int i = 0;
            while (i < elements.getLength()) {
                Element childElement = (Element)elements.item(i);
                if (childElement.hasAttribute("name") && neededAttrName.equals(childElement.getAttribute("name"))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean checkUnknownAttributes(IDOMElement element, CMElementDeclaration elementDecl, CMNamedNodeMap cmAttrs, IReporter reporter, IFile file, IStructuredDocument document, IStructuredDocumentRegion documentRegion) {
        boolean foundjspattribute = false;
        boolean dynamicAttributesAllowed = false;
        CMElementDeclaration decl = elementDecl;
        if (decl instanceof CMNodeWrapper) {
            decl = (CMElementDeclaration)((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration) {
            String dynamicAttributes = ((TLDElementDeclaration)decl).getDynamicAttributes();
            dynamicAttributesAllowed = dynamicAttributes != null ? Boolean.valueOf(dynamicAttributes) : false;
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            IDOMAttr attr;
            Attr a = (Attr)attrs.item(i);
            CMAttributeDeclaration adec = (CMAttributeDeclaration)cmAttrs.getNamedItem(a.getName());
            if (adec == null) {
                if (!this.hasJSPRegion(((IDOMNode)a).getNameRegion()) && this.fSeverityUnknownAttribute != -1) {
                    if (!dynamicAttributesAllowed) {
                        String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_6, (Object)a.getName());
                        JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityUnknownAttribute, msgText, (IResource)file);
                        int start = ((IDOMAttr)a).getNameRegionStartOffset();
                        int length = ((IDOMAttr)a).getNameRegionEndOffset() - start;
                        int lineNo = document.getLineOfOffset(start);
                        message.setLineNo(lineNo);
                        message.setOffset(start);
                        message.setLength(length);
                        reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                    }
                } else {
                    foundjspattribute = true;
                }
            } else if (this.fSeverityUnexpectedRuntimeExpression != -1 && adec instanceof TLDAttributeDeclaration && !this.isTrue(((TLDAttributeDeclaration)adec).getRtexprvalue()) && this.checkRuntimeValue(attr = (IDOMAttr)a) && !this.fIsELIgnored) {
                String msg = NLS.bind((String)JSPCoreMessages.JSPActionValidator_1, (Object)a.getName());
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityUnexpectedRuntimeExpression, msg, (IResource)file);
                ITextRegion region = attr.getValueRegion();
                int start = attr.getValueRegionStartOffset();
                int length = region != null ? region.getTextLength() : 0;
                int lineNo = document.getLineOfOffset(start);
                message.setLineNo(lineNo);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
            ++i;
        }
        return foundjspattribute;
    }

    private boolean isTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fTaglibPrefixes.clear();
    }

    int getMessageSeverity(String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, this.fScopes);
        switch (sev) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return 2;
    }

    private String getStartTagName(IStructuredDocumentRegion sdr) {
        ITextRegion subRegion;
        String name = new String();
        ITextRegionList subRegions = sdr.getRegions();
        if (subRegions.size() > 2 && (subRegion = subRegions.get(0)).getType() == "XML_TAG_OPEN" && (subRegion = subRegions.get(1)).getType() == "XML_TAG_NAME") {
            name = sdr.getText(subRegion);
        }
        return name;
    }

    private HashSet getTaglibPrefixes(IStructuredDocument document) {
        if (this.fTaglibPrefixes.isEmpty()) {
            this.fTaglibPrefixes.add("jsp");
            this.fTaglibPrefixes.add("jspx");
            this.fTaglibPrefixes.add("java");
            this.fTaglibPrefixes.add("javax");
            this.fTaglibPrefixes.add("servlet");
            this.fTaglibPrefixes.add("sun");
            this.fTaglibPrefixes.add("sunw");
            TLDCMDocumentManager manager = TaglibController.getTLDCMDocumentManager((IDocument)document);
            if (manager != null) {
                List trackers = manager.getTaglibTrackers();
                Iterator it = trackers.iterator();
                while (it.hasNext()) {
                    TaglibTracker tracker = (TaglibTracker)it.next();
                    if (tracker.getElements().getLength() == 0) continue;
                    String prefix = tracker.getPrefix();
                    this.fTaglibPrefixes.add(prefix);
                }
            }
        }
        return this.fTaglibPrefixes;
    }

    private boolean hasJSPRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        if (regions == null) {
            return false;
        }
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            String regionType;
            ITextRegion region = (ITextRegion)e.next();
            if (region == null || (regionType = region.getType()) != "XML_TAG_OPEN" && !this.isNestedTagName(regionType)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedTagName(String regionType) {
        boolean result = regionType.equals("JSP_SCRIPTLET_OPEN") || regionType.equals("JSP_EXPRESSION_OPEN") || regionType.equals("JSP_DECLARATION_OPEN") || regionType.equals("JSP_DIRECTIVE_OPEN");
        return result;
    }

    private void loadPreferences(IFile file) {
        ProjectScope projectScope;
        this.fScopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.fPreferencesService = Platform.getPreferencesService();
        if (file != null && file.isAccessible() && (projectScope = new ProjectScope(file.getProject())).getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
            this.fScopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        this.fSeverityMissingRequiredAttribute = this.getMessageSeverity("validation.actions-missing-required-attribute");
        this.fSeverityNonEmptyInlineTag = this.getMessageSeverity("validation.actions-non-empty-inline-tag");
        this.fSeverityUnknownAttribute = this.getMessageSeverity("validation.actions-unknown-attribute");
        this.fSeverityUnexpectedRuntimeExpression = this.getMessageSeverity("validation.actions-unexpected-rtexprvalue");
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        this.fTaglibPrefixes.clear();
        int length = model.getStructuredDocument().getLength();
        this.performValidation(f, reporter, model, (IRegion)new Region(0, length));
    }

    protected void performValidation(IFile f, IReporter reporter, IStructuredModel model, IRegion validateRegion) {
        this.loadPreferences(f);
        IStructuredDocument sDoc = model.getStructuredDocument();
        this.fIsELIgnored = this.isElIgnored(f.getFullPath(), model);
        IStructuredDocumentRegion region = sDoc.getRegionAtCharacterOffset(validateRegion.getOffset());
        while (region != null && !reporter.isCancelled() && region.getStartOffset() <= validateRegion.getOffset() + validateRegion.getLength()) {
            String tagName;
            int colonPosition;
            if (region.getType() == "JSP_DIRECTIVE_NAME") {
                this.processDirective(reporter, f, model, region);
                this.fTaglibPrefixes.clear();
            } else if (region.getType() == "XML_TAG_NAME" && (colonPosition = (tagName = this.getStartTagName(region)).indexOf(58)) > -1) {
                String prefix = tagName.substring(0, colonPosition);
                if (this.getTaglibPrefixes(sDoc).contains(prefix)) {
                    this.processDirective(reporter, f, model, region);
                }
            }
            region = region.getNext();
        }
        this.unloadPreferences();
    }

    private void processDirective(IReporter reporter, IFile file, IStructuredModel model, IStructuredDocumentRegion documentRegion) {
        IndexedRegion ir = model.getIndexedRegion(documentRegion.getStartOffset());
        if (ir instanceof IDOMElement) {
            CMElementDeclaration cmElement;
            IDOMElement element = (IDOMElement)ir;
            ModelQuery query = ModelQueryUtil.getModelQuery((IStructuredModel)model);
            if (query != null && (cmElement = query.getCMElementDeclaration((Element)element)) != null) {
                CMNamedNodeMapImpl cmAttributes = null;
                CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl();
                List nodes = query.getAvailableContent((Element)element, cmElement, 1);
                int k = 0;
                while (k < nodes.size()) {
                    CMNode cmnode = (CMNode)nodes.get(k);
                    if (cmnode.getNodeType() == 2) {
                        allAttributes.put(cmnode);
                    }
                    ++k;
                }
                cmAttributes = allAttributes;
                boolean foundjspattribute = this.checkUnknownAttributes(element, cmElement, (CMNamedNodeMap)cmAttributes, reporter, file, model.getStructuredDocument(), documentRegion);
                if (!foundjspattribute && this.fSeverityMissingRequiredAttribute != -1) {
                    this.checkRequiredAttributes(element, (CMNamedNodeMap)cmAttributes, reporter, file, model.getStructuredDocument(), documentRegion);
                }
                if (this.fSeverityNonEmptyInlineTag != -1) {
                    this.checkNonEmptyInlineTag(element, cmElement, reporter, file, model.getStructuredDocument());
                }
            }
        }
    }

    private void unloadPreferences() {
        this.fPreferencesService = null;
        this.fScopes = null;
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

