/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverrideColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseEmbeddedMapping<T extends AbstractXmlEmbedded>
extends AbstractOrmAttributeMapping<T>
implements OrmBaseEmbeddedMapping {
    protected OrmAttributeOverrideContainer attributeOverrideContainer;
    protected Embeddable targetEmbeddable = AbstractOrmBaseEmbeddedMapping.embeddableFor(this.getJavaPersistentAttribute());

    protected AbstractOrmBaseEmbeddedMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.attributeOverrideContainer = this.getXmlContextNodeFactory().buildOrmAttributeOverrideContainer(this, this.buildAttributeOverrideContainerOwner());
    }

    protected OrmAttributeOverrideContainer.Owner buildAttributeOverrideContainerOwner() {
        return new AttributeOverrideContainerOwner();
    }

    @Override
    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        super.initializeFromOrmBaseEmbeddedMapping(oldMapping);
        this.attributeOverrideContainer.initializeFromAttributeOverrideContainer(oldMapping.getAttributeOverrideContainer());
    }

    @Override
    public OrmAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected JavaAttributeOverride getJavaAttributeOverrideNamed(String attributeName) {
        if (this.getJavaEmbeddedMapping() != null) {
            return this.getJavaEmbeddedMapping().getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
        }
        return null;
    }

    @Override
    public Embeddable getTargetEmbeddable() {
        return this.targetEmbeddable;
    }

    protected void setTargetEmbeddable_(Embeddable newTargetEmbeddable) {
        Embeddable oldTargetEmbeddable = this.targetEmbeddable;
        this.targetEmbeddable = newTargetEmbeddable;
        this.firePropertyChanged("targetEmbeddable", oldTargetEmbeddable, newTargetEmbeddable);
    }

    protected Iterator<AttributeMapping> embeddableAttributeMappings() {
        Embeddable targetEmbeddable = this.getTargetEmbeddable();
        if (targetEmbeddable != null && targetEmbeddable != this.getPersistentAttribute().getOwningTypeMapping()) {
            return targetEmbeddable.attributeMappings();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverrideableAttributeMappingNames() : super.allOverrideableAttributeMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverrideableAssociationMappingNames() : super.allOverrideableAssociationMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    protected Iterator<String> embeddableOverrideableMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator<String, String>((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.embeddableAttributeMappings(), transformer))){

            protected String transform(String next) {
                return String.valueOf(AbstractOrmBaseEmbeddedMapping.this.getName()) + '.' + next;
            }
        };
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        int dotIndex;
        if (this.getName() == null) {
            return null;
        }
        if (this.isJpa2_0Compatible() && (dotIndex = attributeName.indexOf(46)) != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            attributeName = attributeName.substring(dotIndex + 1);
            OrmAttributeOverride override = this.getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
            if (override != null && !override.isVirtual()) {
                return override.getColumn();
            }
            if (this.getTargetEmbeddable() == null) {
                return null;
            }
            return this.getTargetEmbeddable().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    public JavaBaseEmbeddedMapping getJavaEmbeddedMapping() {
        JavaPersistentAttribute jpa = this.getJavaPersistentAttribute();
        if (jpa != null && this.valuesAreEqual(jpa.getMappingKey(), this.getKey())) {
            return (JavaBaseEmbeddedMapping)jpa.getMapping();
        }
        return null;
    }

    @Override
    public void update() {
        super.update();
        this.setTargetEmbeddable_(AbstractOrmBaseEmbeddedMapping.embeddableFor(this.getJavaPersistentAttribute()));
        this.getAttributeOverrideContainer().update();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.validateTargetEmbeddable(messages, reporter)) {
            this.validateOverrides(messages, reporter);
        }
    }

    protected boolean validateTargetEmbeddable(List<IMessage> messages, IReporter reporter) {
        if (this.getTargetEmbeddable() == null) {
            String targetEmbeddableTypeName = this.getPersistentAttribute().getTypeName();
            if (targetEmbeddableTypeName != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_NOT_AN_EMBEDDABLE", new String[]{targetEmbeddableTypeName}, this, this.getValidationTextRange()));
            }
            return false;
        }
        return true;
    }

    protected void validateOverrides(List<IMessage> messages, IReporter reporter) {
        this.getAttributeOverrideContainer().validate(messages, reporter);
    }

    public static Embeddable embeddableFor(JavaPersistentAttribute javaPersistentAttribute) {
        return javaPersistentAttribute == null ? null : javaPersistentAttribute.getEmbeddable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    implements OrmAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmBaseEmbeddedMapping.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmBaseEmbeddedMapping.this.getTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : this.allOverridableAttributeNames_(typeMapping);
        }

        protected Iterator<String> allOverridableAttributeNames_(TypeMapping typeMapping) {
            return typeMapping.allOverridableAttributeNames();
        }

        @Override
        public EList<XmlAttributeOverride> getResourceAttributeOverrides() {
            return ((AbstractXmlEmbedded)AbstractOrmBaseEmbeddedMapping.this.resourceAttributeMapping).getAttributeOverrides();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            JavaAttributeOverride javaAttributeOverride;
            if (AbstractOrmBaseEmbeddedMapping.this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete() && (javaAttributeOverride = AbstractOrmBaseEmbeddedMapping.this.getJavaAttributeOverrideNamed(attributeOverrideName)) != null && !javaAttributeOverride.isVirtual()) {
                return javaAttributeOverride.getColumn();
            }
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public XmlColumn buildVirtualXmlColumn(Column overridableColumn, String attributeName, boolean isMetadataComplete) {
            return new VirtualXmlAttributeOverrideColumn(overridableColumn);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return this.getTypeMapping().associatedTableNamesIncludingInherited();
        }

        @Override
        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (AbstractOrmBaseEmbeddedMapping.this.isVirtual()) {
                return this.buildVirtualAttributeUnresolvedColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideUnresolvedColumnNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualAttributeUnresolvedColumnTableNotValidMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{AbstractOrmBaseEmbeddedMapping.this.getName(), overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualOverrideUnresolvedColumnNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (AbstractOrmBaseEmbeddedMapping.this.isVirtual()) {
                return this.buildVirtualAttributeColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualAttributeColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{AbstractOrmBaseEmbeddedMapping.this.getName(), overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmBaseEmbeddedMapping.this.getValidationTextRange();
        }
    }
}

