/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.deploy.J2EEDeployOperation;
import org.eclipse.jst.j2ee.internal.dialogs.Messages;
import org.eclipse.jst.j2ee.internal.dialogs.RuntimeSelectionDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEDeployAction
extends BaseAction {
    protected void primRun(Shell shell) {
        if (this.checkEnabled(shell)) {
            final IStructuredSelection deploySelection = this.selection;
            Job deployJob = new Job(Messages.J2EEDeployAction_Deploy_){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus result = null;
                    J2EEDeployOperation op = new J2EEDeployOperation(deploySelection.toArray());
                    try {
                        result = op.execute(monitor, null);
                    }
                    catch (Exception e) {
                        result = new Status(4, "org.eclipse.wst.common.frameworks", 4, WTPResourceHandler.getString((String)"27"), (Throwable)e);
                        Logger.getLogger().logError((Throwable)e);
                    }
                    return result;
                }
            };
            try {
                deployJob.setUser(true);
                deployJob.schedule();
            }
            catch (Exception exception) {}
        }
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        super.selectionChanged(action, aSelection);
        action.setEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkEnabled(Shell shell) {
        try {
            DeployerRegistry reg = DeployerRegistry.instance();
            List components = DeployerRegistry.getSelectedModules((Object[])this.selection.toArray());
            int i = 0;
            while (true) {
                List visitors;
                if (i >= components.size()) {
                    return true;
                }
                IVirtualComponent component = (IVirtualComponent)components.get(i);
                IProject proj = component.getProject();
                if (proj == null) {
                    this.displayMessageDialog(J2EEUIMessages.getResourceString("DEPLOY_PROJECT_NOT_FOUND"), shell);
                    return false;
                }
                IRuntime runtime = J2EEProjectUtilities.getServerRuntime((IProject)proj);
                if (runtime == null) {
                    String message = MessageFormat.format(J2EEUIMessages.getResourceString("DEPLOY_RUNTIME_NOT_FOUND"), proj.getName());
                    RuntimeSelectionDialog selectionDialog = new RuntimeSelectionDialog(shell, J2EEUIMessages.getResourceString("DEPLOY_DIALOG_TITLE"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0, proj);
                    selectionDialog.open();
                    runtime = J2EEProjectUtilities.getServerRuntime((IProject)proj);
                    if (runtime == null) {
                        return false;
                    }
                }
                if ((visitors = reg.getDeployModuleExtensions(proj, runtime)).isEmpty()) {
                    this.displayMessageDialog(MessageFormat.format(J2EEUIMessages.getResourceString("DEPLOY_PROJECT_NOT_SUPPORTED"), proj.getName()), shell);
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            J2EEUIPlugin.logError(e);
            return false;
        }
    }

    private void displayMessageDialog(String message, Shell shell) {
        String title = J2EEUIMessages.getResourceString("DEPLOY_DIALOG_TITLE");
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }
}

