/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExceptionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.LocalTypeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.CodeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

class ExtractMethodAnalyzer
extends CodeAnalyzer {
    public static final int ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int NO = 0;
    public static final int EXPRESSION = 1;
    public static final int ACCESS_TO_LOCAL = 2;
    public static final int RETURN_STATEMENT_VOID = 3;
    public static final int RETURN_STATEMENT_VALUE = 4;
    public static final int MULTIPLE = 5;
    private BodyDeclaration fEnclosingBodyDeclaration;
    private IFunctionBinding fEnclosingMethodBinding;
    private int fMaxVariableId;
    private int fReturnKind;
    private Type fReturnType;
    private FlowInfo fInputFlowInfo;
    private FlowContext fInputFlowContext;
    private IVariableBinding[] fArguments;
    private IVariableBinding[] fMethodLocals;
    private ITypeBinding[] fTypeVariables;
    private IVariableBinding fReturnValue;
    private IVariableBinding[] fCallerLocals;
    private IVariableBinding fReturnLocal;
    private ITypeBinding[] fAllExceptions;
    private ITypeBinding fExpressionBinding;
    private boolean fForceStatic;
    private boolean fIsLastStatementSelected;
    static /* synthetic */ Class class$0;

    public ExtractMethodAnalyzer(IJavaScriptUnit unit, Selection selection) throws JavaScriptModelException {
        super(unit, selection, false);
    }

    public BodyDeclaration getEnclosingBodyDeclaration() {
        return this.fEnclosingBodyDeclaration;
    }

    public int getReturnKind() {
        return this.fReturnKind;
    }

    public boolean extractsExpression() {
        return this.fReturnKind == 1;
    }

    public Type getReturnType() {
        return this.fReturnType;
    }

    public boolean generateImport() {
        switch (this.fReturnKind) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public IVariableBinding[] getArguments() {
        return this.fArguments;
    }

    public IVariableBinding[] getMethodLocals() {
        return this.fMethodLocals;
    }

    public IVariableBinding getReturnValue() {
        return this.fReturnValue;
    }

    public IVariableBinding[] getCallerLocals() {
        return this.fCallerLocals;
    }

    public IVariableBinding getReturnLocal() {
        return this.fReturnLocal;
    }

    public ITypeBinding getExpressionBinding() {
        return this.fExpressionBinding;
    }

    public boolean getForceStatic() {
        return this.fForceStatic;
    }

    public ITypeBinding[] getTypeVariables() {
        return this.fTypeVariables;
    }

    public RefactoringStatus checkInitialConditions(ImportRewrite rewriter) {
        int returns;
        RefactoringStatus result = this.getStatus();
        this.checkExpression(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.fReturnKind = -1;
        this.fMaxVariableId = LocalVariableIndex.perform(this.fEnclosingBodyDeclaration);
        if (this.analyzeSelection(result).hasFatalError()) {
            return result;
        }
        int n = returns = this.fReturnKind == 0 ? 0 : 1;
        if (this.fReturnValue != null) {
            this.fReturnKind = 2;
            ++returns;
        }
        if (this.isExpressionSelected()) {
            this.fReturnKind = 1;
            ++returns;
        }
        if (returns > 1) {
            result.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_ambiguous_return_value, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = 5;
            return result;
        }
        this.initReturnType(rewriter);
        return result;
    }

    private void checkExpression(RefactoringStatus status) {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes != null && nodes.length == 1) {
            ASTNode node = nodes[0];
            if (node instanceof Type) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference, JavaStatusContext.create((ITypeRoot)this.fCUnit, node));
            } else if (node.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_switch_case, JavaStatusContext.create((ITypeRoot)this.fCUnit, node));
            }
        }
    }

    private void initReturnType(ImportRewrite rewriter) {
        AST ast = this.fEnclosingBodyDeclaration.getAST();
        this.fReturnType = null;
        switch (this.fReturnKind) {
            case 2: {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration(this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration);
                this.fReturnType = ASTNodeFactory.newType(ast, declaration);
                break;
            }
            case 1: {
                Expression expression = (Expression)this.getFirstSelectedNode();
                this.fExpressionBinding = expression.getNodeType() == 14 ? ((ClassInstanceCreation)expression).getType().resolveBinding() : expression.resolveTypeBinding();
                if (this.fExpressionBinding != null) {
                    if (this.fExpressionBinding.isNullType()) {
                        this.getStatus().addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_null_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                        break;
                    }
                    ITypeBinding normalizedBinding = Bindings.normalizeForDeclarationUse(this.fExpressionBinding, ast);
                    if (normalizedBinding == null) break;
                    this.fReturnType = rewriter.addImport(normalizedBinding, ast);
                    break;
                }
                this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
                this.getStatus().addError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_determine_return_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)expression));
                break;
            }
            case 4: {
                if (this.fEnclosingBodyDeclaration.getNodeType() != 31) break;
                this.fReturnType = ((FunctionDeclaration)this.fEnclosingBodyDeclaration).getReturnType2();
                break;
            }
            default: {
                this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
            }
        }
        if (this.fReturnType == null) {
            this.fReturnType = ast.newPrimitiveType(PrimitiveType.VOID);
        }
    }

    public boolean isLiteralNodeSelected() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length != 1) {
            return false;
        }
        ASTNode node = nodes[0];
        switch (node.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 87: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    public void checkInput(RefactoringStatus status, String methodName, AST ast) {
        ITypeBinding[] arguments = this.getArgumentTypes();
        ITypeBinding type = ASTNodes.getEnclosingType((ASTNode)this.fEnclosingBodyDeclaration);
        status.merge(Checks.checkMethodInType(type, methodName, arguments));
        status.merge(Checks.checkMethodInHierarchy(type.getSuperclass(), methodName, null, arguments));
    }

    private ITypeBinding[] getArgumentTypes() {
        ITypeBinding[] result = new ITypeBinding[this.fArguments.length];
        int i = 0;
        while (i < this.fArguments.length) {
            result[i] = this.fArguments[i].getType();
            ++i;
        }
        return result;
    }

    private RefactoringStatus analyzeSelection(RefactoringStatus status) {
        this.fInputFlowContext = new FlowContext(0, this.fMaxVariableId + 1);
        this.fInputFlowContext.setConsiderAccessMode(true);
        this.fInputFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(this.fInputFlowContext);
        this.fInputFlowInfo = flowAnalyzer.perform(this.getSelectedNodes());
        if (this.fInputFlowInfo.branches()) {
            status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = -2;
            return status;
        }
        if (this.fInputFlowInfo.isValueReturn()) {
            this.fReturnKind = 4;
        } else if (this.fInputFlowInfo.isVoidReturn() || this.fInputFlowInfo.isPartialReturn() && this.isVoidMethod() && this.isLastStatementSelected()) {
            this.fReturnKind = 3;
        } else if (this.fInputFlowInfo.isNoReturn() || this.fInputFlowInfo.isThrow() || this.fInputFlowInfo.isUndefined()) {
            this.fReturnKind = 0;
        }
        if (this.fReturnKind == -1) {
            status.addError(RefactoringCoreMessages.FlowAnalyzer_execution_flow, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            this.fReturnKind = 0;
        }
        this.computeInput();
        this.computeExceptions();
        this.computeOutput(status);
        if (status.hasFatalError()) {
            return status;
        }
        this.adjustArgumentsAndMethodLocals();
        this.compressArrays();
        return status;
    }

    private boolean isVoidMethod() {
        if (this.fEnclosingMethodBinding == null) {
            return true;
        }
        ITypeBinding binding = this.fEnclosingMethodBinding.getReturnType();
        return this.fEnclosingBodyDeclaration.getAST().resolveWellKnownType("void").equals((Object)binding);
    }

    public boolean isLastStatementSelected() {
        return this.fIsLastStatementSelected;
    }

    private void computeLastStatementSelected() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            this.fIsLastStatementSelected = false;
        } else {
            Block body = null;
            if (this.fEnclosingBodyDeclaration instanceof FunctionDeclaration) {
                body = ((FunctionDeclaration)this.fEnclosingBodyDeclaration).getBody();
            } else if (this.fEnclosingBodyDeclaration instanceof Initializer) {
                body = ((Initializer)this.fEnclosingBodyDeclaration).getBody();
            }
            if (body != null) {
                List statements = body.statements();
                this.fIsLastStatementSelected = nodes[nodes.length - 1] == statements.get(statements.size() - 1);
            }
        }
    }

    private void computeInput() {
        int argumentMode = 54;
        this.fArguments = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, argumentMode));
        this.fMethodLocals = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, 24));
        this.fTypeVariables = this.computeTypeVariables(this.fInputFlowInfo.getTypeVariables());
    }

    private IVariableBinding[] removeSelectedDeclarations(IVariableBinding[] bindings) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>(bindings.length);
        Selection selection = this.getSelection();
        int i = 0;
        while (i < bindings.length) {
            ASTNode decl = ((JavaScriptUnit)this.fEnclosingBodyDeclaration.getRoot()).findDeclaringNode((IBinding)bindings[i]);
            if (!selection.covers(decl)) {
                result.add(bindings[i]);
            }
            ++i;
        }
        return result.toArray(new IVariableBinding[result.size()]);
    }

    private ITypeBinding[] computeTypeVariables(ITypeBinding[] bindings) {
        Selection selection = this.getSelection();
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        JavaScriptUnit compilationUnit = (JavaScriptUnit)this.fEnclosingBodyDeclaration.getRoot();
        int i = 0;
        while (i < bindings.length) {
            ASTNode decl = compilationUnit.findDeclaringNode((IBinding)bindings[i]);
            if (decl == null || !selection.covers(decl) && decl.getParent() instanceof FunctionDeclaration) {
                result.add(bindings[i]);
            }
            ++i;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void computeOutput(RefactoringStatus status) {
        FlowContext flowContext = new FlowContext(0, this.fMaxVariableId + 1);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.RETURN_VALUES);
        FlowInfo returnInfo = new InOutFlowAnalyzer(flowContext).perform(this.getSelectedNodes());
        IVariableBinding[] returnValues = returnInfo.get(flowContext, 56);
        IRegion region = this.getSelectedNodeRange();
        Selection selection = Selection.createFromStartLength(region.getOffset(), region.getLength());
        int counter = 0;
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] reads = argInfo.get(flowContext, 38);
        int i = 0;
        while (i < returnValues.length && counter <= 1) {
            IVariableBinding binding = returnValues[i];
            int x = 0;
            while (x < reads.length) {
                if (reads[x] == binding) {
                    ++counter;
                    this.fReturnValue = binding;
                    break;
                }
                ++x;
            }
            ++i;
        }
        switch (counter) {
            case 0: {
                this.fReturnValue = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.fReturnValue = null;
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_assignments_to_local, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
                return;
            }
        }
        ArrayList<IVariableBinding> callerLocals = new ArrayList<IVariableBinding>(5);
        FlowInfo localInfo = new InputFlowAnalyzer(flowContext, selection, false).perform(this.fEnclosingBodyDeclaration);
        IVariableBinding[] writes = localInfo.get(flowContext, 56);
        int i2 = 0;
        while (i2 < writes.length) {
            IVariableBinding write = writes[i2];
            if (this.getSelection().covers(ASTNodes.findDeclaration((IBinding)write, (ASTNode)this.fEnclosingBodyDeclaration))) {
                callerLocals.add(write);
            }
            ++i2;
        }
        this.fCallerLocals = callerLocals.toArray(new IVariableBinding[callerLocals.size()]);
        if (this.fReturnValue != null && this.getSelection().covers(ASTNodes.findDeclaration((IBinding)this.fReturnValue, (ASTNode)this.fEnclosingBodyDeclaration))) {
            this.fReturnLocal = this.fReturnValue;
        }
    }

    private void adjustArgumentsAndMethodLocals() {
        int i = 0;
        while (i < this.fArguments.length) {
            IVariableBinding argument = this.fArguments[i];
            if (this.fInputFlowInfo.hasAccessMode(this.fInputFlowContext, argument, 16)) {
                if (argument != this.fReturnValue) {
                    this.fArguments[i] = null;
                }
                if (this.fArguments[i] != null) {
                    int l = 0;
                    while (l < this.fMethodLocals.length) {
                        if (this.fMethodLocals[l] == argument) {
                            this.fMethodLocals[l] = null;
                        }
                        ++l;
                    }
                }
            }
            ++i;
        }
    }

    private void compressArrays() {
        this.fArguments = this.compressArray(this.fArguments);
        this.fCallerLocals = this.compressArray(this.fCallerLocals);
        this.fMethodLocals = this.compressArray(this.fMethodLocals);
    }

    private IVariableBinding[] compressArray(IVariableBinding[] array) {
        if (array == null) {
            return null;
        }
        int size = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++size;
            }
            ++i;
        }
        if (size == array.length) {
            return array;
        }
        IVariableBinding[] result = new IVariableBinding[size];
        int i2 = 0;
        int r = 0;
        while (i2 < array.length) {
            if (array[i2] != null) {
                result[r++] = array[i2];
            }
            ++i2;
        }
        return result;
    }

    public void aboutToCreateChange() {
    }

    public ITypeBinding[] getExceptions(boolean includeRuntimeExceptions, AST ast) {
        if (includeRuntimeExceptions) {
            return this.fAllExceptions;
        }
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>(this.fAllExceptions.length);
        int i = 0;
        while (i < this.fAllExceptions.length) {
            ITypeBinding exception = this.fAllExceptions[i];
            if (includeRuntimeExceptions || !Bindings.isRuntimeException(exception)) {
                result.add(exception);
            }
            ++i;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void computeExceptions() {
        this.fAllExceptions = ExceptionAnalyzer.perform(this.getSelectedNodes());
    }

    protected void handleNextSelectedNode(ASTNode node) {
        super.handleNextSelectedNode(node);
        this.checkParent(node);
    }

    protected boolean handleSelectionEndsIn(ASTNode node) {
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_doesNotCover, JavaStatusContext.create((ITypeRoot)this.fCUnit, node));
        return super.handleSelectionEndsIn(node);
    }

    private void checkParent(ASTNode node) {
        ASTNode firstParent = this.getFirstSelectedNode().getParent();
        do {
            if ((node = node.getParent()) != firstParent) continue;
            return;
        } while (node != null);
        this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_parent_mismatch);
    }

    /*
     * Unable to fully structure code
     */
    public void endVisit(JavaScriptUnit node) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            status = this.getStatus();
                            if (status.hasFatalError()) break block12;
                            if (this.hasSelectedNodes()) break block13;
                            coveringNode = this.getLastCoveringNode();
                            if (coveringNode instanceof Block && coveringNode.getParent() instanceof FunctionDeclaration && (messages = ASTNodes.getMessages((ASTNode)(methodDecl = (FunctionDeclaration)coveringNode.getParent()), 0)).length > 0) {
                                status.addFatalError(Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors, methodDecl.getName().getIdentifier()), JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)methodDecl));
                            } else {
                                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_only_method_body);
                            }
                            break block12;
                        }
                        v0 = this.getFirstSelectedNode();
                        v1 = ExtractMethodAnalyzer.class$0;
                        if (v1 == null) {
                            try {
                                v1 = ExtractMethodAnalyzer.class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                            }
                            catch (ClassNotFoundException v2) {
                                throw new NoClassDefFoundError(v2.getMessage());
                            }
                        }
                        this.fEnclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent(v0, v1);
                        if (this.fEnclosingBodyDeclaration != null && (this.fEnclosingBodyDeclaration.getNodeType() == 31 || this.fEnclosingBodyDeclaration.getNodeType() == 28)) break block14;
                        status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_only_method_body);
                        break block12;
                    }
                    if (ASTNodes.getEnclosingType((ASTNode)this.fEnclosingBodyDeclaration) != null) break block15;
                    status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_compile_errors_no_parent_binding);
                    break block12;
                }
                if (this.fEnclosingBodyDeclaration.getNodeType() == 31) {
                    this.fEnclosingMethodBinding = ((FunctionDeclaration)this.fEnclosingBodyDeclaration).resolveBinding();
                }
                if (this.isSingleExpressionOrStatementSet()) break block16;
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_single_expression_or_set);
                break block12;
            }
            if (!this.isExpressionSelected()) ** GOTO lbl48
            expression = this.getFirstSelectedNode();
            if (!(expression instanceof Name)) ** GOTO lbl-1000
            name = (Name)expression;
            if (name.resolveBinding() instanceof ITypeBinding) {
                status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_type_reference);
            } else {
                if (name.resolveBinding() instanceof IFunctionBinding) {
                    status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_method_name_reference);
                }
                if (name.isSimpleName() && ((SimpleName)name).isDeclaration()) {
                    status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_name_in_declaration);
                } else lbl-1000:
                // 2 sources

                {
                    this.fForceStatic = ASTNodes.getParent(expression, 46) != null || ASTNodes.getParent(expression, 17) != null;
lbl48:
                    // 2 sources

                    status.merge(LocalTypeAnalyzer.perform(this.fEnclosingBodyDeclaration, this.getSelection()));
                    this.computeLastStatementSelected();
                }
            }
        }
        super.endVisit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        boolean result = super.visit(node);
        if (this.isFirstSelectedNode((ASTNode)node)) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_anonymous_type, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return result;
    }

    public boolean visit(Assignment node) {
        boolean result = super.visit(node);
        if (this.getSelection().getVisitSelectionMode((ASTNode)node.getLeftHandSide()) == 2) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_leftHandSideOfAssignment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return result;
    }

    public boolean visit(DoStatement node) {
        boolean result = super.visit(node);
        try {
            int actionStart = this.getTokenScanner().getTokenEndOffset(121, node.getStartPosition());
            if (this.getSelection().getOffset() == actionStart) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_after_do_keyword, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
                return false;
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    public boolean visit(FunctionDeclaration node) {
        Block body = node.getBody();
        if (body == null) {
            return false;
        }
        Selection selection = this.getSelection();
        int nodeStart = body.getStartPosition();
        int nodeExclusiveEnd = nodeStart + body.getLength();
        if (nodeStart >= selection.getOffset() || selection.getExclusiveEnd() >= nodeExclusiveEnd) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        return this.visitConstructorInvocation((ASTNode)node, super.visit(node));
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.visitConstructorInvocation((ASTNode)node, super.visit(node));
    }

    private boolean visitConstructorInvocation(ASTNode node, boolean superResult) {
        if (this.getSelection().getVisitSelectionMode(node) == 2) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_super_or_this, JavaStatusContext.create((ITypeRoot)this.fCUnit, node));
            return false;
        }
        return superResult;
    }

    public void endVisit(ForInStatement node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3 && node.getIterationVariable().equals((Object)this.getFirstSelectedNode())) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
        }
        super.endVisit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        boolean result = super.visit(node);
        if (this.isFirstSelectedNode((ASTNode)node)) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration_fragment, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)node));
            return false;
        }
        return result;
    }

    public void endVisit(ForStatement node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3) {
            if (node.initializers().contains(this.getFirstSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_initializer, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            } else if (node.updaters().contains(this.getLastSelectedNode())) {
                this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_for_updater, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
            }
        }
        super.endVisit(node);
    }

    public void endVisit(VariableDeclarationExpression node) {
        this.checkTypeInDeclaration(node.getType());
        super.endVisit(node);
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.checkTypeInDeclaration(node.getType());
        super.endVisit(node);
    }

    private boolean isFirstSelectedNode(ASTNode node) {
        return this.getSelection().getVisitSelectionMode(node) == 2 && this.getFirstSelectedNode() == node;
    }

    private void checkTypeInDeclaration(Type node) {
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 2 && this.getFirstSelectedNode() == node) {
            this.invalidSelection(RefactoringCoreMessages.ExtractMethodAnalyzer_cannot_extract_variable_declaration, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.getSelection()));
        }
    }

    private boolean isSingleExpressionOrStatementSet() {
        ASTNode first = this.getFirstSelectedNode();
        if (first == null) {
            return true;
        }
        return !(first instanceof Expression) || this.getSelectedNodes().length == 1;
    }
}

