/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import javax.wsdl.Part;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.InvokeWSDLSOAPOperationAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.transformer.FragmentTransformer;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;

public class InvokeWSDLSOAPOperationFormAction
extends InvokeWSDLSOAPOperationAction {
    public InvokeWSDLSOAPOperationFormAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        boolean resultsValid = true;
        super.processParsedResults(parser);
        String sourceContent = parser.getParameter("::sourceContent");
        if (sourceContent == null) {
            IXSDFragment frag;
            WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
            MessageQueue messageQueue = wsdlPerspective.getMessageQueue();
            WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
            for (SOAPHeader soapHeader : operElement.getSOAPHeaders()) {
                frag = operElement.getHeaderFragment(soapHeader);
                if (frag.processParameterValues(parser)) continue;
                Message message = soapHeader.getEMessage();
                org.eclipse.wst.wsdl.Part part = soapHeader.getEPart();
                messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_VALIDATING_PARAMETER", message.getQName() + " " + part.getName()));
                resultsValid = false;
            }
            for (Part part : operElement.getOrderedBodyParts()) {
                frag = operElement.getFragment(part);
                if (frag.processParameterValues(parser)) continue;
                messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_VALIDATING_PARAMETER", part.getName()));
                resultsValid = false;
            }
        }
        return resultsValid;
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new FragmentTransformer(this.controller_);
        return transformers;
    }
}

