/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;

public class CommentNodeFormatter
extends NodeFormatter {
    private static final String CR = "\r";
    private static final String LF = "\n";

    protected String adjustIndentations(String aString, String lineIndent, String singleIndent) {
        String result = new String();
        int indexOfLineDelimiter = StringUtils.indexOfLineDelimiter((String)aString);
        result = aString.substring(0, indexOfLineDelimiter);
        while (indexOfLineDelimiter != -1) {
            int lineDelimiterSize = 1;
            if (aString.length() >= indexOfLineDelimiter + 2 && aString.substring(indexOfLineDelimiter, indexOfLineDelimiter + 1).compareTo(CR) == 0 && aString.substring(indexOfLineDelimiter + 1, indexOfLineDelimiter + 2).compareTo(LF) == 0) {
                lineDelimiterSize = 2;
            }
            int indexOfNextLineDelimiter = StringUtils.indexOfLineDelimiter((String)aString, (int)(indexOfLineDelimiter + lineDelimiterSize));
            int indexOfNonblank = StringUtils.indexOfNonblank((String)aString, (int)indexOfLineDelimiter);
            if (indexOfNonblank != -1) {
                result = indexOfNextLineDelimiter == -1 ? String.valueOf(result) + lineIndent + singleIndent + aString.substring(indexOfNonblank) : (indexOfNextLineDelimiter != -1 && indexOfNextLineDelimiter < indexOfNonblank ? String.valueOf(result) + lineIndent + singleIndent : String.valueOf(result) + lineIndent + singleIndent + aString.substring(indexOfNonblank, indexOfNextLineDelimiter));
                indexOfLineDelimiter = indexOfNextLineDelimiter;
                continue;
            }
            result = indexOfNextLineDelimiter == -1 ? String.valueOf(result) + lineIndent : String.valueOf(result) + lineIndent + singleIndent;
            indexOfLineDelimiter = indexOfNextLineDelimiter;
        }
        return result;
    }

    protected void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node != null) {
            String nodeValue = node.getNodeValue();
            boolean lineDelimiterFoundInComment = StringUtils.containsLineDelimiter((String)nodeValue);
            if (lineDelimiterFoundInComment) {
                this.formatIndentationBeforeNode(node, formatContraints);
                String lineDelimiter = node.getModel().getStructuredDocument().getLineDelimiter();
                String lineIndent = formatContraints.getCurrentIndent();
                String singleIndent = this.getFormatPreferences().getIndent();
                String newNodevalue = this.adjustIndentations(nodeValue, String.valueOf(lineDelimiter) + lineIndent, singleIndent);
                if (nodeValue.compareTo(newNodevalue) != 0) {
                    node.setNodeValue(newNodevalue);
                }
            }
            if (this.nodeHasSiblings(node) && (node.getPreviousSibling() == null || node.getPreviousSibling().getNodeType() != 3 || StringUtils.containsLineDelimiter((String)node.getPreviousSibling().getNodeValue()) || node.getNextSibling() != null)) {
                this.formatIndentationAfterNode(node, formatContraints);
            }
        }
    }
}

