/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.util;

import java.util.Locale;
import org.eclipse.core.runtime.Platform;

public final class DirUtils {
    public static boolean isRTL() {
        return "rtl".equals(DirUtils.getDir());
    }

    public static String getDir() {
        String rtl = "rtl";
        String ltr = "ltr";
        String orientation = System.getProperty("eclipse.orientation");
        if (rtl.equals(orientation)) {
            return rtl;
        }
        if (ltr.equals(orientation)) {
            return ltr;
        }
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dir".equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length && "rtl".equalsIgnoreCase(args[i + 1])) {
                    return rtl;
                }
                return ltr;
            }
            ++i;
        }
        if (System.getProperty("osgi.nl.user") == null) {
            return ltr;
        }
        String locale = Platform.getNL();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if (locale.startsWith("ar") || locale.startsWith("fa") || locale.startsWith("he") || locale.startsWith("iw") || locale.startsWith("ur")) {
            return rtl;
        }
        return ltr;
    }
}

