/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.actions;

import org.eclipse.wst.ws.internal.explorer.platform.actions.ShowPerspectiveAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;

public final class SwitchPerspectiveFromFavoritesAction
extends ShowPerspectiveAction {
    public SwitchPerspectiveFromFavoritesAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String perspectiveContentFramesetCols = parser.getParameter("framesetColsPerspectiveContent");
        String actionsContainerFramesetRows = parser.getParameter("framesetRowsActionsContainer");
        if (perspectiveContentFramesetCols != null && actionsContainerFramesetRows != null) {
            this.propertyTable_.put("framesetColsPerspectiveContent", perspectiveContentFramesetCols);
            this.propertyTable_.put("framesetRowsActionsContainer", actionsContainerFramesetRows);
            return true;
        }
        return false;
    }

    public final boolean run() {
        String perspectiveContentFramesetCols = (String)this.propertyTable_.get("framesetColsPerspectiveContent");
        String actionsContainerFramesetRows = (String)this.propertyTable_.get("framesetRowsActionsContainer");
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        if (!perspectiveContentFramesetCols.startsWith("100%") && !perspectiveContentFramesetCols.endsWith("100%")) {
            favPerspective.setPerspectiveContentFramesetCols(perspectiveContentFramesetCols);
        }
        if (!actionsContainerFramesetRows.startsWith("100%") && !actionsContainerFramesetRows.endsWith("100%")) {
            favPerspective.setActionsContainerFramesetRows(actionsContainerFramesetRows);
        }
        return super.run();
    }

    public static final String getFormActionLink(int targetPerspectiveId, boolean forHistory) {
        StringBuffer formLink = new StringBuffer("wsdl/actions/SwitchPerspectiveFromWSDLActionJSP.jsp?");
        formLink.append("perspective").append('=').append(targetPerspectiveId);
        if (forHistory) {
            formLink.append('&').append("isHistory").append("=1");
        }
        return formLink.toString();
    }
}

