/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.ui.text.ITypingRunListener;
import org.eclipse.wst.jsdt.internal.ui.text.TypingRun;
import org.eclipse.wst.jsdt.internal.ui.text.TypingRunDetector;

public class SmartBackspaceManager {
    private ITextViewer fViewer;
    private BackspaceListener fBackspaceListener;
    private Map fSpecs;
    private TypingRunDetector fRunDetector;
    private ITypingRunListener fRunListener;

    public void register(UndoSpec spec) {
        if (this.fViewer == null) {
            throw new IllegalStateException();
        }
        this.ensureListenerInstalled();
        this.addEdit(spec);
    }

    private void addEdit(UndoSpec spec) {
        Integer i = new Integer(spec.triggerOffset);
        this.fSpecs.put(i, spec);
    }

    private UndoSpec removeEdit(int offset) {
        Integer i = new Integer(offset);
        UndoSpec spec = (UndoSpec)this.fSpecs.remove(i);
        return spec;
    }

    private void ensureListenerInstalled() {
        if (this.fBackspaceListener == null) {
            this.fBackspaceListener = new BackspaceListener();
            ITextViewer viewer = this.fViewer;
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).prependVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            } else {
                viewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            }
        }
    }

    private void ensureListenerRemoved() {
        if (this.fBackspaceListener != null) {
            ITextViewer viewer = this.fViewer;
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).removeVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            } else {
                viewer.getTextWidget().removeVerifyKeyListener((VerifyKeyListener)this.fBackspaceListener);
            }
            this.fBackspaceListener = null;
        }
    }

    private IDocument getDocument() {
        return this.fViewer.getDocument();
    }

    public void install(ITextViewer viewer) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.fViewer = viewer;
        this.fSpecs = new HashMap();
        this.fRunDetector = new TypingRunDetector();
        this.fRunDetector.install(viewer);
        this.fRunListener = new ITypingRunListener(){

            public void typingRunStarted(TypingRun run) {
            }

            public void typingRunEnded(TypingRun run, TypingRun.ChangeType reason) {
                if (reason == TypingRun.SELECTION) {
                    SmartBackspaceManager.this.fSpecs.clear();
                } else {
                    SmartBackspaceManager.this.prune();
                }
            }
        };
        this.fRunDetector.addTypingRunListener(this.fRunListener);
    }

    private void prune() {
        Iterator it = this.fSpecs.values().iterator();
        while (it.hasNext()) {
            UndoSpec spec = (UndoSpec)it.next();
            if (--spec.lives >= 0) continue;
            it.remove();
        }
    }

    public void uninstall() {
        if (this.fViewer != null) {
            this.fRunDetector.removeTypingRunListener(this.fRunListener);
            this.fRunDetector.uninstall();
            this.fRunDetector = null;
            this.ensureListenerRemoved();
            this.fViewer = null;
        }
    }

    private class BackspaceListener
    implements VerifyKeyListener {
        private BackspaceListener() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void verifyKey(VerifyEvent event) {
            int offset;
            UndoSpec spec;
            if (SmartBackspaceManager.this.fViewer == null || !this.isBackspace(event) || (spec = SmartBackspaceManager.this.removeEdit(offset = this.getCaretOffset())) == null) return;
            try {
                try {
                    this.beginChange();
                    int i = 0;
                    while (true) {
                        if (i >= spec.undoEdits.length) {
                            SmartBackspaceManager.this.fViewer.setSelectedRange(spec.selection.getOffset(), spec.selection.getLength());
                            if (spec.child != null) {
                                SmartBackspaceManager.this.register(spec.child);
                            }
                            break;
                        }
                        spec.undoEdits[i].apply(SmartBackspaceManager.this.getDocument(), 2);
                        ++i;
                    }
                }
                catch (MalformedTreeException malformedTreeException) {
                    block10: {
                        break block10;
                        catch (BadLocationException badLocationException) {}
                    }
                    Object var5_5 = null;
                    this.endChange();
                    return;
                }
                Object var5_7 = null;
                this.endChange();
                event.doit = false;
                return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.endChange();
                throw throwable;
            }
        }

        private void beginChange() {
            ITextViewer viewer = SmartBackspaceManager.this.fViewer;
            if (viewer instanceof TextViewer) {
                TextViewer v = (TextViewer)viewer;
                v.getRewriteTarget().beginCompoundChange();
            }
        }

        private void endChange() {
            ITextViewer viewer = SmartBackspaceManager.this.fViewer;
            if (viewer instanceof TextViewer) {
                TextViewer v = (TextViewer)viewer;
                v.getRewriteTarget().endCompoundChange();
            }
        }

        private boolean isBackspace(VerifyEvent event) {
            return event.doit && event.character == '\b' && event.stateMask == 0;
        }

        private int getCaretOffset() {
            ITextViewer viewer = SmartBackspaceManager.this.fViewer;
            Point point = viewer.getSelectedRange();
            return point.x;
        }
    }

    public static final class UndoSpec {
        private final int triggerOffset;
        private final IRegion selection;
        private final TextEdit[] undoEdits;
        private final UndoSpec child;
        int lives;

        public UndoSpec(int triggerOffset, IRegion selection, TextEdit[] edits, int lives, UndoSpec child) {
            Assert.isLegal((triggerOffset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((selection != null ? 1 : 0) != 0);
            Assert.isLegal((lives >= 0 ? 1 : 0) != 0);
            Assert.isLegal((edits != null ? 1 : 0) != 0);
            Assert.isLegal((edits.length > 0 ? 1 : 0) != 0);
            int i = 0;
            while (i < edits.length) {
                Assert.isLegal((edits[i] != null ? 1 : 0) != 0);
                ++i;
            }
            this.triggerOffset = triggerOffset;
            this.selection = selection;
            this.undoEdits = edits;
            this.lives = lives;
            this.child = child;
        }
    }
}

