/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.IJavaScriptElementMapper;
import org.eclipse.wst.jsdt.core.refactoring.RenameTypeArguments;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringHandleTransplanter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenamingNameSuggestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.Changes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class RenameTypeProcessor
extends JavaRenameProcessor
implements ITextUpdating,
IReferenceUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaScriptElementMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_MATCHING_STRATEGY = "matchStrategy";
    private static final GroupCategorySet CATEGORY_TYPE_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.type", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type_description));
    private static final GroupCategorySet CATEGORY_METHOD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.method", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method_description));
    private static final GroupCategorySet CATEGORY_FIELD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.field", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields_description));
    private static final GroupCategorySet CATEGORY_LOCAL_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.renameType.local", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables_description));
    private IType fType;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameTypeProcessor";
    private boolean fUpdateSimilarElements;
    private Map fFinalSimilarElementToName = null;
    private int fRenamingStrategy;
    private LinkedHashMap fPreloadedElementToName = null;
    private Map fPreloadedElementToSelection = null;
    private LinkedHashMap fPreloadedElementToNameDefault = null;
    private String fCachedNewName = null;
    private boolean fCachedRenameSimilarElements = false;
    private int fCachedRenamingStrategy = -1;
    private RefactoringStatus fCachedRefactoringStatus = null;
    static /* synthetic */ Class class$0;

    public RenameTypeProcessor(IType type) {
        this.fType = type;
        if (type != null) {
            this.setNewElementName(type.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fUpdateSimilarElements = false;
        this.fRenamingStrategy = 1;
    }

    public IType getType() {
        return this.fType;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fType);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaScriptElement)this.fType);
    }

    public Object[] getElements() {
        return new Object[]{this.fType};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fType, new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements()), this.createParticipantDescriptorFilter());
        if (this.isPrimaryType()) {
            IJavaScriptUnit cu = this.fType.getJavaScriptUnit();
            String newCUName = this.getNewCompilationUnit().getElementName();
            result.rename(cu, new RenameArguments(newCUName, this.getUpdateReferences()));
        }
        return result;
    }

    private boolean isPrimaryType() {
        String cuName = this.fType.getJavaScriptUnit().getElementName();
        String typeName = this.fType.getElementName();
        return Checks.isTopLevel(this.fType) && JavaScriptCore.removeJavaScriptLikeExtension((String)cuName).equals(typeName);
    }

    public String getCurrentElementName() {
        return this.fType.getElementName();
    }

    public String getCurrentElementQualifier() {
        return JavaModelUtil.getTypeContainerName(this.fType);
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkTypeName(newName);
        if (Checks.isAlreadyNamed((IJavaScriptElement)this.fType, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeRefactoring_choose_another_name);
        }
        return result;
    }

    public Object getNewElement() {
        if (Checks.isTopLevel(this.fType)) {
            return this.getNewCompilationUnit().getType(this.getNewElementName());
        }
        return this.fType.getDeclaringType().getType(this.getNewElementName());
    }

    private IJavaScriptUnit getNewCompilationUnit() {
        IJavaScriptUnit cu = this.fType.getJavaScriptUnit();
        if (this.isPrimaryType()) {
            IPackageFragment parent = this.fType.getPackageFragment();
            String renamedCUName = JavaModelUtil.getRenamedCUName(cu, this.getNewElementName());
            return parent.getJavaScriptUnit(renamedCUName);
        }
        return cu;
    }

    protected RenameArguments createRenameArguments() {
        return new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
    }

    protected IParticipantDescriptorFilter createParticipantDescriptorFilter() {
        if (!this.getUpdateSimilarDeclarations()) {
            return null;
        }
        return new ParticipantDescriptorFilter();
    }

    protected IFile[] getChangedFiles() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fQualifiedNameSearchResult != null) {
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        if (this.willRenameCU()) {
            result.add(ResourceUtil.getFile(this.fType.getJavaScriptUnit()));
        }
        return result.toArray(new IFile[result.size()]);
    }

    public int getSaveMode() {
        return 3;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getPackageFragment().isDefaultPackage() && !(this.fType.getParent() instanceof IType);
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        this.fFilePatterns = patterns;
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        String property;
        IProduct product = Platform.getProduct();
        return product == null || !"false".equalsIgnoreCase(property = product.getProperty("org.eclipse.wst.jsdt.ui.refactoring.handlesSimilarDeclarations"));
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        this.fUpdateSimilarElements = update;
    }

    public boolean getUpdateSimilarDeclarations() {
        return this.fUpdateSimilarElements;
    }

    public int getMatchStrategy() {
        return this.fRenamingStrategy;
    }

    public void setMatchStrategy(int selectedStrategy) {
        this.fRenamingStrategy = selectedStrategy;
    }

    public IJavaScriptElement[] getSimilarElements() {
        if (this.fFinalSimilarElementToName == null) {
            return null;
        }
        Set keys = this.fFinalSimilarElementToName.keySet();
        return keys.toArray(new IJavaScriptElement[keys.size()]);
    }

    public IResource getRefactoredResource(IResource element) {
        if (element instanceof IFile && Checks.isTopLevel(this.fType) && element.equals((Object)this.fType.getResource())) {
            return this.getNewCompilationUnit().getResource();
        }
        return element;
    }

    public IJavaScriptElement getRefactoredJavaScriptElement(IJavaScriptElement element) {
        if (element instanceof IJavaScriptUnit) {
            if (Checks.isTopLevel(this.fType) && element.equals(this.fType.getJavaScriptUnit())) {
                return this.getNewCompilationUnit();
            }
        } else if (element instanceof IMember) {
            IType newType = (IType)this.getNewElement();
            RefactoringHandleTransplanter transplanter = new RefactoringHandleTransplanter(this.fType, newType, this.fFinalSimilarElementToName);
            return transplanter.transplantHandle((IMember)element);
        }
        return element;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType primary = (IType)this.fType.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_does_not_exist, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fType.getJavaScriptUnit().getElementName()});
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fType = primary;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        int qualifiedNamesTicks;
        int createChangeTicks;
        RefactoringStatus result;
        block21: {
            int similarElementTicks;
            block20: {
                int affectedCusTicks;
                int referenceSearchTicks;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                RefactoringStatus refactoringStatus;
                                Assert.isNotNull((Object)this.fType, (String)"type");
                                Assert.isNotNull((Object)this.getNewElementName(), (String)"newName");
                                result = new RefactoringStatus();
                                referenceSearchTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 15 : 0;
                                affectedCusTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 10 : 1;
                                similarElementTicks = this.fUpdateSimilarElements ? 85 : 0;
                                createChangeTicks = 5;
                                qualifiedNamesTicks = this.fUpdateQualifiedNames ? 50 : 0;
                                try {
                                    pm.beginTask("", 12 + referenceSearchTicks + affectedCusTicks + similarElementTicks + createChangeTicks + qualifiedNamesTicks);
                                    pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
                                    this.fChangeManager = new TextChangeManager(true);
                                    result.merge(this.checkNewElementName(this.getNewElementName()));
                                    if (!result.hasFatalError()) break block16;
                                    refactoringStatus = result;
                                    Object var9_16 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_23 = null;
                                    pm.done();
                                    throw throwable;
                                }
                                pm.done();
                                return refactoringStatus;
                            }
                            result.merge(Checks.checkIfCuBroken((IMember)this.fType));
                            if (!result.hasFatalError()) break block17;
                            RefactoringStatus refactoringStatus = result;
                            Object var9_17 = null;
                            pm.done();
                            return refactoringStatus;
                        }
                        pm.worked(1);
                        result.merge(this.checkTypesInCompilationUnit());
                        pm.worked(1);
                        result.merge(this.checkForMethodsWithConstructorNames());
                        pm.worked(1);
                        result.merge(this.checkImportedTypes());
                        pm.worked(1);
                        if (Checks.isTopLevel(this.fType) && JdtFlags.isPublic((IMember)this.fType)) {
                            result.merge(Checks.checkCompilationUnitNewName(this.fType.getJavaScriptUnit(), this.getNewElementName()));
                        }
                        pm.worked(1);
                        if (this.isPrimaryType()) {
                            result.merge(this.checkNewPathValidity());
                        }
                        pm.worked(1);
                        result.merge(this.checkEnclosingTypes());
                        pm.worked(1);
                        result.merge(this.checkEnclosedTypes());
                        pm.worked(1);
                        result.merge(this.checkTypesInPackage());
                        pm.worked(1);
                        result.merge(this.checkTypesImportedInCu());
                        pm.worked(1);
                        if (!result.hasFatalError()) break block18;
                        RefactoringStatus refactoringStatus = result;
                        Object var9_18 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    result.merge(this.analyseEnclosedTypes());
                    pm.worked(1);
                    if (!result.hasFatalError()) break block19;
                    RefactoringStatus refactoringStatus = result;
                    Object var9_19 = null;
                    pm.done();
                    return refactoringStatus;
                }
                if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                    pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_searching);
                    result.merge(this.initializeReferences((IProgressMonitor)new SubProgressMonitor(pm, referenceSearchTicks)));
                } else {
                    this.fReferences = new SearchResultGroup[0];
                }
                pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                    result.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, affectedCusTicks)));
                } else {
                    Checks.checkCompileErrorsInAffectedFile(result, this.fType.getResource());
                    pm.worked(affectedCusTicks);
                }
                if (!result.hasFatalError()) break block20;
                RefactoringStatus refactoringStatus = result;
                Object var9_20 = null;
                pm.done();
                return refactoringStatus;
            }
            if (!this.fUpdateSimilarElements) break block21;
            result.merge(this.initializeSimilarElementsRenameProcessors((IProgressMonitor)new SubProgressMonitor(pm, similarElementTicks), context));
            if (!result.hasFatalError()) break block21;
            RefactoringStatus refactoringStatus = result;
            Object var9_21 = null;
            pm.done();
            return refactoringStatus;
        }
        this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, createChangeTicks));
        if (this.fUpdateQualifiedNames) {
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, qualifiedNamesTicks));
        }
        RefactoringStatus refactoringStatus = result;
        Object var9_22 = null;
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus initializeReferences(IProgressMonitor monitor) throws JavaScriptModelException, OperationCanceledException {
        Assert.isNotNull((Object)this.fType);
        Assert.isNotNull((Object)this.getNewElementName());
        if (this.fReferences != null && this.getNewElementName().equals(this.fCachedNewName) && this.fCachedRenameSimilarElements == this.getUpdateSimilarDeclarations() && this.fCachedRenamingStrategy == this.fRenamingStrategy) {
            return this.fCachedRefactoringStatus;
        }
        this.fCachedNewName = this.getNewElementName();
        this.fCachedRenameSimilarElements = this.fUpdateSimilarElements;
        this.fCachedRenamingStrategy = this.fRenamingStrategy;
        this.fCachedRefactoringStatus = new RefactoringStatus();
        try {
            SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)this.fType, (int)2, (int)24);
            this.fReferences = RefactoringSearchEngine.search(pattern, RefactoringScopeFactory.create((IJavaScriptElement)this.fType), new TypeOccurrenceCollector(this.fType), monitor, this.fCachedRefactoringStatus);
            this.fReferences = Checks.excludeCompilationUnits(this.fReferences, this.fCachedRefactoringStatus);
            this.fPreloadedElementToName = new LinkedHashMap();
            this.fPreloadedElementToSelection = new HashMap();
            String unQualifiedTypeName = this.fType.getElementName();
            monitor.beginTask("", this.fReferences.length);
            if (this.getUpdateSimilarDeclarations()) {
                RenamingNameSuggestor sugg = new RenamingNameSuggestor(this.fRenamingStrategy);
                int i = 0;
                while (i < this.fReferences.length) {
                    IJavaScriptUnit cu = this.fReferences[i].getCompilationUnit();
                    if (cu != null) {
                        SearchMatch[] results = this.fReferences[i].getSearchResults();
                        int j = 0;
                        while (j < results.length) {
                            if (results[j] instanceof TypeReferenceMatch) {
                                TypeReferenceMatch match = (TypeReferenceMatch)results[j];
                                ArrayList<Object> matches = new ArrayList<Object>();
                                if (match.getLocalElement() != null) {
                                    matches.add(match.getLocalElement());
                                } else {
                                    matches.add(match.getElement());
                                }
                                IJavaScriptElement[] others = match.getOtherElements();
                                if (others != null) {
                                    matches.addAll(Arrays.asList(others));
                                }
                                Iterator iter = matches.iterator();
                                while (iter.hasNext()) {
                                    boolean isParameter;
                                    IField currentField;
                                    String newFieldName;
                                    IJavaScriptElement element = (IJavaScriptElement)iter.next();
                                    if (!(element instanceof IFunction) && !(element instanceof IField) && !(element instanceof ILocalVariable) || !this.isInDeclaredType(match.getOffset(), element)) continue;
                                    if (element instanceof IField && (newFieldName = sugg.suggestNewFieldName((currentField = (IField)element).getJavaScriptProject(), currentField.getElementName(), Flags.isStatic((int)currentField.getFlags()), unQualifiedTypeName, this.getNewElementName())) != null) {
                                        this.fPreloadedElementToName.put(currentField, newFieldName);
                                    }
                                    if (element instanceof IFunction) {
                                        IFunction currentMethod = (IFunction)element;
                                        this.addMethodRename(unQualifiedTypeName, sugg, currentMethod);
                                    }
                                    if (!(element instanceof ILocalVariable)) continue;
                                    ILocalVariable currentLocal = (ILocalVariable)element;
                                    if (JavaModelUtil.isParameter(currentLocal)) {
                                        this.addMethodRename(unQualifiedTypeName, sugg, (IFunction)currentLocal.getParent());
                                        isParameter = true;
                                    } else {
                                        isParameter = false;
                                    }
                                    String newLocalName = sugg.suggestNewLocalName(currentLocal.getJavaScriptProject(), currentLocal.getElementName(), isParameter, unQualifiedTypeName, this.getNewElementName());
                                    if (newLocalName == null) continue;
                                    this.fPreloadedElementToName.put(currentLocal, newLocalName);
                                }
                            }
                            ++j;
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    ++i;
                }
            }
            Iterator iter = this.fPreloadedElementToName.keySet().iterator();
            while (iter.hasNext()) {
                IJavaScriptElement element = (IJavaScriptElement)iter.next();
                this.fPreloadedElementToSelection.put(element, Boolean.TRUE);
            }
            this.fPreloadedElementToNameDefault = (LinkedHashMap)this.fPreloadedElementToName.clone();
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fReferences = null;
            this.fPreloadedElementToName = null;
            throw new OperationCanceledException();
        }
        return this.fCachedRefactoringStatus;
    }

    private boolean isInDeclaredType(int matchOffset, IJavaScriptElement parentElement) throws JavaScriptModelException {
        if (parentElement != null) {
            int enclosingNameOffset = 0;
            if (parentElement instanceof IFunction || parentElement instanceof IField) {
                enclosingNameOffset = ((IMember)parentElement).getNameRange().getOffset();
            } else if (parentElement instanceof ILocalVariable) {
                enclosingNameOffset = ((ILocalVariable)parentElement).getNameRange().getOffset();
            }
            return matchOffset < enclosingNameOffset;
        }
        return false;
    }

    private void addMethodRename(String unQualifiedTypeName, RenamingNameSuggestor sugg, IFunction currentMethod) throws JavaScriptModelException {
        String newMethodName;
        if (!currentMethod.isConstructor() && (newMethodName = sugg.suggestNewMethodName(currentMethod.getElementName(), unQualifiedTypeName, this.getNewElementName())) != null) {
            this.fPreloadedElementToName.put(currentMethod, newMethodName);
        }
    }

    private RefactoringStatus checkNewPathValidity() {
        IContainer c = this.fType.getJavaScriptUnit().getResource().getParent();
        String notRename = RefactoringCoreMessages.RenameTypeRefactoring_will_not_rename;
        IStatus status = c.getWorkspace().validateName(this.getNewElementName(), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        status = c.getWorkspace().validatePath(this.createNewPath(this.getNewElementName()), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String newName) {
        return this.fType.getJavaScriptUnit().getResource().getFullPath().removeLastSegments(1).append(newName).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws CoreException {
        IImportDeclaration imp = RenameTypeProcessor.getImportedType(this.fType.getJavaScriptUnit(), this.getNewElementName());
        if (imp == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_imported, new Object[]{this.getNewElementName(), this.fType.getJavaScriptUnit().getResource().getFullPath()});
        IJavaScriptElement grandParent = imp.getParent().getParent();
        if (grandParent instanceof IJavaScriptUnit) {
            return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create(imp));
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.getNewElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_exists, new String[]{this.getNewElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)type));
    }

    private RefactoringStatus checkEnclosedTypes() throws CoreException {
        IType enclosedType = RenameTypeProcessor.findEnclosedType(this.fType, this.getNewElementName());
        if (enclosedType == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_encloses, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosedType));
    }

    private RefactoringStatus checkEnclosingTypes() {
        IType enclosingType = RenameTypeProcessor.findEnclosingType(this.fType, this.getNewElementName());
        if (enclosingType == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed, new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosingType));
    }

    private static IType findEnclosedType(IType type, String newName) throws CoreException {
        IType[] enclosedTypes = type.getTypes();
        int i = 0;
        while (i < enclosedTypes.length) {
            if (newName.equals(enclosedTypes[i].getElementName()) || RenameTypeProcessor.findEnclosedType(enclosedTypes[i], newName) != null) {
                return enclosedTypes[i];
            }
            ++i;
        }
        return null;
    }

    private static IType findEnclosingType(IType type, String newName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(IJavaScriptUnit cu, String typeName) throws CoreException {
        IImportDeclaration[] imports = cu.getImports();
        String dotTypeName = "." + typeName;
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().endsWith(dotTypeName)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkForMethodsWithConstructorNames() throws CoreException {
        IFunction[] methods = this.fType.getFunctions();
        int i = 0;
        while (i < methods.length) {
            RefactoringStatus check;
            if (!methods[i].isConstructor() && (check = Checks.checkIfConstructorName(methods[i], methods[i].getElementName(), this.getNewElementName())) != null) {
                return check;
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkImportedTypes() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IImportDeclaration[] imports = this.fType.getJavaScriptUnit().getImports();
        int i = 0;
        while (i < imports.length) {
            this.analyzeImportDeclaration(imports[i], result);
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypesInCompilationUnit() {
        IType siblingType;
        RefactoringStatus result = new RefactoringStatus();
        if (!Checks.isTopLevel(this.fType) && (siblingType = this.fType.getDeclaringType().getType(this.getNewElementName())).exists()) {
            String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type_exists, new String[]{this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(this.fType.getDeclaringType())});
            result.addError(msg, JavaStatusContext.create((IMember)siblingType));
        }
        return result;
    }

    private RefactoringStatus analyseEnclosedTypes() throws CoreException {
        final ISourceRange typeRange = this.fType.getSourceRange();
        final RefactoringStatus result = new RefactoringStatus();
        JavaScriptUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)this.fType.getJavaScriptUnit(), false);
        cuNode.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                if (node.getStartPosition() <= typeRange.getOffset()) {
                    return true;
                }
                if (node.getStartPosition() > typeRange.getOffset() + typeRange.getLength()) {
                    return true;
                }
                if (RenameTypeProcessor.this.getNewElementName().equals(node.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getJavaScriptUnit(), (ASTNode)node);
                    String msg = null;
                    if (node.isLocalTypeDeclaration()) {
                        msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_local_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    } else if (node.isMemberTypeDeclaration()) {
                        msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    }
                    if (msg != null) {
                        result.addError(msg, context);
                    }
                }
                FunctionDeclaration[] methods = node.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isNative((int)methods[i].getModifiers())) {
                        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getJavaScriptUnit(), (ASTNode)methods[i]);
                        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed_type_native, node.getName().getIdentifier());
                        result.addWarning(msg, context);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result;
    }

    private static IJavaScriptUnit getCompilationUnit(IImportDeclaration imp) {
        return (IJavaScriptUnit)imp.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] types, RefactoringStatus result, IImportDeclaration imp) throws CoreException {
        int i = 0;
        while (i < types.length) {
            if (JdtFlags.isPublic((IMember)types[i]) && types[i].getElementName().equals(this.getNewElementName())) {
                String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_name_conflict1, new Object[]{JavaModelUtil.getFullyQualifiedName(types[i]), RenameTypeProcessor.getFullPath(RenameTypeProcessor.getCompilationUnit(imp))});
                result.addError(msg, JavaStatusContext.create(imp));
            }
            ++i;
        }
    }

    private static IJavaScriptElement convertFromImportDeclaration(IImportDeclaration declaration) throws CoreException {
        if (declaration.isOnDemand()) {
            String packageName = declaration.getElementName().substring(0, declaration.getElementName().length() - 2);
            return JavaModelUtil.findTypeContainer(declaration.getJavaScriptProject(), packageName);
        }
        return JavaModelUtil.findTypeContainer(declaration.getJavaScriptProject(), declaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration imp, RefactoringStatus result) throws CoreException {
        if (!imp.isOnDemand()) {
            return;
        }
        IJavaScriptElement imported = RenameTypeProcessor.convertFromImportDeclaration(imp);
        if (imported == null) {
            return;
        }
        if (imported instanceof IPackageFragment) {
            IJavaScriptUnit[] cus = ((IPackageFragment)imported).getJavaScriptUnits();
            int i = 0;
            while (i < cus.length) {
                this.analyzeImportedTypes(cus[i].getTypes(), result, imp);
                ++i;
            }
        } else {
            this.analyzeImportedTypes(((IType)imported).getTypes(), result, imp);
        }
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences, this.fType.getResource()));
        pm.beginTask("", this.fReferences.length);
        result.merge(this.checkConflictingTypes(pm));
        return result;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)this.fType);
        SearchPattern pattern = SearchPattern.createPattern((String)this.getNewElementName(), (int)0, (int)3, (int)24);
        IJavaScriptUnit[] cusWithReferencesToConflictingTypes = RefactoringSearchEngine.findAffectedCompilationUnits(pattern, scope, pm, result);
        if (cusWithReferencesToConflictingTypes.length == 0) {
            return result;
        }
        IJavaScriptUnit[] cusWithReferencesToRenamedType = RenameTypeProcessor.getCus(this.fReferences);
        IJavaScriptUnit[] intersection = RenameTypeProcessor.isIntersectionEmpty(cusWithReferencesToRenamedType, cusWithReferencesToConflictingTypes);
        if (intersection.length == 0) {
            return result;
        }
        int i = 0;
        while (i < intersection.length) {
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)intersection[i]);
            String message = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_another_type, new String[]{this.getNewElementName(), intersection[i].getElementName()});
            result.addError(message, context);
            ++i;
        }
        return result;
    }

    private static IJavaScriptUnit[] isIntersectionEmpty(IJavaScriptUnit[] a1, IJavaScriptUnit[] a2) {
        HashSet<IJavaScriptUnit> set1 = new HashSet<IJavaScriptUnit>(Arrays.asList(a1));
        HashSet<IJavaScriptUnit> set2 = new HashSet<IJavaScriptUnit>(Arrays.asList(a2));
        set1.retainAll(set2);
        return set1.toArray(new IJavaScriptUnit[set1.size()]);
    }

    private static IJavaScriptUnit[] getCus(SearchResultGroup[] searchResultGroups) {
        ArrayList<IJavaScriptUnit> cus = new ArrayList<IJavaScriptUnit>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            IJavaScriptUnit cu = searchResultGroups[i].getCompilationUnit();
            if (cu != null) {
                cus.add(cu);
            }
            ++i;
        }
        return cus.toArray(new IJavaScriptUnit[cus.size()]);
    }

    private static String getFullPath(IJavaScriptUnit cu) {
        Assert.isTrue((boolean)cu.exists());
        return cu.getResource().getFullPath().toString();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            TextChange textChange;
            monitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 4);
            String project = null;
            IJavaScriptProject javaProject = this.fType.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            try {
                if (!Flags.isPrivate((int)this.fType.getFlags())) {
                    flags |= 4;
                }
                if (this.fType.isAnonymous() || this.fType.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description_short, this.fType.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaScriptElementDescriptor descriptor = new RenameJavaScriptElementDescriptor("org.eclipse.wst.jsdt.ui.rename.type");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setJavaElement((IJavaScriptElement)this.fType);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
            descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            descriptor.setUpdateReferences(this.fUpdateReferences);
            if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                descriptor.setFileNamePatterns(this.fFilePatterns);
            }
            descriptor.setUpdateSimilarDeclarations(this.fUpdateSimilarElements);
            descriptor.setMatchStrategy(this.fRenamingStrategy);
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameTypeProcessor_change_name);
            if (this.fChangeManager.containsChangesIn(this.fType.getJavaScriptUnit()) && (textChange = this.fChangeManager.get(this.fType.getJavaScriptUnit())) instanceof TextFileChange) {
                ((TextFileChange)textChange).setSaveMode(2);
            }
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            if (this.willRenameCU()) {
                IResource resource = this.fType.getJavaScriptUnit().getResource();
                if (resource != null && resource.isLinked()) {
                    String ext = resource.getFileExtension();
                    String renamedResourceName = ext == null ? this.getNewElementName() : String.valueOf(this.getNewElementName()) + '.' + ext;
                    result.add(new RenameResourceChange(null, this.fType.getJavaScriptUnit().getResource(), renamedResourceName, comment));
                } else {
                    String renamedCUName = JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.getNewElementName());
                    result.add(new RenameCompilationUnitChange(this.fType.getJavaScriptUnit(), renamedCUName));
                }
            }
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            Object var13_16 = null;
            this.fChangeManager = null;
            return dynamicValidationRefactoringChange;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.fChangeManager = null;
            throw throwable;
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            try {
                Change change = this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
                Object var3_4 = null;
                this.fQualifiedNameSearchResult = null;
                return change;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fQualifiedNameSearchResult = null;
                throw throwable;
            }
        }
        return null;
    }

    private boolean willRenameCU() throws CoreException {
        String name = JavaScriptCore.removeJavaScriptLikeExtension((String)this.fType.getJavaScriptUnit().getElementName());
        if (!Checks.isTopLevel(this.fType) || !name.equals(this.fType.getElementName())) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkCompilationUnitNewName(this.fType.getJavaScriptUnit(), this.getNewElementName()).isOK();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createChanges(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 12);
            pm.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_creating_changes);
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            IResource resource = this.fType.getJavaScriptUnit().getResource();
            if (resource != null && resource.isLinked() || !this.willRenameCU()) {
                this.addTypeDeclarationUpdate(this.fChangeManager);
                pm.worked(1);
                this.addConstructorRenames(this.fChangeManager);
                pm.worked(1);
            } else {
                pm.worked(2);
            }
            if (this.fUpdateTextualMatches) {
                pm.subTask(RefactoringCoreMessages.RenameTypeRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(pm, 1), RefactoringScopeFactory.create((IJavaScriptElement)this.fType), this, this.fChangeManager, this.fReferences);
                if (this.fUpdateSimilarElements) {
                    this.addSimilarElementsTextualUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        pm.done();
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.RenameTypeRefactoring_update;
        int typeNameLength = this.fType.getElementName().length();
        IJavaScriptUnit cu = this.fType.getJavaScriptUnit();
        TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(this.fType.getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
    }

    private void addConstructorRenames(TextChangeManager manager) throws CoreException {
        IJavaScriptUnit cu = this.fType.getJavaScriptUnit();
        IFunction[] methods = this.fType.getFunctions();
        int typeNameLength = this.fType.getElementName().length();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                String name = RefactoringCoreMessages.RenameTypeRefactoring_rename_constructor;
                TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(methods[i].getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
            }
            ++i;
        }
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            IJavaScriptUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                String name = RefactoringCoreMessages.RenameTypeRefactoring_update_reference;
                SearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch match = results[j];
                    ReplaceEdit replaceEdit = new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
                    TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)replaceEdit, CATEGORY_TYPE_RENAME);
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        IPackageFragment fragment = this.fType.getPackageFragment();
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fType.getFullyQualifiedName(), String.valueOf(fragment.getElementName()) + "." + this.getNewElementName(), this.fFilePatterns, this.fType.getJavaScriptProject().getProject(), pm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 7) {
            return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.type");
        }
        this.fType = (IType)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
        if (patterns != null && !"".equals(patterns)) {
            this.fFilePatterns = patterns;
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(matches);
        String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
        if (qualified == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
        }
        this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
        String similarDeclarations = extended.getAttribute(ATTRIBUTE_SIMILAR_DECLARATIONS);
        if (similarDeclarations == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SIMILAR_DECLARATIONS));
        }
        this.fUpdateSimilarElements = Boolean.valueOf(similarDeclarations);
        String similarDeclarationsMatchingStrategy = extended.getAttribute(ATTRIBUTE_MATCHING_STRATEGY);
        if (similarDeclarationsMatchingStrategy == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MATCHING_STRATEGY));
        try {
            this.fRenamingStrategy = Integer.valueOf(similarDeclarationsMatchingStrategy);
            return new RefactoringStatus();
        }
        catch (NumberFormatException numberFormatException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{similarDeclarationsMatchingStrategy, ATTRIBUTE_QUALIFIED}));
        }
    }

    private RefactoringStatus initializeSimilarElementsRenameProcessors(IProgressMonitor progressMonitor, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fPreloadedElementToName);
        Assert.isNotNull((Object)this.fPreloadedElementToSelection);
        RefactoringStatus status = new RefactoringStatus();
        HashSet<IFunction> handledTopLevelMethods = new HashSet<IFunction>();
        HashSet warnings = new HashSet();
        ArrayList<RenameLocalVariableProcessor> processors = new ArrayList<RenameLocalVariableProcessor>();
        this.fFinalSimilarElementToName = new HashMap();
        JavaScriptUnit currentResolvedCU = null;
        IJavaScriptUnit currentCU = null;
        int current = 0;
        int max = this.fPreloadedElementToName.size();
        progressMonitor.beginTask("", max * 3);
        progressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_checking_similarly_named_declarations_refactoring_conditions);
        Iterator iter = this.fPreloadedElementToName.keySet().iterator();
        while (iter.hasNext()) {
            IJavaScriptElement element = (IJavaScriptElement)iter.next();
            ++current;
            progressMonitor.worked(3);
            if (!((Boolean)this.fPreloadedElementToSelection.get(element)).booleanValue() || this.fFinalSimilarElementToName.containsKey(element)) continue;
            IJavaScriptUnit newCU = (IJavaScriptUnit)element.getAncestor(5);
            if (!newCU.equals(currentCU)) {
                this.checkCUCompleteConditions(status, currentResolvedCU, currentCU, processors);
                if (status.hasFatalError()) {
                    return status;
                }
                currentResolvedCU = null;
                currentCU = newCU;
                processors.clear();
            }
            String newName = (String)this.fPreloadedElementToName.get(element);
            JavaRenameProcessor processor = null;
            if (element instanceof ILocalVariable) {
                ILocalVariable currentLocal = (ILocalVariable)element;
                if (currentResolvedCU == null) {
                    currentResolvedCU = new RefactoringASTParser(3).parse((ITypeRoot)currentCU, true);
                }
                processor = this.createLocalRenameProcessor(currentLocal, newName, currentResolvedCU);
                if (status.hasFatalError()) {
                    return status;
                }
                this.fFinalSimilarElementToName.put(currentLocal, newName);
            }
            if (element instanceof IField) {
                IField currentField = (IField)element;
                processor = this.createFieldRenameProcessor(currentField, newName);
                status.merge(this.checkForConflictingRename(currentField, newName));
                if (status.hasFatalError()) {
                    return status;
                }
                this.fFinalSimilarElementToName.put(currentField, newName);
            }
            if (element instanceof IFunction) {
                IFunction currentMethod = (IFunction)element;
                if (MethodChecks.isVirtual(currentMethod)) {
                    IFunction topmost;
                    IType declaringType = currentMethod.getDeclaringType();
                    ITypeHierarchy hierarchy = null;
                    if (!declaringType.isInterface()) {
                        hierarchy = declaringType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    }
                    if ((topmost = MethodChecks.getTopmostMethod(currentMethod, hierarchy, (IProgressMonitor)new NullProgressMonitor())) != null) {
                        currentMethod = topmost;
                    }
                    if (handledTopLevelMethods.contains(currentMethod)) continue;
                    handledTopLevelMethods.add(currentMethod);
                    IFunction[] ripples = MethodChecks.getOverriddenMethods(currentMethod, (IProgressMonitor)new NullProgressMonitor());
                    if (this.checkForWarnings(warnings, newName, ripples)) continue;
                    status.merge(this.checkForConflictingRename(ripples, newName));
                    if (status.hasFatalError()) {
                        return status;
                    }
                    processor = this.createVirtualMethodRenameProcessor(currentMethod, newName, ripples, hierarchy);
                    this.fFinalSimilarElementToName.put(currentMethod, newName);
                    int i = 0;
                    while (i < ripples.length) {
                        this.fFinalSimilarElementToName.put(ripples[i], newName);
                        ++i;
                    }
                } else {
                    status.merge(this.checkForConflictingRename(new IFunction[]{currentMethod}, newName));
                    if (status.hasFatalError()) break;
                    this.fFinalSimilarElementToName.put(currentMethod, newName);
                    processor = this.createNonVirtualMethodRenameProcessor(currentMethod, newName);
                }
            }
            progressMonitor.subTask(Messages.format(RefactoringCoreMessages.RenameTypeProcessor_progress_current_total, new Object[]{String.valueOf(current), String.valueOf(max)}));
            status.merge(processor.checkInitialConditions((IProgressMonitor)new NoOverrideProgressMonitor(progressMonitor, 1)));
            if (status.hasFatalError()) {
                return status;
            }
            status.merge(processor.checkFinalConditions((IProgressMonitor)new NoOverrideProgressMonitor(progressMonitor, 1), context));
            if (status.hasFatalError()) {
                return status;
            }
            processors.add((RenameLocalVariableProcessor)processor);
            progressMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.checkCUCompleteConditions(status, currentResolvedCU, currentCU, processors);
        status.merge(this.addWarnings(warnings));
        progressMonitor.done();
        return status;
    }

    private void checkCUCompleteConditions(RefactoringStatus status, JavaScriptUnit currentResolvedCU, IJavaScriptUnit currentCU, List processors) throws CoreException {
        List locals;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(locals = this.getProcessorsOfType(processors, clazz)).isEmpty()) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] analyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[locals.size()];
            TextChangeManager manager = new TextChangeManager();
            int current = 0;
            TextChange textChange = manager.get(currentCU);
            textChange.setKeepPreviewEdits(true);
            Iterator iterator = locals.iterator();
            while (iterator.hasNext()) {
                RenameAnalyzeUtil.LocalAnalyzePackage analyzePackage;
                RenameLocalVariableProcessor localProcessor = (RenameLocalVariableProcessor)iterator.next();
                analyzePackages[current] = analyzePackage = localProcessor.getLocalAnalyzePackage();
                int i = 0;
                while (i < analyzePackage.fOccurenceEdits.length) {
                    TextChangeCompatibility.addTextEdit(textChange, "", analyzePackage.fOccurenceEdits[i], GroupCategorySet.NONE);
                    ++i;
                }
                ++current;
            }
            status.merge(RenameAnalyzeUtil.analyzeLocalRenames(analyzePackages, textChange, currentResolvedCU, false));
        }
    }

    private List getProcessorsOfType(List processors, Class type) {
        ArrayList<RefactoringProcessor> tmp = new ArrayList<RefactoringProcessor>();
        Iterator iter = processors.iterator();
        while (iter.hasNext()) {
            RefactoringProcessor element = (RefactoringProcessor)iter.next();
            if (!element.getClass().equals(type)) continue;
            tmp.add(element);
        }
        return tmp;
    }

    private RefactoringStatus checkForConflictingRename(IFunction[] methods, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        Iterator iter = this.fFinalSimilarElementToName.keySet().iterator();
        while (iter.hasNext()) {
            IJavaScriptElement element = (IJavaScriptElement)iter.next();
            if (!(element instanceof IFunction)) continue;
            IFunction alreadyRegisteredMethod = (IFunction)element;
            String alreadyRegisteredMethodName = (String)this.fFinalSimilarElementToName.get(element);
            int i = 0;
            while (i < methods.length) {
                IFunction method2 = methods[i];
                if (alreadyRegisteredMethodName.equals(newName) && method2.getDeclaringType().equals(alreadyRegisteredMethod.getDeclaringType()) && RenameTypeProcessor.sameParams(alreadyRegisteredMethod, method2)) {
                    String message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_methods_same_new_name, new String[]{alreadyRegisteredMethod.getElementName(), method2.getElementName(), alreadyRegisteredMethod.getDeclaringType().getFullyQualifiedName(), newName});
                    status.addFatalError(message);
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    private static boolean sameParams(IFunction method, IFunction method2) {
        if (method.getNumberOfParameters() != method2.getNumberOfParameters()) {
            return false;
        }
        String[] params = method.getParameterTypes();
        String[] params2 = method2.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            String t2;
            String t1 = Signature.getSimpleName((String)Signature.toString((String)params[i]));
            if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)params2[i])))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkForConflictingRename(IField currentField, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        Iterator iter = this.fFinalSimilarElementToName.keySet().iterator();
        while (iter.hasNext()) {
            IJavaScriptElement element = (IJavaScriptElement)iter.next();
            if (!(element instanceof IField)) continue;
            IField alreadyRegisteredField = (IField)element;
            String alreadyRegisteredFieldName = (String)this.fFinalSimilarElementToName.get(element);
            if (!alreadyRegisteredFieldName.equals(newName) || !alreadyRegisteredField.getDeclaringType().equals(currentField.getDeclaringType())) continue;
            String message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_fields_same_new_name, new String[]{alreadyRegisteredField.getElementName(), currentField.getElementName(), alreadyRegisteredField.getDeclaringType().getFullyQualifiedName(), newName});
            status.addFatalError(message);
            return status;
        }
        return status;
    }

    private RefactoringStatus addWarnings(Set warnings) {
        RefactoringStatus status = new RefactoringStatus();
        Iterator iter = warnings.iterator();
        while (iter.hasNext()) {
            String message;
            Warning warning = (Warning)iter.next();
            IFunction[] elements = warning.getRipple();
            if (warning.isSelectionWarning()) {
                message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_deselected_method_is_overridden, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)elements[0], JavaScriptElementLabels.ALL_DEFAULT), JavaScriptElementLabels.getElementLabel((IJavaScriptElement)elements[0].getDeclaringType(), JavaScriptElementLabels.ALL_DEFAULT)});
                status.addWarning(message);
            }
            if (warning.isNameWarning()) {
                message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_renamed_method_is_overridden, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)elements[0], JavaScriptElementLabels.ALL_DEFAULT), JavaScriptElementLabels.getElementLabel((IJavaScriptElement)elements[0].getDeclaringType(), JavaScriptElementLabels.ALL_DEFAULT)});
                status.addWarning(message);
            }
            int i = 0;
            while (i < elements.length) {
                this.fPreloadedElementToSelection.put(elements[i], Boolean.FALSE);
                ++i;
            }
        }
        return status;
    }

    private boolean checkForWarnings(Set warnings, String newName, IFunction[] ripples) {
        boolean addSelectionWarning = false;
        boolean addNameWarning = false;
        int i = 0;
        while (i < ripples.length) {
            String newNameOfRipple = (String)this.fPreloadedElementToName.get(ripples[i]);
            Boolean selected = (Boolean)this.fPreloadedElementToSelection.get(ripples[i]);
            if (selected != null) {
                if (!selected.booleanValue()) {
                    addSelectionWarning = true;
                }
                if (!newName.equals(newNameOfRipple)) {
                    addNameWarning = true;
                }
            }
            ++i;
        }
        if (addSelectionWarning || addNameWarning) {
            warnings.add(new Warning(ripples, addSelectionWarning, addNameWarning));
        }
        return addSelectionWarning || addNameWarning;
    }

    private RenameMethodProcessor createVirtualMethodRenameProcessor(IFunction currentMethod, String newMethodName, IFunction[] ripples, ITypeHierarchy hierarchy) throws JavaScriptModelException {
        RenameVirtualMethodProcessor processor = new RenameVirtualMethodProcessor(currentMethod, ripples, this.fChangeManager, hierarchy, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(processor, newMethodName);
        return processor;
    }

    private RenameMethodProcessor createNonVirtualMethodRenameProcessor(IFunction currentMethod, String newMethodName) {
        RenameNonVirtualMethodProcessor processor = new RenameNonVirtualMethodProcessor(currentMethod, this.fChangeManager, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(processor, newMethodName);
        return processor;
    }

    private void initMethodProcessor(RenameMethodProcessor processor, String newMethodName) {
        processor.setNewElementName(newMethodName);
        processor.setUpdateReferences(this.getUpdateReferences());
    }

    private RenameFieldProcessor createFieldRenameProcessor(IField field, String newName) {
        RenameFieldProcessor processor = new RenameFieldProcessor(field, this.fChangeManager, CATEGORY_FIELD_RENAME);
        processor.setNewElementName(newName);
        processor.setRenameGetter(false);
        processor.setRenameSetter(false);
        processor.setUpdateReferences(this.getUpdateReferences());
        processor.setUpdateTextualMatches(false);
        return processor;
    }

    private RenameLocalVariableProcessor createLocalRenameProcessor(ILocalVariable local, String newName, JavaScriptUnit compilationUnit) {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(local, this.fChangeManager, compilationUnit, CATEGORY_LOCAL_RENAME);
        processor.setNewElementName(newName);
        processor.setUpdateReferences(this.getUpdateReferences());
        return processor;
    }

    private void addSimilarElementsTextualUpdates(TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        IJavaScriptElement element;
        HashMap<String, String> simpleNames = new HashMap<String, String>();
        ArrayList<String> forbiddenSimpleNames = new ArrayList<String>();
        Iterator iter = this.fFinalSimilarElementToName.keySet().iterator();
        while (iter.hasNext()) {
            element = (IJavaScriptElement)iter.next();
            if (!(element instanceof IField) || forbiddenSimpleNames.contains(element.getElementName())) continue;
            String registeredNewName = (String)simpleNames.get(element.getElementName());
            String newNameToCheck = (String)this.fFinalSimilarElementToName.get(element);
            if (registeredNewName == null) {
                simpleNames.put(element.getElementName(), newNameToCheck);
                continue;
            }
            if (registeredNewName.equals(newNameToCheck)) continue;
            forbiddenSimpleNames.add(element.getElementName());
        }
        iter = this.fFinalSimilarElementToName.keySet().iterator();
        while (iter.hasNext()) {
            element = (IJavaScriptElement)iter.next();
            if (!(element instanceof IField)) continue;
            IField field = (IField)element;
            String newName = (String)this.fFinalSimilarElementToName.get(field);
            TextMatchUpdater.perform(monitor, RefactoringScopeFactory.create((IJavaScriptElement)field), field.getElementName(), field.getDeclaringType().getFullyQualifiedName(), newName, manager, new SearchResultGroup[0], forbiddenSimpleNames.contains(field.getElementName()));
        }
    }

    public Map getSimilarElementsToNewNames() {
        return this.fPreloadedElementToName;
    }

    public Map getSimilarElementsToSelection() {
        return this.fPreloadedElementToSelection;
    }

    public void resetSelectedSimilarElements() {
        Assert.isNotNull((Object)this.fPreloadedElementToName);
        Iterator iter = this.fPreloadedElementToNameDefault.keySet().iterator();
        while (iter.hasNext()) {
            IJavaScriptElement element = (IJavaScriptElement)iter.next();
            this.fPreloadedElementToName.put(element, this.fPreloadedElementToNameDefault.get(element));
            this.fPreloadedElementToSelection.put(element, Boolean.TRUE);
        }
    }

    public boolean hasSimilarElementsToRename() {
        if (!this.fUpdateSimilarElements) {
            return false;
        }
        if (this.fPreloadedElementToName == null) {
            return false;
        }
        return this.fPreloadedElementToName.size() != 0;
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }

    public static final class ParticipantDescriptorFilter
    implements IParticipantDescriptorFilter {
        public boolean select(IConfigurationElement element, RefactoringStatus status) {
            IConfigurationElement[] params = element.getChildren("param");
            int i = 0;
            while (i < params.length) {
                IConfigurationElement param = params[i];
                if ("handlesSimilarDeclarations".equals(param.getAttribute("name")) && "false".equals(param.getAttribute("value"))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class Warning {
        private IFunction[] fRipple;
        private boolean fSelectionWarning;
        private boolean fNameWarning;

        public Warning(IFunction[] ripple, boolean isSelectionWarning, boolean isNameWarning) {
            this.fRipple = ripple;
            this.fSelectionWarning = isSelectionWarning;
            this.fNameWarning = isNameWarning;
        }

        public boolean isNameWarning() {
            return this.fNameWarning;
        }

        public IFunction[] getRipple() {
            return this.fRipple;
        }

        public boolean isSelectionWarning() {
            return this.fSelectionWarning;
        }
    }
}

