/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHelper;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerDescriptionHolder;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AddHandlerDialog;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ConfigServiceHandlersTableWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private Composite parent_;
    private Table handlersTable_;
    private TableViewer tableViewer_;
    private Composite webServiceDescComp_;
    private Combo webServiceDescCombo_ = null;
    private Text webServiceDescText_ = null;
    private Button addButton_;
    private Button removeButton_;
    private Button genSkeletonRadioButton_;
    private Composite sourceLocationComp_;
    private Combo sourceLocationCombo_;
    private HandlerDescriptionHolder[] handlerDescriptionHolder_;
    private HandlerDescriptionHolder currentHDH_;
    private Hashtable pathsTable_ = new Hashtable();
    private String outputLocation_;
    private String descriptionName_ = null;
    private boolean isMultipleSelection_ = false;
    private boolean isGenSkeletonEnabled_;
    private int DEFAULT_COLUMN_WIDTH = 100;
    private final String INFOPOP_HDLR_WS_HANDLERS = "SHDL0001";
    private final String INFOPOP_HDLR_GEN_SKELETON = "SHDL0002";
    private final String INFOPOP_COMBO_SOURCE_LOC = "SHDL0003";
    private final String INFOPOP_WS_SERVICE_DESC = "SHDL0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        this.parent_ = parent;
        this.webServiceDescComp_ = uiUtils.createComposite(this.parent_, 2);
        Composite displayComp = new Composite(this.parent_, 0);
        GridLayout gridlayout = new GridLayout(2, false);
        displayComp.setLayout((Layout)gridlayout);
        displayComp.setLayoutData((Object)uiUtils.createFillAll());
        final Composite handlersComp = uiUtils.createComposite(displayComp, 1);
        GridData griddata = new GridData(1810);
        handlersComp.setLayoutData((Object)griddata);
        handlersComp.setSize(130, 600);
        Composite buttonsComp = uiUtils.createComposite(displayComp, 1);
        griddata = new GridData(770);
        buttonsComp.setLayoutData((Object)griddata);
        Text handlersText = new Text(handlersComp, 8);
        handlersText.setText(ConsumptionUIMessages.LABEL_HANDLERS_CONFIG);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        handlersText.setLayoutData((Object)gd);
        this.handlersTable_ = uiUtils.createTable(handlersComp, ConsumptionUIMessages.TOOLTIP_EDIT_WS_HANDLERS, "SHDL0001", 67586);
        this.handlersTable_.setHeaderVisible(true);
        this.handlersTable_.setLinesVisible(true);
        Label wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        Button moveUpButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_UP, null, null);
        GridData muGriddata = new GridData();
        Point musize = moveUpButton.computeSize(-1, -1);
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleMoveUpButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Button moveDownButton = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_MOVE_DOWN, null, null);
        GridData mdGriddata = new GridData();
        Point mdsize = moveDownButton.computeSize(-1, -1);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleMoveDownButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        wsLabel = new Label(buttonsComp, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        wsLabel.setLayoutData((Object)gd);
        this.addButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_ADD, null, null);
        GridData addGriddata = new GridData();
        Point addSize = this.addButton_.computeSize(-1, -1);
        this.addButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton_ = uiUtils.createPushButton(buttonsComp, ConsumptionUIMessages.LABEL_BUTTON_REMOVE, null, null);
        GridData remGriddata = new GridData();
        Point remSize = this.removeButton_.computeSize(-1, -1);
        this.removeButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ConfigServiceHandlersTableWidget.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enableRemove(false);
        int widthHint = 0;
        int[] sizes = new int[]{musize.x, mdsize.x, addSize.x, remSize.x, 100};
        int j = 0;
        while (j < sizes.length) {
            if (sizes[j] > widthHint) {
                widthHint = sizes[j];
            }
            ++j;
        }
        muGriddata.widthHint = widthHint;
        mdGriddata.widthHint = widthHint;
        addGriddata.widthHint = widthHint;
        remGriddata.widthHint = widthHint;
        moveUpButton.setLayoutData((Object)muGriddata);
        moveDownButton.setLayoutData((Object)mdGriddata);
        this.addButton_.setLayoutData((Object)addGriddata);
        this.removeButton_.setLayoutData((Object)remGriddata);
        String[] columns_ = new String[]{ConsumptionUIMessages.LABEL_HANDLER_NAME, ConsumptionUIMessages.LABLE_HANDLER_CLASS, ConsumptionUIMessages.LABEL_HANDLER_PORT};
        final TableColumn[] tableCols = new TableColumn[columns_.length];
        int i = 0;
        while (i < columns_.length) {
            TableColumn tableColumn = new TableColumn(this.handlersTable_, 16384);
            tableColumn.setText(columns_[i]);
            tableColumn.setAlignment(16384);
            tableColumn.setWidth(this.DEFAULT_COLUMN_WIDTH);
            tableColumn.setResizable(true);
            tableCols[i] = tableColumn;
            ++i;
        }
        handlersComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = handlersComp.getClientArea();
                Point preferredSize = ConfigServiceHandlersTableWidget.this.handlersTable_.computeSize(-1, -1);
                int width = area.width - 2 * ConfigServiceHandlersTableWidget.this.handlersTable_.getBorderWidth() - 10;
                if (preferredSize.y > area.height + ConfigServiceHandlersTableWidget.this.handlersTable_.getHeaderHeight()) {
                    Point vBarSize = ConfigServiceHandlersTableWidget.this.handlersTable_.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ConfigServiceHandlersTableWidget.this.handlersTable_.getSize();
                if (oldSize.x > area.width) {
                    tableCols[0].setWidth(width / 3);
                    tableCols[1].setWidth(width / 3);
                    tableCols[2].setWidth(width - (tableCols[0].getWidth() + tableCols[1].getWidth()));
                    ConfigServiceHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                } else {
                    ConfigServiceHandlersTableWidget.this.handlersTable_.setSize(area.width, area.height);
                    tableCols[0].setWidth(width / 3);
                    tableCols[1].setWidth(width / 3);
                    tableCols[2].setWidth(width - (tableCols[0].getWidth() + tableCols[1].getWidth()));
                }
            }
        });
        this.tableViewer_ = new TableViewer(this.handlersTable_);
        Control control = this.tableViewer_.getControl();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)data);
        this.tableViewer_.setColumnProperties(columns_);
        this.tableViewer_.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigServiceHandlersTableWidget.this.enableRemove(true);
            }
        });
        this.genSkeletonRadioButton_ = uiUtils.createCheckbox(this.parent_, ConsumptionUIMessages.LABEL_BUTTON_GEN_SKELETON, ConsumptionUIMessages.TOOLTIP_BUTTON_GEN_SKELETON, "SHDL0002");
        griddata = new GridData(530);
        this.genSkeletonRadioButton_.setLayoutData((Object)griddata);
        this.genSkeletonRadioButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigServiceHandlersTableWidget.this.handleGenSkeletonRadioButton();
            }
        });
        this.sourceLocationComp_ = uiUtils.createComposite(this.parent_, 2);
        this.sourceLocationCombo_ = uiUtils.createCombo(this.sourceLocationComp_, ConsumptionUIMessages.LABEL_COMBO_SOURCE_LOC, ConsumptionUIMessages.TOOLTIP_COMBO_SOURCE_LOC, "SHDL0003", 8);
        this.sourceLocationCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigServiceHandlersTableWidget.this.handleSourceLocationCombo(evt);
            }
        });
        return this;
    }

    private void populateHandlersTable() {
        try {
            UIUtils uiUtils = new UIUtils(this.pluginId_);
            if (this.isMultipleSelection_) {
                this.parent_.getShell().setText(ConsumptionUIMessages.PAGE_DESC_MULTIPLE_SERVICES_CONFIG);
                this.webServiceDescText_ = uiUtils.createText(this.webServiceDescComp_, ConsumptionUIMessages.LABEL_COMBO_WS_SERVICE_DESC, ConsumptionUIMessages.TOOLTIP_WS_SERVICE_DESC, "SHDL0004", 8);
                if (this.handlerDescriptionHolder_ != null) {
                    this.currentHDH_ = this.handlerDescriptionHolder_[0];
                    String text = NLS.bind((String)ConsumptionUIMessages.MSG_TEXT_NUM_OF_SERVICES, (Object)Integer.toString(this.handlerDescriptionHolder_.length));
                    this.webServiceDescText_.setText(text);
                }
                this.genSkeletonRadioButton_.setSelection(false);
                this.genSkeletonRadioButton_.setEnabled(false);
                this.genSkeletonRadioButton_.setVisible(false);
                this.sourceLocationComp_.setVisible(false);
                this.sourceLocationCombo_.setEnabled(false);
                this.sourceLocationCombo_.setVisible(false);
                this.refresh();
            } else {
                this.webServiceDescCombo_ = uiUtils.createCombo(this.webServiceDescComp_, ConsumptionUIMessages.LABEL_COMBO_WS_SERVICE_DESC, ConsumptionUIMessages.TOOLTIP_WS_SERVICE_DESC, "SHDL0004", 8);
                this.webServiceDescCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        ConfigServiceHandlersTableWidget.this.handleWebServiceDescCombo(evt);
                    }
                });
                String[] wsDescNames = HandlerDescriptionHelper.getAllDescriptionNames(this.handlerDescriptionHolder_);
                this.webServiceDescCombo_.setItems(wsDescNames);
                if (this.handlerDescriptionHolder_.length < 1) {
                    this.webServiceDescCombo_.select(0);
                    this.webServiceDescCombo_.setEnabled(false);
                } else if (this.descriptionName_ != null) {
                    int index = this.webServiceDescCombo_.indexOf(this.descriptionName_);
                    if (index != -1) {
                        this.webServiceDescCombo_.select(index);
                    }
                } else {
                    this.webServiceDescCombo_.select(0);
                }
                HandlerDescriptionHolder hdh = HandlerDescriptionHelper.getForDescriptionName(this.handlerDescriptionHolder_, this.webServiceDescCombo_.getText());
                if (hdh != null) {
                    this.currentHDH_ = hdh;
                    List handlers = hdh.getHandlerList();
                    this.tableViewer_.setInput((Object)handlers);
                    this.tableViewer_.refresh();
                }
                this.setSourceOutputLocation();
            }
            this.parent_.getShell().setSize(530, 650);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        if (this.isMultipleSelection_) {
            return StatusUtils.infoStatus((String)ConsumptionUIMessages.PAGE_DESC_MULTIPLE_SERVICES_CONFIG);
        }
        return finalStatus;
    }

    protected void handleAddButtonSelected(SelectionEvent event) {
        AddHandlerDialog dialog = new AddHandlerDialog(this.parent_.getShell(), false);
        dialog.setIsMultipleServices(this.isMultipleSelection_);
        dialog.create();
        WebServiceDescription serviceDesc = null;
        if (!this.isMultipleSelection_ && this.currentHDH_ != null) {
            serviceDesc = this.currentHDH_.getDescriptionObject();
            String[] portNames = this.getPortComponentNames(serviceDesc);
            dialog.setPortNames(portNames);
        }
        dialog.getShell().setSize(500, 230);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getName();
            String className = dialog.getClassName();
            String port = dialog.getPortName();
            if (port == null) {
                port = "*";
            }
            HandlerTableItem hi = new HandlerTableItem();
            hi.setHandlerName(name);
            hi.setHandlerClassName(className);
            hi.setPortName(port);
            if (serviceDesc != null) {
                hi.setWsDescRef(serviceDesc);
            }
            if (this.currentHDH_ != null) {
                List handlers = this.currentHDH_.getHandlerList();
                handlers.add(hi);
            }
        }
        this.refresh();
    }

    private String[] getPortComponentNames(WebServiceDescription webServiceDesc) {
        EList ports = webServiceDesc.getPortComponents();
        if (ports != null) {
            String[] portNames = new String[ports.size()];
            int i = 0;
            while (i < ports.size()) {
                String pcName;
                PortComponent pc = (PortComponent)ports.get(i);
                portNames[i] = pcName = pc.getPortComponentName();
                ++i;
            }
            return portNames;
        }
        return new String[0];
    }

    protected void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    protected void handleMoveUpButtonSelected(SelectionEvent event) {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && index > 0) {
            if (this.currentHDH_ != null) {
                List handlers = this.currentHDH_.getHandlerList();
                Object object = handlers.remove(index);
                handlers.add(index - 1, object);
            }
            this.tableViewer_.refresh();
        }
    }

    protected void handleMoveDownButtonSelected(SelectionEvent event) {
        int index = this.tableViewer_.getTable().getSelectionIndex();
        if (index != -1 && this.currentHDH_ != null) {
            List handlers = this.currentHDH_.getHandlerList();
            if (index < handlers.size() - 1) {
                Object object = handlers.remove(index);
                handlers.add(index + 1, object);
            }
            this.tableViewer_.refresh();
        }
    }

    protected void handleSourceLocationCombo(SelectionEvent event) {
        this.outputLocation_ = this.sourceLocationCombo_.getText();
        IPath outputPath = (IPath)this.pathsTable_.get(this.outputLocation_);
        this.currentHDH_.setSourceOutputPath(outputPath);
    }

    protected void handleGenSkeletonRadioButton() {
        if (this.genSkeletonRadioButton_.isEnabled()) {
            if (this.genSkeletonRadioButton_.getSelection()) {
                this.isGenSkeletonEnabled_ = true;
                this.sourceLocationCombo_.setEnabled(true);
            } else {
                this.isGenSkeletonEnabled_ = false;
                this.sourceLocationCombo_.setEnabled(false);
            }
        }
    }

    protected void handleWebServiceDescCombo(SelectionEvent event) {
        if (this.webServiceDescCombo_ != null && this.webServiceDescCombo_.isEnabled()) {
            HandlerDescriptionHolder hdh;
            this.currentHDH_ = hdh = HandlerDescriptionHelper.getForDescriptionName(this.handlerDescriptionHolder_, this.webServiceDescCombo_.getText());
            this.refresh();
        }
        if (this.isGenSkeletonEnabled_) {
            this.setSourceOutputLocation();
        }
    }

    public boolean isGenSkeletonEnabled_() {
        return this.isGenSkeletonEnabled_;
    }

    private void enableRemove(boolean enabled) {
        this.removeButton_.setEnabled(enabled && !this.tableViewer_.getSelection().isEmpty());
    }

    protected void handleDeleteKeyPressed() {
        ISelection selection = this.tableViewer_.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            int selectionIndex = this.handlersTable_.getSelectionIndex();
            if (this.currentHDH_ != null) {
                this.currentHDH_.getHandlerList().remove(selectionIndex);
            }
            this.refresh();
        }
    }

    public void refresh() {
        try {
            this.tableViewer_.setInput(null);
            if (this.currentHDH_ != null) {
                List handlers = this.currentHDH_.getHandlerList();
                this.tableViewer_.setInput((Object)handlers);
                this.tableViewer_.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGenSkeletonEnabled(boolean isGenSkeletonEnabled) {
        this.isGenSkeletonEnabled_ = isGenSkeletonEnabled;
        this.genSkeletonRadioButton_.setSelection(isGenSkeletonEnabled);
    }

    public boolean getGenSkeletonEnabled() {
        return this.isGenSkeletonEnabled_;
    }

    private void setSourceOutputLocation() {
        IProject project = this.currentHDH_.getProject();
        if (project != null) {
            IPath[] locations = ResourceUtils.getAllJavaSourceLocations((IProject)project);
            String[] paths = new String[locations.length];
            int i = 0;
            while (i < locations.length) {
                paths[i] = locations[i].toString();
                this.pathsTable_.put(paths[i], locations[i]);
                ++i;
            }
            this.sourceLocationCombo_.setItems(paths);
            this.sourceLocationCombo_.select(0);
        }
        this.outputLocation_ = this.sourceLocationCombo_.getText();
        IPath outputPath = (IPath)this.pathsTable_.get(this.outputLocation_);
        this.currentHDH_.setSourceOutputPath(outputPath);
    }

    public void setHandlerDescriptionHolders(HandlerDescriptionHolder[] handlerHolders) {
        this.handlerDescriptionHolder_ = handlerHolders;
    }

    public HandlerDescriptionHolder[] getHandlerDescriptionHolders() {
        return this.handlerDescriptionHolder_;
    }

    public List getHandlersList() {
        if (this.handlerDescriptionHolder_[0] != null) {
            return this.handlerDescriptionHolder_[0].getHandlerList();
        }
        return null;
    }

    public void setDescriptionName(String wsDescName) {
        this.descriptionName_ = wsDescName;
    }

    public void setIsMultipleSelection(boolean isMulitpleSelection) {
        this.isMultipleSelection_ = isMulitpleSelection;
    }

    public void internalize() {
        this.populateHandlersTable();
    }

    protected class ListContentProvider
    implements IStructuredContentProvider {
        protected ListContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof Vector) {
                return ((Vector)element).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    protected class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof HandlerTableItem) {
                HandlerTableItem hti = (HandlerTableItem)object;
                if (columnIndex == 0) {
                    return hti.getHandlerName() != null ? hti.getHandlerName() : "";
                }
                if (columnIndex == 1) {
                    return hti.getHandlerClassName() != null ? hti.getHandlerClassName() : "";
                }
                return hti.getPortName() != null ? hti.getPortName() : "";
            }
            return null;
        }
    }
}

