/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.InternalDatabase;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPDatabaseWrapper
extends DTPSchemaContainerWrapper
implements InternalDatabase {
    private final DTPConnectionProfileWrapper connectionProfile;
    private final org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
    private DTPCatalogWrapper[] catalogs;
    private DTPCatalogWrapper defaultCatalog;
    private boolean defaultCatalogCalculated = false;
    private boolean caseSensitive = false;
    private static final DTPCatalogWrapper[] EMPTY_CATALOGS = new DTPCatalogWrapper[0];

    DTPDatabaseWrapper(DTPConnectionProfileWrapper connectionProfile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        super(connectionProfile, dtpDatabase);
        this.connectionProfile = connectionProfile;
        this.dtpDatabase = dtpDatabase;
    }

    @Override
    synchronized void catalogObjectChanged(int eventType) {
        super.catalogObjectChanged(eventType);
        this.getConnectionProfile().databaseChanged(this, eventType);
    }

    @Override
    public String getName() {
        return this.dtpDatabase.getName();
    }

    @Override
    public String getVendor() {
        return this.dtpDatabase.getVendor();
    }

    @Override
    public String getVersion() {
        return this.dtpDatabase.getVersion();
    }

    @Override
    public DatabaseDefinition getDtpDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.dtpDatabase);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean supportsCatalogs() {
        List<Schema> dtpSchemata = this.dtpSchemata();
        return dtpSchemata == null || dtpSchemata.isEmpty();
    }

    @Override
    public Iterator<Catalog> catalogs() {
        return new ArrayIterator((Object[])this.catalogs_());
    }

    private Iterator<DTPCatalogWrapper> catalogWrappers() {
        return new ArrayIterator((Object[])this.catalogs_());
    }

    private synchronized DTPCatalogWrapper[] catalogs_() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogs();
        }
        return this.catalogs;
    }

    private DTPCatalogWrapper[] buildCatalogs() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.dtpCatalogs();
        if (dtpCatalogs == null || dtpCatalogs.isEmpty()) {
            return EMPTY_CATALOGS;
        }
        DTPCatalogWrapper[] result = new DTPCatalogWrapper[dtpCatalogs.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPCatalogWrapper(this, dtpCatalogs.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs() {
        return this.dtpDatabase.getCatalogs();
    }

    @Override
    public int catalogsSize() {
        return this.catalogs_().length;
    }

    @Override
    public Iterator<String> catalogNames() {
        return new TransformationIterator<DTPCatalogWrapper, String>(this.catalogWrappers()){

            protected String transform(DTPCatalogWrapper catalog) {
                return catalog.getName();
            }
        };
    }

    @Override
    public boolean containsCatalogNamed(String name) {
        return this.catalogNamed(name) != null;
    }

    @Override
    public DTPCatalogWrapper catalogNamed(String name) {
        return this.isCaseSensitive() ? this.catalogNamedCaseSensitive(name) : this.catalogNamedIgnoreCase(name);
    }

    private DTPCatalogWrapper catalogNamedCaseSensitive(String name) {
        Iterator<DTPCatalogWrapper> stream = this.catalogWrappers();
        while (stream.hasNext()) {
            DTPCatalogWrapper catalog = stream.next();
            if (!catalog.getName().equals(name)) continue;
            return catalog;
        }
        return null;
    }

    private DTPCatalogWrapper catalogNamedIgnoreCase(String name) {
        Iterator<DTPCatalogWrapper> stream = this.catalogWrappers();
        while (stream.hasNext()) {
            DTPCatalogWrapper catalog = stream.next();
            if (!StringTools.stringsAreEqualIgnoreCase((String)catalog.getName(), (String)name)) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public synchronized DTPCatalogWrapper getDefaultCatalog() {
        if (!this.defaultCatalogCalculated) {
            this.defaultCatalogCalculated = true;
            this.defaultCatalog = this.buildDefaultCatalog();
        }
        return this.defaultCatalog;
    }

    private DTPCatalogWrapper buildDefaultCatalog() {
        if (!this.supportsCatalogs()) {
            return null;
        }
        String userName = this.connectionProfile.getUserName();
        Iterator<DTPCatalogWrapper> stream = this.catalogWrappers();
        while (stream.hasNext()) {
            DTPCatalogWrapper catalog = stream.next();
            if (catalog.getName().length() == 0) {
                return catalog;
            }
            if (catalog.getName().equals(userName)) {
                return catalog;
            }
            if (!catalog.getName().equals(this.getName())) continue;
            return catalog;
        }
        throw new IllegalStateException("unknown default catalog");
    }

    DTPCatalogWrapper catalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        Iterator<DTPCatalogWrapper> stream = this.catalogWrappers();
        while (stream.hasNext()) {
            DTPCatalogWrapper catalog = stream.next();
            if (!catalog.wraps(dtpCatalog)) continue;
            return catalog;
        }
        throw new IllegalArgumentException("invalid DTP catalog: " + dtpCatalog);
    }

    @Override
    List<Schema> dtpSchemata() {
        return this.dtpDatabase.getSchemas();
    }

    @Override
    synchronized DTPSchemaWrapper[] schemata_() {
        return this.supportsCatalogs() ? this.getDefaultCatalog().schemata_() : super.schemata_();
    }

    @Override
    public int compareTo(Database database) {
        return Collator.getInstance().compare(this.getName(), database.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.schema.Database database) {
        return this.dtpDatabase == database;
    }

    DTPTableWrapper table(Table dtpTable) {
        return this.schema(dtpTable.getSchema()).table(dtpTable);
    }

    DTPColumnWrapper column(Column dtpColumn) {
        return this.table(dtpColumn.getTable()).column(dtpColumn);
    }

    @Override
    DTPDatabaseWrapper database() {
        return this;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
    }

    @Override
    void dispose_() {
        this.defaultCatalogCalculated = false;
        this.defaultCatalog = null;
        this.disposeCatalogs();
        super.dispose_();
    }

    private void disposeCatalogs() {
        if (this.catalogs != null) {
            DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
            int n = this.catalogs.length;
            int n2 = 0;
            while (n2 < n) {
                DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
                catalog.dispose();
                ++n2;
            }
            this.catalogs = null;
        }
    }
}

