/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.prefs;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JpaPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jpt.ui.jpaPreferencePage";
    private IPersistentPreferenceStore preferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), JptCorePlugin.instance().getBundle().getSymbolicName());
    private IPreferenceStore userLibPreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), JavaCore.getPlugin().getBundle().getSymbolicName());
    private Label jpaLibLabel;
    private Combo jpaLibCombo;
    private Link userLibsLink;

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.jpaLibLabel = this.createLabel(container, 1, JptUiMessages.JpaPreferencePage_defaultJpaLib);
        this.jpaLibCombo = this.createCombo(container, true);
        this.userLibsLink = new Link(container, 0);
        GridData data = new GridData(3, 2, false, false);
        data.horizontalSpan = 2;
        this.userLibsLink.setLayoutData((Object)data);
        this.userLibsLink.setText(JptUiMessages.JpaPreferencePage_userLibsLink);
        this.userLibsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)JpaPreferencePage.this.getContainer()).openPage("org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage", null);
            }
        });
        this.performDefaults();
        return container;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    private void fillJpaLibs() {
        int newIndex;
        int index = this.jpaLibCombo.getSelectionIndex();
        String selectedJpaLib = null;
        if (index >= 0) {
            selectedJpaLib = this.jpaLibCombo.getItem(this.jpaLibCombo.getSelectionIndex());
        }
        this.jpaLibCombo.clearSelection();
        this.jpaLibCombo.setItems(JavaCore.getUserLibraryNames());
        if (selectedJpaLib != null && (newIndex = CollectionTools.indexOf((Object[])this.jpaLibCombo.getItems(), (Object)selectedJpaLib)) >= 0) {
            this.jpaLibCombo.select(newIndex);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillJpaLibs();
        }
    }

    public void performDefaults() {
        this.fillJpaLibs();
        String defaultLib = this.preferences.getString("defaultJpaLib");
        int index = -1;
        if (!StringTools.stringIsEmpty((String)defaultLib)) {
            index = CollectionTools.indexOf((Object[])this.jpaLibCombo.getItems(), (Object)defaultLib);
        }
        if (index >= 0) {
            this.jpaLibCombo.select(index);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String defaultLib;
        int index = this.jpaLibCombo.getSelectionIndex();
        String string = defaultLib = index >= 0 ? this.jpaLibCombo.getItem(index) : null;
        if (!StringTools.stringIsEmpty((String)defaultLib)) {
            this.preferences.setValue("defaultJpaLib", defaultLib);
        }
        try {
            this.preferences.save();
        }
        catch (IOException ioe) {
            JptCorePlugin.log((Throwable)ioe);
        }
        return true;
    }

    public void dispose() {
        if (this.jpaLibLabel != null) {
            this.jpaLibLabel.dispose();
        }
        if (this.jpaLibCombo != null) {
            this.jpaLibCombo.dispose();
        }
        super.dispose();
    }
}

