/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.launch;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURL;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;

public class JSFFileURL
implements FileURL {
    public IPath getFileURL(IResource resource, IPath existingURL) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)resource.getProject());
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            if (JSFUtils12.isWebApp25(webAppObj)) {
                return this.getJavaEEFileURLPath(webAppObj, resource, existingURL);
            }
            if (JSFUtils11.isWebApp24(webAppObj) || JSFUtils11.isWebApp23(webAppObj)) {
                return this.getJ2EEFileURLPath(webAppObj, resource, existingURL);
            }
        }
        return null;
    }

    private IPath getJ2EEFileURLPath(Object webAppObj, IResource resource, IPath existingURL) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
        if (webApp != null) {
            Servlet servlet = JSFUtils11.findJSFServlet(webApp);
            if (servlet == null) {
                return null;
            }
            if (!this.isJSFPage(resource)) {
                return null;
            }
            String defaultSuffix = JSFUtils11.getDefaultSuffix(webApp);
            boolean canUseExtensionMapping = resource.getFileExtension().equalsIgnoreCase(defaultSuffix);
            if (!canUseExtensionMapping && !this.isValidKnownExtension(resource.getFileExtension())) {
                return null;
            }
            Iterator mappings = servlet.getMappings().iterator();
            ServletMapping map = null;
            String foundFileExtension = null;
            String foundPrefixMapping = null;
            while (mappings.hasNext()) {
                map = (ServletMapping)mappings.next();
                foundFileExtension = JSFUtils11.getFileExtensionFromMap(map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                if (foundPrefixMapping != null) continue;
                foundPrefixMapping = JSFUtils11.getPrefixMapping(map);
            }
            if (foundPrefixMapping != null) {
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        }
        return null;
    }

    private IPath getJavaEEFileURLPath(Object webAppObj, IResource resource, IPath existingURL) {
        WebApp webApp = (WebApp)webAppObj;
        if (webApp != null) {
            org.eclipse.jst.javaee.web.Servlet servlet = JSFUtils12.findJSFServlet(webApp);
            if (servlet == null) {
                return null;
            }
            if (!this.isJSFPage(resource)) {
                return null;
            }
            String defaultSuffix = JSFUtils12.getDefaultSuffix(webApp);
            boolean canUseExtensionMapping = resource.getFileExtension().equalsIgnoreCase(defaultSuffix);
            if (!canUseExtensionMapping && !this.isValidKnownExtension(resource.getFileExtension())) {
                return null;
            }
            Iterator mappings = webApp.getServletMappings().iterator();
            org.eclipse.jst.javaee.web.ServletMapping map = null;
            String foundFileExtension = null;
            while (mappings.hasNext()) {
                map = (org.eclipse.jst.javaee.web.ServletMapping)mappings.next();
                if (!map.getServletName().equals(servlet.getServletName())) continue;
                foundFileExtension = JSFUtils12.getFileExtensionFromMap(map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                String foundPrefixMapping = JSFUtils12.getPrefixMapping(map);
                if (foundPrefixMapping == null) continue;
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        }
        return null;
    }

    private boolean isValidKnownExtension(String fileExtension) {
        return fileExtension.equalsIgnoreCase("jsp") || fileExtension.equalsIgnoreCase("jspx") || fileExtension.equalsIgnoreCase("jsf") || fileExtension.equalsIgnoreCase("xhtml");
    }

    private boolean isJSFPage(IResource resource) {
        return true;
    }
}

