/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;

public abstract class MultipleLinkAction
extends LinkAction {
    public MultipleLinkAction(Controller controller) {
        super(controller);
    }

    protected boolean processLinkParameters(HttpServletRequest request) {
        String isMultipleLinkAction = request.getParameter("multipleLinkAction");
        if (isMultipleLinkAction != null) {
            this.propertyTable_.put("multipleLinkAction", isMultipleLinkAction);
            return this.processMultipleLinkActionParameters(request);
        }
        this.propertyTable_.remove("multipleLinkAction");
        String nodeIDString = request.getParameter("nodeId");
        String toolIDString = request.getParameter("toolId");
        String viewIDString = request.getParameter("viewId");
        String viewToolIDString = request.getParameter("viewToolId");
        if (nodeIDString != null) {
            this.propertyTable_.put("nodeId", nodeIDString);
        }
        if (toolIDString != null) {
            this.propertyTable_.put("toolId", toolIDString);
        }
        if (viewIDString != null) {
            this.propertyTable_.put("viewId", viewIDString);
        }
        if (viewToolIDString != null) {
            this.propertyTable_.put("viewToolId", viewToolIDString);
        }
        return true;
    }

    protected boolean processMultipleLinkActionParameters(HttpServletRequest request) {
        String nodeID = request.getParameter("nodeId");
        String[] viewIDs = request.getParameterValues("viewId");
        this.propertyTable_.put("nodeId", nodeID);
        this.propertyTable_.put("viewId", viewIDs);
        return viewIDs.length != 0;
    }

    protected boolean isMultipleLinkAction() {
        return this.propertyTable_.containsKey("multipleLinkAction");
    }

    protected String[] getViewIds() {
        Object object = this.propertyTable_.get("viewId");
        if (object == null) {
            return new String[0];
        }
        if (object.getClass().isArray()) {
            return (String[])object;
        }
        return new String[]{(String)object};
    }

    public boolean run() {
        return this.isMultipleLinkAction() ? this.executeMultipleLinkAction() : this.executeSingleLinkAction();
    }

    protected boolean executeMultipleLinkAction() {
        boolean result = false;
        String[] viewIds = this.getViewIds();
        if (viewIds != null && viewIds.length > 0) {
            int i = 0;
            while (i < viewIds.length) {
                this.propertyTable_.put("viewId", viewIds[i]);
                if (this.executeSingleLinkAction()) {
                    result = true;
                }
                ++i;
            }
        }
        this.propertyTable_.put("viewId", viewIds);
        return result;
    }

    protected abstract boolean executeSingleLinkAction();
}

