/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

public class InitializedSymbolFactory {
    public final ISymbol createBeanOrUnknownInstanceSymbol(IProject project, String fullyQualifiedClass, String symbolName, ERuntimeSource source) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IType type = javaProject.findType(fullyQualifiedClass);
            if (type != null) {
                IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                typeDesc.setType(type);
                IBeanInstanceSymbol facesContextVar = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                facesContextVar.setTypeDescriptor(typeDesc);
                facesContextVar.setName(symbolName);
                facesContextVar.setRuntimeSource(source);
                return facesContextVar;
            }
        }
        catch (JavaModelException javaModelException) {}
        IInstanceSymbol symbol = this.createUnknownInstanceSymbol(symbolName, source);
        symbol.getTypeDescriptor().setTypeSignatureDelegate(Signature.createTypeSignature((String)fullyQualifiedClass, (boolean)true));
        return symbol;
    }

    public final IComponentSymbol createUnknownComponentSymbol(String symbolName, ERuntimeSource source) {
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        this.populateUnknownInstanceSymbol(symbol, symbolName, source);
        return symbol;
    }

    public final IInstanceSymbol createUnknownInstanceSymbol(String symbolName, ERuntimeSource source) {
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        this.populateUnknownInstanceSymbol(symbol, symbolName, source);
        return symbol;
    }

    public final IComponentSymbol createJavaComponentSymbol(String name, IJavaTypeDescriptor2 typeDesc, String description) {
        if (name == null || typeDesc == null) {
            throw new IllegalArgumentException("name and typeDesc must not be null");
        }
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(name);
        symbol.setTypeDescriptor(typeDesc);
        symbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        return symbol;
    }

    public final IComponentSymbol createJavaComponentSymbol(String name, ValueType valueType, String description, IJavaProject javaProject) {
        IJavaTypeDescriptor2 typeDesc = this.createTypeDescriptorFromSignature(valueType.getSignature(), javaProject);
        return this.createJavaComponentSymbol(name, typeDesc, description);
    }

    private void populateUnknownInstanceSymbol(IInstanceSymbol symbol, String symbolName, ERuntimeSource source) {
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource(Collections.emptyMap());
        symbol.setName(symbolName);
        symbol.setTypeDescriptor(typeDesc);
        symbol.setRuntimeSource(source);
    }

    public final String getElementSignatureFromContainerType(ValueType type) {
        String[] typeArguments;
        if (type.isArray()) {
            String signature = type.getSignature();
            int arrayCount = Signature.getArrayCount((String)signature);
            String elementSig = Signature.getElementType((String)signature);
            return Signature.createArraySignature((String)elementSig, (int)(arrayCount - 1));
        }
        if (type.isInstanceOf("Ljava.util.Collection;") && (typeArguments = type.getTypeArguments()).length > 0) {
            return typeArguments[0];
        }
        return null;
    }

    public final IJavaTypeDescriptor2 createTypeDescriptorFromSignature(String signature, IJavaProject javaProject) {
        IType type;
        String elementType = Signature.getElementType((String)signature);
        IJavaTypeDescriptor2 desc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        int arrayCount = Signature.getArrayCount((String)signature);
        if (arrayCount > 0) {
            desc.setArrayCount(arrayCount);
        }
        if ((type = TypeUtil.resolveType(javaProject, elementType)) != null) {
            desc.setType(type);
        } else {
            desc.setTypeSignatureDelegate(Signature.getTypeErasure((String)signature));
        }
        desc.getTypeParameterSignatures().addAll((Collection)Arrays.asList(Signature.getTypeArguments((String)signature)));
        return desc;
    }
}

