/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsf.common.internal.policy.CanonicallyOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.IteratorPolicyBasedStrategyComposite;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.TagLibraryRegistryLoader;
import org.eclipse.jst.jsf.core.internal.TagRegistryFactoryInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeTagRegistryFactory {
    private static CompositeTagRegistryFactory INSTANCE;
    private final Map<IContentType, Set<TagRegistryFactoryInfo>> _cachedExtensionsByType = new HashMap<IContentType, Set<TagRegistryFactoryInfo>>(4);

    public static synchronized CompositeTagRegistryFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompositeTagRegistryFactory();
        }
        return INSTANCE;
    }

    private CompositeTagRegistryFactory() {
    }

    public final ITagRegistry getRegistry(TagRegistryIdentifier id) {
        Set<TagRegistryFactoryInfo> handlers = TagLibraryRegistryLoader.getAllHandlers();
        Set<TagRegistryFactoryInfo> matchingHandlers = this.findMatchingExtensions(id, handlers);
        if (matchingHandlers.size() > 0) {
            if (matchingHandlers.size() == 1) {
                try {
                    return matchingHandlers.iterator().next().getTagRegistryFactory().createTagRegistry(id.getProject());
                }
                catch (TagRegistryFactory.TagRegistryFactoryException e) {
                    JSFCorePlugin.log(e, "While trying to acquire a registry");
                }
            } else {
                TagRegistrySelectionStrategy selectionStrategy = new TagRegistrySelectionStrategy((IIteratorPolicy<String>)new CanonicallyOrderedIteratorPolicy());
                Iterator<TagRegistryFactoryInfo> it = matchingHandlers.iterator();
                while (it.hasNext()) {
                    selectionStrategy.addStrategy(it.next().getTagRegistryFactory());
                }
                return (ITagRegistry)selectionStrategy.perform(id.getProject());
            }
        }
        return null;
    }

    public Set<TagRegistryFactoryInfo> getAllTagRegistryFactories() {
        return TagLibraryRegistryLoader.getAllHandlers();
    }

    private Set<TagRegistryFactoryInfo> findMatchingExtensions(TagRegistryIdentifier id, Set<TagRegistryFactoryInfo> handlers) {
        Set<TagRegistryFactoryInfo> matching = this._cachedExtensionsByType.get(id.getContentType());
        if (matching == null) {
            matching = new HashSet<TagRegistryFactoryInfo>(4);
            for (TagRegistryFactoryInfo handler : handlers) {
                if (!handler.getContentTypes().contains(id.getContentType())) continue;
                matching.add(handler);
            }
            if (matching.size() > 0) {
                this._cachedExtensionsByType.put(id.getContentType(), matching);
            } else {
                this._cachedExtensionsByType.put(id.getContentType(), Collections.EMPTY_SET);
            }
        }
        return matching;
    }

    public static final class TagRegistryIdentifier {
        private final IProject _project;
        private final IContentType _contentType;

        public TagRegistryIdentifier(IProject project, IContentType contentType) {
            this._project = project;
            this._contentType = contentType;
        }

        IProject getProject() {
            return this._project;
        }

        IContentType getContentType() {
            return this._contentType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagRegistrySelectionStrategy
    extends IteratorPolicyBasedStrategyComposite<IProject, ITagRegistry, String, IIdentifiableStrategy<IProject, ITagRegistry, String>> {
        private static final ITagRegistry NO_RESULT = null;

        protected TagRegistrySelectionStrategy(IIteratorPolicy<String> policy) {
            super(policy);
        }

        public ITagRegistry getNoResult() {
            return NO_RESULT;
        }
    }
}

