/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.wst.wsdl.util.WSDLDiagnostic;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticSeverity;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.w3c.dom.Node;

public class WSDLDiagnosticImpl
extends EObjectImpl
implements WSDLDiagnostic {
    protected static final int COLUMN_EDEFAULT = 1;
    protected static final int LINE_EDEFAULT = 1;
    protected static final String LOCATION_URI_EDEFAULT = null;
    protected static final String MESSAGE_EDEFAULT = null;
    protected static final WSDLDiagnosticSeverity SEVERITY_EDEFAULT = WSDLDiagnosticSeverity.FATAL_LITERAL;
    protected int column = 1;
    protected int line = 1;
    protected String locationURI = LOCATION_URI_EDEFAULT;
    protected String message = MESSAGE_EDEFAULT;
    protected WSDLDiagnosticSeverity severity = SEVERITY_EDEFAULT;
    protected String key;
    protected EList substitutions;
    protected Node node;
    protected Object container;

    public WSDLDiagnosticImpl() {
    }

    public WSDLDiagnosticImpl(XSDDiagnostic xsdDiagnostic) {
        this();
        this.setMessage(xsdDiagnostic.getMessage());
        this.setSeverity(this.getSeverity(xsdDiagnostic.getSeverity()));
        this.setLine(xsdDiagnostic.getLine());
        this.setColumn(xsdDiagnostic.getColumn());
        this.setNode(xsdDiagnostic.getNode());
        this.setContainer(xsdDiagnostic.getContainer());
        this.setLocation(xsdDiagnostic.getLocation());
        this.setKey(xsdDiagnostic.getKey());
        this.getSubstitutions().addAll((Collection)xsdDiagnostic.getSubstitutions());
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getLocation() {
        return this.locationURI;
    }

    public String getMessage() {
        return this.message;
    }

    public WSDLDiagnosticSeverity getSeverity() {
        return this.severity;
    }

    private WSDLDiagnosticSeverity getSeverity(XSDDiagnosticSeverity xsdDiagnosticSeverity) {
        switch (xsdDiagnosticSeverity.getValue()) {
            case 0: {
                return WSDLDiagnosticSeverity.FATAL_LITERAL;
            }
            case 1: {
                return WSDLDiagnosticSeverity.ERROR_LITERAL;
            }
            case 2: {
                return WSDLDiagnosticSeverity.WARNING_LITERAL;
            }
            case 3: {
                return WSDLDiagnosticSeverity.INFORMATION_LITERAL;
            }
        }
        return SEVERITY_EDEFAULT;
    }

    public void setColumn(int newColumn) {
        this.column = newColumn;
    }

    public void setLine(int newLine) {
        this.line = newLine;
    }

    public void setLocation(String location) {
        this.locationURI = location;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public void setSeverity(WSDLDiagnosticSeverity newSeverity) {
        this.severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    public EList getSubstitutions() {
        if (this.substitutions == null) {
            this.substitutions = new BasicEList();
        }
        return this.substitutions;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }
}

