/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RefactoringAnalyzeUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] edits, TextChange change) {
        IRegion[] result = new IRegion[edits.length];
        int i = 0;
        while (i < edits.length) {
            result[i] = RefactoringAnalyzeUtil.getNewTextRange(edits[i], change);
            ++i;
        }
        return result;
    }

    public static RefactoringStatus reportProblemNodes(String modifiedWorkingCopySource, SimpleName[] problemNodes) {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problemNodes.length) {
            JavaStringStatusContext context = new JavaStringStatusContext(modifiedWorkingCopySource, new SourceRange((ASTNode)problemNodes[i]));
            result.addError(Messages.format(RefactoringCoreMessages.RefactoringAnalyzeUtil_name_collision, problemNodes[i].getIdentifier()), (RefactoringStatusContext)context);
            ++i;
        }
        return result;
    }

    public static FunctionDeclaration getMethodDeclaration(TextEdit edit, TextChange change, JavaScriptUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.FunctionDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (FunctionDeclaration)ASTNodes.getParent((ASTNode)decl, clazz);
    }

    public static Block getBlock(TextEdit edit, TextChange change, JavaScriptUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Block)ASTNodes.getParent((ASTNode)decl, clazz);
    }

    public static IProblem[] getIntroducedCompileProblems(JavaScriptUnit newCUNode, JavaScriptUnit oldCuNode) {
        HashSet<IProblem> subResult = new HashSet<IProblem>();
        Set oldProblems = RefactoringAnalyzeUtil.getOldProblems(oldCuNode);
        IProblem[] newProblems = ASTNodes.getProblems((ASTNode)newCUNode, 2, 3);
        int i = 0;
        while (i < newProblems.length) {
            IProblem correspondingOld = RefactoringAnalyzeUtil.findCorrespondingProblem(oldProblems, newProblems[i]);
            if (correspondingOld == null) {
                subResult.add(newProblems[i]);
            }
            ++i;
        }
        return subResult.toArray(new IProblem[subResult.size()]);
    }

    public static IRegion getNewTextRange(TextEdit edit, TextChange change) {
        return change.getPreviewEdit(edit).getRegion();
    }

    private static IProblem findCorrespondingProblem(Set oldProblems, IProblem iProblem) {
        Iterator iter = oldProblems.iterator();
        while (iter.hasNext()) {
            IProblem oldProblem = (IProblem)iter.next();
            if (!RefactoringAnalyzeUtil.isCorresponding(oldProblem, iProblem)) continue;
            return oldProblem;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem oldProblem, IProblem iProblem) {
        if (oldProblem.getID() != iProblem.getID()) {
            return false;
        }
        return oldProblem.getMessage().equals(iProblem.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode node) {
        if (node instanceof SimpleName) {
            return (SimpleName)node;
        }
        if (node instanceof VariableDeclaration) {
            return ((VariableDeclaration)node).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion range, JavaScriptUnit cuNode) {
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, range.getOffset(), range.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(node);
    }

    private static Set getOldProblems(JavaScriptUnit oldCuNode) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)oldCuNode, 2, 3)));
    }
}

