/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.document;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.modelhandler.EmbeddedTypeStateData;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.IContentDescriptionForJSP;
import org.eclipse.jst.jsp.core.internal.text.StructuredTextPartitionerForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeFamilyForHTML;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistry;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistryImpl;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class PageDirectiveAdapterImpl
implements PageDirectiveAdapter {
    protected static final String STR_CHARSET = "charset";
    private static final Object adapterType;
    private IStructuredModel model;
    protected final String[] JAVASCRIPT_LANGUAGE_KEYS = new String[]{"javascript", "javascript1.0", "javascript1.1_3", "javascript1.2", "javascript1.3", "javascript1.4", "javascript1.5", "javascript1.6", "jscript", "sashscript"};
    protected final String[] JAVA_LANGUAGE_KEYS = new String[]{"java"};
    private EmbeddedTypeHandler embeddedTypeHandler;
    private List embeddedFactoryRegistry = new ArrayList();
    private String cachedLanguage;
    private String cachedContentType;
    private INodeNotifier notifierAtCreation;
    private String elIgnored = null;
    private int firstLanguagePosition = -1;
    private int firstContentTypePosition = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapterType = clazz;
    }

    public PageDirectiveAdapterImpl(INodeNotifier target) {
        this.notifierAtCreation = target;
        if (target instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)target;
            this.model = node.getModel();
        }
    }

    private String getMimeTypeFromContentTypeValue(String contentTypeValue) {
        if (contentTypeValue == null) {
            return null;
        }
        String cleanContentTypeValue = StringUtils.stripNonLetterDigits((String)contentTypeValue);
        StringTokenizer tokenizer = new StringTokenizer(cleanContentTypeValue, ";= \t\n\r\f");
        int tLen = tokenizer.countTokens();
        String[] tokens = new String[tLen];
        int j = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[j] = tokenizer.nextToken();
            ++j;
        }
        int charsetPos = -1;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].equalsIgnoreCase(STR_CHARSET)) {
                charsetPos = i;
                break;
            }
            ++i;
        }
        String contentType = null;
        if (charsetPos > -1) {
            int contentTypeValuePos = charsetPos - 1;
            if (contentTypeValuePos > -1) {
                contentType = tokens[contentTypeValuePos];
            }
        } else if (tokens.length > 0) {
            contentType = tokens[0];
        }
        return contentType;
    }

    public boolean isAdapterForType(Object type) {
        return type == adapterType;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public void setEmbeddedType(EmbeddedTypeHandler handler) {
        INodeAdapterFactory factory;
        if (this.embeddedTypeHandler == handler) {
            return;
        }
        if (this.embeddedTypeHandler != null) {
            Iterator list = this.embeddedFactoryRegistry.iterator();
            while (list.hasNext()) {
                factory = (INodeAdapterFactory)list.next();
                factory.release();
            }
            this.embeddedFactoryRegistry.clear();
        }
        this.embeddedTypeHandler = handler;
        if (this.embeddedTypeHandler != null) {
            Iterator iterator = this.embeddedTypeHandler.getAdapterFactories().iterator();
            while (iterator.hasNext()) {
                factory = (INodeAdapterFactory)iterator.next();
                this.embeddedFactoryRegistry.add(factory);
            }
        }
    }

    public INodeAdapter adapt(INodeNotifier notifier, Object type) {
        INodeAdapter result = null;
        if (this.embeddedTypeHandler != null && this.embeddedFactoryRegistry != null) {
            Iterator iterator = this.embeddedFactoryRegistry.iterator();
            INodeAdapterFactory factory = null;
            while (iterator.hasNext()) {
                factory = (INodeAdapterFactory)iterator.next();
                if (!factory.isFactoryForType(type)) continue;
                result = factory.adapt(notifier);
                break;
            }
        }
        return result;
    }

    public EmbeddedTypeHandler getEmbeddedType() {
        if (this.embeddedTypeHandler == null) {
            this.embeddedTypeHandler = this.getDefaultEmbeddedType();
        }
        return this.embeddedTypeHandler;
    }

    public void addEmbeddedFactory(INodeAdapterFactory factory) {
        this.embeddedFactoryRegistry.add(factory);
    }

    void changedContentType(int elementOffset, String newValue) {
        if ((this.firstContentTypePosition == -1 || elementOffset <= this.firstContentTypePosition) && this.hasValue(newValue)) {
            this.firstContentTypePosition = elementOffset;
            String potentialContentType = this.getMimeTypeFromContentTypeValue(newValue);
            this.setCachedContentType(potentialContentType);
        }
    }

    void changedLanguage(int elementOffset, String newValue) {
        if ((this.firstLanguagePosition == -1 || elementOffset <= this.firstLanguagePosition) && this.hasValue(newValue)) {
            this.firstLanguagePosition = elementOffset;
            if (!newValue.equalsIgnoreCase(this.cachedLanguage)) {
                this.setCachedLanguage(newValue);
            }
        }
    }

    void changedPageEncoding(int elementOffset, String newValue) {
    }

    private boolean hasValue(String value) {
        return value != null && value.length() > 0;
    }

    public String getContentType() {
        if (this.cachedContentType == null) {
            this.cachedContentType = this.getDefaultContentType();
        }
        return this.cachedContentType;
    }

    private String getDefaultContentType() {
        String type = null;
        IFile file = this.getFile(this.model);
        if (file != null) {
            type = JSPFContentProperties.getProperty("jsp-content-type", (IResource)file, true);
        }
        if (type == null) {
            type = "text/html";
        }
        return type;
    }

    public String getLanguage() {
        if (this.cachedLanguage == null) {
            this.cachedLanguage = this.getDefaultLanguage();
        }
        return this.cachedLanguage;
    }

    private String getDefaultLanguage() {
        String language = null;
        IFile file = this.getFile(this.model);
        if (file != null) {
            language = JSPFContentProperties.getProperty("jsp-language", (IResource)file, true);
        }
        if (language == null) {
            language = "java";
        }
        return language;
    }

    public void setCachedContentType(String newContentType) {
        this.cachedContentType = newContentType;
        if (this.model == null) {
            Logger.log(4, "model should never be null in PageDirective Adapter");
            return;
        }
        EmbeddedTypeHandler potentialNewandler = null;
        IContentDescription contentDescription = this.getContentDescription((IDocument)this.model.getStructuredDocument());
        Object prop = contentDescription.getProperty(IContentDescriptionForJSP.CONTENT_FAMILY_ATTRIBUTE);
        if (prop != null && ContentTypeFamilyForHTML.HTML_FAMILY.equals(prop)) {
            potentialNewandler = EmbeddedTypeRegistryImpl.getInstance().getTypeFor("text/html");
        }
        if (potentialNewandler == null) {
            potentialNewandler = this.getHandlerFor(this.cachedContentType);
        }
        if (this.embeddedTypeHandler == null) {
            this.setEmbeddedType(potentialNewandler);
        } else if (potentialNewandler != null && this.embeddedTypeHandler != potentialNewandler) {
            EmbeddedTypeHandler oldHandler = this.embeddedTypeHandler;
            this.setEmbeddedType(potentialNewandler);
            this.modelReinitNeeded(oldHandler, potentialNewandler);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modelReinitNeeded(EmbeddedTypeHandler oldHandler, EmbeddedTypeHandler newHandler) {
        if (this.model.isReinitializationNeeded()) {
            System.out.println("already being initialized");
        }
        try {
            this.model.aboutToChangeModel();
            this.model.setReinitializeStateData((Object)new EmbeddedTypeStateData(oldHandler, newHandler));
            this.model.setReinitializeNeeded(true);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.model.changedModel();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.model.changedModel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modelReinitNeeded(String oldlanguage, String newLanguage) {
        if (this.model.isReinitializationNeeded()) {
            return;
        }
        try {
            this.model.aboutToChangeModel();
            this.model.setReinitializeStateData((Object)newLanguage);
            this.model.setReinitializeNeeded(true);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.model.changedModel();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.model.changedModel();
    }

    public void setCachedLanguage(String newLanguage) {
        if (this.cachedLanguage != null && this.languageStateChanged(this.cachedLanguage, newLanguage) && !this.model.isReinitializationNeeded()) {
            this.modelReinitNeeded(this.cachedLanguage, newLanguage);
        }
        this.setLanguage(newLanguage);
    }

    public void setLanguage(String newLanguage) {
        this.cachedLanguage = newLanguage;
        IDocumentPartitioner partitioner = ((IDocumentExtension3)this.model.getStructuredDocument()).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning");
        if (partitioner instanceof StructuredTextPartitionerForJSP) {
            ((StructuredTextPartitionerForJSP)partitioner).setLanguage(newLanguage);
        }
    }

    private boolean languageStateChanged(String cachedLanguage, String newLanguage) {
        boolean result = false;
        if (!cachedLanguage.equalsIgnoreCase(newLanguage)) {
            boolean oldLanguageKnown = this.languageKnown(cachedLanguage);
            boolean newLanguageKnown = this.languageKnown(newLanguage);
            result = newLanguageKnown || !newLanguageKnown && oldLanguageKnown;
        }
        return result;
    }

    private boolean languageKnown(String language) {
        return StringUtils.contains((String[])this.JAVA_LANGUAGE_KEYS, (String)language, (boolean)false) || StringUtils.contains((String[])this.JAVASCRIPT_LANGUAGE_KEYS, (String)language, (boolean)false);
    }

    private IFile getFile(IStructuredModel model) {
        Path path;
        String location = model.getBaseLocation();
        if (location != null && (path = new Path(location)).segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    private EmbeddedTypeHandler getHandlerFor(String contentType) {
        EmbeddedTypeRegistry reg = this.getEmbeddedContentTypeRegistry();
        EmbeddedTypeHandler handler = null;
        if (reg != null) {
            handler = reg.getTypeFor(contentType);
        }
        return handler;
    }

    private EmbeddedTypeRegistry getEmbeddedContentTypeRegistry() {
        return EmbeddedTypeRegistryImpl.getInstance();
    }

    protected EmbeddedTypeHandler getDefaultEmbeddedType() {
        return this.getHandlerFor(this.getDefaultContentType());
    }

    public INodeNotifier getTarget() {
        return this.notifierAtCreation;
    }

    public void release() {
        if (this.embeddedTypeHandler != null) {
            if (this.embeddedFactoryRegistry != null) {
                Iterator iterator = this.embeddedFactoryRegistry.iterator();
                INodeAdapterFactory factory = null;
                while (iterator.hasNext()) {
                    factory = (INodeAdapterFactory)iterator.next();
                    factory.release();
                }
            }
            this.embeddedTypeHandler = null;
        }
    }

    private IContentDescription getContentDescription(IDocument doc) {
        if (doc == null) {
            return null;
        }
        DocumentReader in = new DocumentReader(doc);
        return this.getContentDescription((Reader)in);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContentDescription getContentDescription(Reader in) {
        if (in == null) {
            return null;
        }
        IContentDescription desc = null;
        try {
            try {
                IContentType contentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
                desc = contentTypeJSP.getDescriptionFor(in, IContentDescription.ALL);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException e) {
            Logger.logException(e);
            return desc;
        }
        in.close();
        return desc;
    }

    public String getElIgnored() {
        return this.elIgnored;
    }

    public void setElIgnored(String ignored) {
        this.elIgnored = ignored;
    }
}

