/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.StructuredMarkerAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public abstract class AbstractStructuredTextReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IReleasable {
    protected static final boolean DEBUG;
    public static final int ANNOTATION_LENGTH_LIMIT = 25;
    public static final int ELEMENT_ERROR_LIMIT = 25;
    private IDocument fDocument = null;
    private IProgressMonitor fProgressMonitor = null;
    private ISourceViewer fSourceViewer = null;
    private HashSet fMarkerAnnotations = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public AbstractStructuredTextReconcilingStrategy(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.init();
    }

    protected void addResultToAnnotationModel(IReconcileResult result) {
        if (!(result instanceof TemporaryAnnotation)) {
            return;
        }
        if (this.getAnnotationModel() != null) {
            TemporaryAnnotation tempAnnotation = (TemporaryAnnotation)result;
            StructuredMarkerAnnotation sma = this.getCorrespondingMarkerAnnotation(tempAnnotation);
            if (sma != null) {
                sma.setGrayed(false);
            }
            this.getAnnotationModel().addAnnotation((Annotation)tempAnnotation, tempAnnotation.getPosition());
        }
    }

    protected boolean canHandlePartition(String partition) {
        return false;
    }

    public abstract void createReconcileSteps();

    protected TemporaryAnnotation[] getAllAnnotationsToRemove() {
        ArrayList<ITemporaryAnnotation> removals = new ArrayList<ITemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            Iterator i = annotationModel.getAnnotationIterator();
            while (i.hasNext()) {
                ITemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                Object obj = i.next();
                if (!(obj instanceof ITemporaryAnnotation) || !this.canHandlePartition((key = (ReconcileAnnotationKey)(annotation = (ITemporaryAnnotation)obj).getKey()).getPartitionType())) continue;
                removals.add(annotation);
            }
        }
        return removals.toArray(new TemporaryAnnotation[removals.size()]);
    }

    protected IAnnotationModel getAnnotationModel() {
        IAnnotationModel model = null;
        if (this.fSourceViewer != null) {
            model = this.fSourceViewer.getAnnotationModel();
        }
        return model;
    }

    protected TemporaryAnnotation[] getAnnotationsToRemove(DirtyRegion dr, List stepsRun) {
        ArrayList<TemporaryAnnotation> remove = new ArrayList<TemporaryAnnotation>();
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (this.getAnnotationModel() != null) {
            this.getMarkerAnnotations().clear();
            Iterator i = annotationModel.getAnnotationIterator();
            while (i.hasNext()) {
                TemporaryAnnotation annotation;
                ReconcileAnnotationKey key;
                StructuredMarkerAnnotation sma;
                Object obj = i.next();
                if (obj instanceof StructuredMarkerAnnotation && ((sma = (StructuredMarkerAnnotation)((Object)obj)).getAnnotationType() == "org.eclipse.wst.sse.ui.temp.error" || sma.getAnnotationType() == "org.eclipse.wst.sse.ui.temp.warning")) {
                    this.fMarkerAnnotations.add(sma);
                }
                if (!(obj instanceof TemporaryAnnotation) || !this.canHandlePartition((key = (ReconcileAnnotationKey)(annotation = (TemporaryAnnotation)obj).getKey()).getPartitionType()) || !stepsRun.contains(key.getStep())) continue;
                if (key.getScope() == 1 && annotation.getPosition().overlapsWith(dr.getOffset(), dr.getLength())) {
                    remove.add(annotation);
                    continue;
                }
                if (key.getScope() != 0) continue;
                remove.add(annotation);
            }
        }
        return remove.toArray(new TemporaryAnnotation[remove.size()]);
    }

    protected abstract boolean containsStep(IReconcileStep var1);

    public void init() {
        this.createReconcileSteps();
    }

    public void initialReconcile() {
    }

    protected boolean isCanceled() {
        if (DEBUG && this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            System.out.println("** STRATEGY CANCELED **:" + this.getClass().getName());
        }
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }

    private void process(IReconcileResult[] results) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > STARTING PROCESS METHOD with (" + results.length + ") results");
        }
        if (results == null) {
            return;
        }
        int i = 0;
        while (i < results.length && i < 25 && !this.isCanceled()) {
            if (this.isCanceled()) {
                if (DEBUG) {
                    System.out.println("[trace reconciler] >** PROCESS (adding) WAS CANCELLED **");
                }
                return;
            }
            this.addResultToAnnotationModel(results[i]);
            ++i;
        }
        if (DEBUG) {
            StringBuffer traceString = new StringBuffer();
            int j = 0;
            while (j < results.length) {
                traceString.append("\n (+) :" + results[j] + ":\n");
                ++j;
            }
            System.out.println("[trace reconciler] > PROCESSING (" + results.length + ") results in AbstractStructuredTextReconcilingStrategy " + traceString);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    public void release() {
    }

    private void removeAnnotations(TemporaryAnnotation[] annotationsToRemove) {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (annotationModel != null) {
            int i = 0;
            while (i < annotationsToRemove.length) {
                if (this.isCanceled()) {
                    if (DEBUG) {
                        System.out.println("[trace reconciler] >** REMOVAL WAS CANCELLED **");
                    }
                    return;
                }
                StructuredMarkerAnnotation sma = this.getCorrespondingMarkerAnnotation(annotationsToRemove[i]);
                if (sma != null) {
                    sma.setGrayed(true);
                }
                annotationModel.removeAnnotation((Annotation)annotationsToRemove[i]);
                ++i;
            }
        }
        if (DEBUG) {
            StringBuffer traceString = new StringBuffer();
            int i = 0;
            while (i < annotationsToRemove.length) {
                traceString.append("\n (-) :" + annotationsToRemove[i] + ":\n");
                ++i;
            }
            System.out.println("[trace reconciler] > REMOVED (" + annotationsToRemove.length + ") annotations in AbstractStructuredTextReconcilingStrategy :" + traceString);
        }
    }

    private StructuredMarkerAnnotation getCorrespondingMarkerAnnotation(TemporaryAnnotation tempAnnotation) {
        Iterator it = this.getMarkerAnnotations().iterator();
        while (it.hasNext()) {
            String message;
            StructuredMarkerAnnotation markerAnnotation;
            block3: {
                markerAnnotation = (StructuredMarkerAnnotation)((Object)it.next());
                message = "";
                try {
                    message = (String)markerAnnotation.getMarker().getAttribute("message");
                }
                catch (CoreException e) {
                    if (!DEBUG) break block3;
                    Logger.logException(e);
                }
            }
            if (message == null || !message.equals(tempAnnotation.getText())) continue;
            return markerAnnotation;
        }
        return null;
    }

    private void removeAllAnnotations() {
        this.removeAnnotations(this.getAllAnnotationsToRemove());
    }

    public void setDocument(IDocument document) {
        this.removeAllAnnotations();
        if (document == null) {
            this.release();
        }
        this.fDocument = document;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    protected void smartProcess(TemporaryAnnotation[] annotationsToRemove, IReconcileResult[] annotationsToAdd) {
        if (this.getAnnotationModel() instanceof IAnnotationModelExtension) {
            HashMap<TemporaryAnnotation, Position> annotationsToAddMap = new HashMap<TemporaryAnnotation, Position>();
            int i = 0;
            while (i < annotationsToAdd.length) {
                TemporaryAnnotation temporaryAnnotation = (TemporaryAnnotation)annotationsToAdd[i];
                annotationsToAddMap.put(temporaryAnnotation, temporaryAnnotation.getPosition());
                ++i;
            }
            if (this.isCanceled()) {
                if (DEBUG) {
                    System.out.println("[trace reconciler] >** PROCESS (replacing) WAS CANCELLED **");
                }
                return;
            }
            ((IAnnotationModelExtension)this.getAnnotationModel()).replaceAnnotations((Annotation[])annotationsToRemove, annotationsToAddMap);
        } else {
            this.removeAnnotations(annotationsToRemove);
            this.process(annotationsToAdd);
        }
    }

    public HashSet getMarkerAnnotations() {
        if (this.fMarkerAnnotations == null) {
            this.fMarkerAnnotations = new HashSet();
        }
        return this.fMarkerAnnotations;
    }
}

