/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentmodel.annotation.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.contentmodel.annotation.CMAnnotationSourceFileLocator;
import org.eclipse.jst.jsf.contentmodel.annotation.ICMAnnotationFileParser;
import org.eclipse.jst.jsf.contentmodel.annotation.ICMAnnotationSourceFileInfo;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationAdvisor;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationMap;
import org.eclipse.jst.jsf.contentmodel.annotation.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class CMAnnotationFileParserHelper {
    private static final String DEFAULT_PARSER_NAME = "org.eclipse.jst.jsf.contentmodel.annotation.internal.CMAnnotationFileParser";
    private static final String DEFAULT_LOCATOR_NAME = "org.eclipse.jst.jsf.contentmodel.annotation.internal.CMPluginRelativeSourceFileLocator";

    public void parse(CMAnnotationMap map) {
        ICMAnnotationFileParser parser = this.getParser(map.getFileInfo());
        CMAnnotationAdvisor advisor = new CMAnnotationAdvisor(map);
        CMAnnotationSourceFileLocator locator = this.getLocator(map.getFileInfo());
        map.setLocator(locator);
        try {
            parser.parse(advisor, locator);
        }
        catch (Exception e) {
            JSFCommonPlugin.log(e, NLS.bind((String)Messages.CMAnnotationFileParserHelper_unable_to_parse, (Object[])new String[]{map.getFileInfo().getAnnotationFileLocation(), map.getFileInfo().getAnnotationFileLocatorClassname()}));
        }
    }

    private ICMAnnotationFileParser getParser(ICMAnnotationSourceFileInfo fileInfo) {
        String parserClassName = fileInfo.getParserClassName();
        Object obj = null;
        obj = parserClassName != null && !parserClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(fileInfo.getBundleId(), parserClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.common", DEFAULT_PARSER_NAME);
        if (obj != null && obj instanceof ICMAnnotationFileParser) {
            return (ICMAnnotationFileParser)obj;
        }
        return null;
    }

    private CMAnnotationSourceFileLocator getLocator(ICMAnnotationSourceFileInfo fileInfo) {
        String locatorClassName = fileInfo.getAnnotationFileLocatorClassname();
        Object obj = null;
        obj = locatorClassName != null && !locatorClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(fileInfo.getBundleId(), locatorClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.common", DEFAULT_LOCATOR_NAME);
        if (obj != null && obj instanceof CMAnnotationSourceFileLocator) {
            CMAnnotationSourceFileLocator locator = (CMAnnotationSourceFileLocator)obj;
            locator.setFileInfo(fileInfo);
            return locator;
        }
        return null;
    }

    private static Object getObjectForClassname(String bundleId, String providerClassName) {
        Bundle bundle;
        block6: {
            bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) break block6;
            JSFCommonPlugin.log(4, NLS.bind((String)Messages.CMAnnotationFileParserHelper_unable_to_find_bundleid, (Object[])new String[]{bundleId, providerClassName}));
            return null;
        }
        try {
            Class klass = bundle.loadClass(providerClassName);
            if (klass != null) {
                return klass.newInstance();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            JSFCommonPlugin.log(e, NLS.bind((String)Messages.CMAnnotationFileParserHelper_class_not_found, (Object[])new String[]{bundleId, providerClassName}));
        }
        catch (InstantiationException e) {
            JSFCommonPlugin.log(e, NLS.bind((String)Messages.CMAnnotationFileParserHelper_instantiation_exception, (Object[])new String[]{bundleId, providerClassName}));
        }
        catch (IllegalAccessException e) {
            JSFCommonPlugin.log(e, NLS.bind((String)Messages.CMAnnotationFileParserHelper_illegal_access_exception, (Object[])new String[]{bundleId, providerClassName}));
        }
        return null;
    }
}

