/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedXMIFactoryImpl;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;

public abstract class TranslatorResourceFactory
extends ReferencedXMIFactoryImpl
implements RendererFactory.Listener {
    protected RendererFactory rendererFactory;
    private boolean listeningForUpdates = false;

    public TranslatorResourceFactory(RendererFactory aRendererFactory, boolean listeningForUpdates) {
        this.rendererFactory = aRendererFactory;
        this.setListeningForUpdates(listeningForUpdates);
    }

    public TranslatorResourceFactory(RendererFactory aRendererFactory) {
        this(aRendererFactory, true);
    }

    public void setListeningForUpdates(boolean shouldBeListeningForUpdates) {
        if (this.listeningForUpdates ^ shouldBeListeningForUpdates) {
            if (!shouldBeListeningForUpdates) {
                RendererFactory.NotificationEngine.removeListener(this);
            } else {
                RendererFactory.NotificationEngine.addListener(this);
            }
            this.listeningForUpdates = shouldBeListeningForUpdates;
        }
    }

    public boolean isListeningForUpdates() {
        return this.listeningForUpdates;
    }

    public Resource doCreateResource(URI uri) {
        Renderer aRenderer = this.rendererFactory.createRenderer();
        return this.createResource(uri, aRenderer);
    }

    public void updateRendererFactory(RendererFactory newRendererFactory) {
        this.rendererFactory = newRendererFactory;
    }

    protected abstract TranslatorResource createResource(URI var1, Renderer var2);
}

