/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactoryDefaultHandler;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.RendererFactoryDefaultHandler;

public abstract class RendererFactory {
    private static RendererFactory defaultRendererFactory;
    private static RendererFactoryDefaultHandler defaultHandler;
    private boolean validating = true;
    public static final Notifier NotificationEngine;

    static {
        NotificationEngine = Notifier.INSTANCE;
    }

    public abstract Renderer createRenderer();

    public static RendererFactory getDefaultRendererFactory() {
        if (defaultRendererFactory == null) {
            defaultRendererFactory = RendererFactory.getDefaultHandler().getDefaultRendererFactory();
        }
        return defaultRendererFactory;
    }

    public static void setDefaultRendererFactory(RendererFactory factory) {
        NotificationEngine.notifyListeners(factory);
        defaultRendererFactory = factory;
    }

    public String toString() {
        return "RendererFactory instance: " + this.getClass().getName();
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean b) {
        this.validating = b;
    }

    public static RendererFactoryDefaultHandler getDefaultHandler() {
        if (defaultHandler == null) {
            defaultHandler = EMF2DOMRendererFactoryDefaultHandler.INSTANCE;
        }
        return defaultHandler;
    }

    public static void setDefaultHandler(RendererFactoryDefaultHandler handler) {
        defaultHandler = handler;
    }

    public static interface Listener {
        public void updateRendererFactory(RendererFactory var1);
    }

    public static class Notifier {
        private static final Notifier INSTANCE = new Notifier();
        private final Map resourceFactoryListeners = new WeakHashMap();

        private Notifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyListeners(RendererFactory rendererFactory) {
            int length = this.resourceFactoryListeners.size();
            if (length > 0 && rendererFactory != RendererFactory.getDefaultRendererFactory()) {
                Map map = this.resourceFactoryListeners;
                synchronized (map) {
                    Iterator i = this.resourceFactoryListeners.keySet().iterator();
                    while (i.hasNext()) {
                        Listener listener = (Listener)i.next();
                        listener.updateRendererFactory(rendererFactory);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(Listener l) {
            Map map = this.resourceFactoryListeners;
            synchronized (map) {
                this.resourceFactoryListeners.put(l, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(Listener listenerToRemove) {
            Map map = this.resourceFactoryListeners;
            synchronized (map) {
                this.resourceFactoryListeners.remove(listenerToRemove);
            }
        }
    }
}

