/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

class NewJSFileWizardPage
extends WizardNewFileCreationPage {
    private IContentType fContentType;
    private List fValidExtensions = null;

    public NewJSFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath fullPath = this.getContainerFullPath();
        IProject project = this.getProjectFromPath(fullPath);
        IPath webContentPath = this.getWebContentPath(project);
        if (webContentPath != null && !webContentPath.isPrefixOf(fullPath)) {
            this.setContainerFullPath(webContentPath);
        } else {
            this.setContainerFullPath((IPath)new Path(""));
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String fileName = this.getFileName();
        IPath fullPath = this.getContainerFullPath();
        if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
            IPath webContentPath;
            IProject project;
            if (!this.extensionValidForContentType(fileName)) {
                this.setErrorMessage(NLS.bind((String)NewWizardMessages.Javascript_Error_Filename_Must_End_JS, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (fileName.lastIndexOf(46) == -1) {
                String newFileName = this.addDefaultExtension(fileName);
                IPath resourcePath = fullPath.append(newFileName);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                if (!result.isOK()) {
                    this.setErrorMessage(result.getMessage());
                    return false;
                }
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(NewWizardMessages.Javascript_Resource_Group_Name_Exists);
                    return false;
                }
            }
            if ((project = this.getProjectFromPath(fullPath)) != null && this.isWebProject(project) && !(webContentPath = this.getWebContentPath(project)).isPrefixOf(fullPath)) {
                this.setMessage(NewWizardMessages.Javascript_Warning_Folder_Must_Be_Inside_Web_Content, 2);
            }
        }
        return true;
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        newFileName.append(".");
        newFileName.append("js");
        return newFileName.toString();
    }

    private IProject getProjectFromPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    private boolean isWebProject(IProject project) {
        return true;
    }

    private IPath getWebContentPath(IProject project) {
        IPath path = null;
        if (project != null && this.isWebProject(project)) {
            path = project.getFullPath();
            path.append("/");
        }
        return path;
    }
}

