/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ExtractInterfaceConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class ExtractInterfaceProcessor
extends SuperTypeRefactoringProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_PUBLIC = "public";
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.extractInterfaceProcessor";
    private static final GroupCategorySet SET_EXTRACT_INTERFACE = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.extractInterface", RefactoringCoreMessages.ExtractInterfaceProcessor_category_name, RefactoringCoreMessages.ExtractInterfaceProcessor_category_description));
    private boolean fAbstract = true;
    private TextEditBasedChangeManager fChangeManager = null;
    private boolean fComments = true;
    private IMember[] fMembers = null;
    private boolean fPublic = true;
    private IType fSubType;
    private String fSuperName;
    private String fSuperSource = null;

    protected static boolean isExtractableMember(IMember member) throws JavaScriptModelException {
        Assert.isNotNull((Object)member);
        switch (member.getElementType()) {
            case 9: {
                return JdtFlags.isPublic(member) && !JdtFlags.isStatic(member) && !((IFunction)member).isConstructor();
            }
            case 8: {
                return JdtFlags.isPublic(member) && JdtFlags.isStatic(member) && JdtFlags.isFinal(member) && !JdtFlags.isEnum(member);
            }
        }
        return false;
    }

    public ExtractInterfaceProcessor(IType type, CodeGenerationSettings settings) {
        super(settings);
        this.fSubType = type;
        if (this.fSubType != null) {
            this.fSuperName = this.fSubType.getElementName();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block6: {
            RefactoringStatus refactoringStatus;
            Assert.isNotNull((Object)monitor);
            Assert.isNotNull((Object)context);
            status = new RefactoringStatus();
            this.fChangeManager = new TextEditBasedChangeManager();
            try {
                RefactoringStatus validation;
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
                status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
                if (status.hasError()) break block6;
                if (this.fSubType.isBinary() || this.fSubType.isReadOnly() || !this.fSubType.exists()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                if (this.fSubType.isAnonymous()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_anonymous, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                if (this.fSubType.isAnnotation()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_annotation, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                status.merge(this.checkSuperType());
                if (status.hasFatalError() || status.hasFatalError()) break block6;
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                if (status.hasFatalError() || (validation = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext())).isOK()) break block6;
                refactoringStatus = validation;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        Object var5_8 = null;
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
            status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return status;
    }

    protected final RefactoringStatus checkSuperType() throws JavaScriptModelException {
        IPackageFragment fragment = this.fSubType.getPackageFragment();
        IType type = Checks.findTypeInPackage(fragment, this.fSuperName);
        if (type != null && type.exists()) {
            if (fragment.isDefaultPackage()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_default_type, new String[]{this.fSuperName}));
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_type, new String[]{this.fSuperName, fragment.getElementName()}));
        }
        return new RefactoringStatus();
    }

    public final RefactoringStatus checkTypeName(String name) {
        Assert.isNotNull((Object)name);
        try {
            RefactoringStatus result = Checks.checkTypeName(name);
            if (result.hasFatalError()) {
                return result;
            }
            String unitName = JavaModelUtil.getRenamedCUName(this.fSubType.getJavaScriptUnit(), name);
            result.merge(Checks.checkCompilationUnitName(unitName));
            if (result.hasFatalError()) {
                return result;
            }
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            if (fragment.getJavaScriptUnit(unitName).exists()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_compilation_unit, new String[]{unitName, fragment.getElementName()}));
                return result;
            }
            result.merge(this.checkSuperType());
            return result;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error);
        }
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fSubType.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (this.fSubType.isLocal() || this.fSubType.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            IJavaScriptUnit cu = fragment.getJavaScriptUnit(JavaModelUtil.getRenamedCUName(this.fSubType.getJavaScriptUnit(), this.fSuperName));
            IType type = cu.getType(this.fSuperName);
            String description = Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_description_descriptor_short, this.fSuperName);
            String header = Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)type, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fSubType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_refactored_element_pattern, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)type, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
            String[] settings = new String[this.fMembers.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fMembers[index], JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractInterfaceProcessor_extracted_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.interface", project, description, comment.asString(), arguments, flags);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fSubType));
            arguments.put("name", this.fSuperName);
            int index2 = 0;
            while (index2 < this.fMembers.length) {
                arguments.put("element" + (index2 + 1), descriptor.elementToHandle((IJavaScriptElement)this.fMembers[index2]));
                ++index2;
            }
            arguments.put(ATTRIBUTE_ABSTRACT, Boolean.valueOf(this.fAbstract).toString());
            arguments.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fComments).toString());
            arguments.put(ATTRIBUTE_PUBLIC, Boolean.valueOf(this.fPublic).toString());
            arguments.put("replace", Boolean.valueOf(this.fReplace).toString());
            arguments.put("instanceof", Boolean.valueOf(this.fInstanceOf).toString());
            DynamicValidationRefactoringChange change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ExtractInterfaceRefactoring_name, (Change[])this.fChangeManager.getAllChanges());
            IFile file = ResourceUtil.getFile(this.fSubType.getJavaScriptUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add(new CreateCompilationUnitChange(this.fSubType.getPackageFragment().getJavaScriptUnit(JavaModelUtil.getRenamedCUName(this.fSubType.getJavaScriptUnit(), this.fSuperName)), this.fSuperSource, file.getCharset(false)));
            }
            monitor.worked(1);
            dynamicValidationRefactoringChange = change;
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return dynamicValidationRefactoringChange;
    }

    protected final TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException, CoreException {
        TextEditBasedChangeManager textEditBasedChangeManager;
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            this.resetEnvironment();
            TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            CompilationUnitRewrite sourceRewrite = new CompilationUnitRewrite(this.fSubType.getJavaScriptUnit());
            AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.fSubType, sourceRewrite.getRoot());
            if (declaration != null) {
                IFunction[] methods;
                this.createTypeSignature(sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                IField[] fields = this.getExtractedFields(this.fSubType.getJavaScriptUnit());
                if (fields.length > 0) {
                    ASTNodeDeleteUtil.markAsDeleted((IJavaScriptElement[])fields, sourceRewrite, (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_remove_field_label, SET_EXTRACT_INTERFACE));
                }
                if (this.fSubType.isInterface() && (methods = this.getExtractedMethods(this.fSubType.getJavaScriptUnit())).length > 0) {
                    ASTNodeDeleteUtil.markAsDeleted((IJavaScriptElement[])methods, sourceRewrite, (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_remove_method_label, SET_EXTRACT_INTERFACE));
                }
                String name = JavaModelUtil.getRenamedCUName(this.fSubType.getJavaScriptUnit(), this.fSuperName);
                IJavaScriptUnit original = this.fSubType.getPackageFragment().getJavaScriptUnit(name);
                IJavaScriptUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                this.fSuperSource = this.createTypeSource(copy, this.fSubType, this.fSuperName, sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                if (this.fSuperSource != null) {
                    copy.getBuffer().setContents(this.fSuperSource);
                    JavaModelUtil.reconcile(copy);
                }
                HashSet replacements = new HashSet();
                if (this.fReplace) {
                    this.rewriteTypeOccurrences(manager, sourceRewrite, copy, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 220));
                }
                this.createMethodComments(sourceRewrite, replacements);
                manager.manage(this.fSubType.getJavaScriptUnit(), (TextEditBasedChange)sourceRewrite.createChange());
            }
            textEditBasedChangeManager = manager;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textEditBasedChangeManager;
    }

    protected final SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new ExtractInterfaceConstraintsSolver(model, this.fSuperName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createFieldDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, VariableDeclarationFragment fragment) throws CoreException {
        Assert.isNotNull((Object)targetDeclaration);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)fragment);
        FieldDeclaration field = (FieldDeclaration)fragment.getParent();
        ImportRewriteUtil.collectImports(this.fSubType.getJavaScriptProject(), (ASTNode)field, this.fTypeBindings, this.fStaticBindings, false);
        ASTRewrite rewrite = ASTRewrite.create((AST)field.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)field);
        ListRewrite rewriter = rewrite.getListRewrite((ASTNode)field, FieldDeclaration.FRAGMENTS_PROPERTY);
        VariableDeclarationFragment current = null;
        Iterator iterator = field.fragments().iterator();
        while (iterator.hasNext()) {
            current = (VariableDeclarationFragment)iterator.next();
            if (current.getName().getIdentifier().equals(fragment.getName().getIdentifier())) continue;
            rewriter.remove((ASTNode)current, null);
        }
        IJavaScriptUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 23), null);
            }
            catch (MalformedTreeException exception) {
                JavaScriptPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            RefactoringFileBuffers.release(unit);
            throw throwable;
        }
        RefactoringFileBuffers.release(unit);
    }

    protected final void createMemberDeclarations(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        Arrays.sort(this.fMembers, new Comparator(){

            public final int compare(Object first, Object second) {
                Assert.isNotNull((Object)first);
                Assert.isNotNull((Object)second);
                ISourceReference predecessor = (ISourceReference)first;
                ISourceReference successor = (ISourceReference)second;
                try {
                    return predecessor.getSourceRange().getOffset() - successor.getSourceRange().getOffset();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return first.hashCode() - second.hashCode();
                }
            }
        });
        this.fTypeBindings.clear();
        this.fStaticBindings.clear();
        if (this.fMembers.length > 0) {
            IMember member = null;
            int index = this.fMembers.length - 1;
            while (index >= 0) {
                member = this.fMembers[index];
                if (member instanceof IField) {
                    this.createFieldDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, sourceRewrite.getRoot()));
                } else if (member instanceof IFunction) {
                    this.createMethodDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getMethodDeclarationNode((IFunction)member, sourceRewrite.getRoot()));
                }
                --index;
            }
        }
    }

    protected final void createMethodComment(CompilationUnitRewrite sourceRewrite, FunctionDeclaration declaration, Set replacements, boolean javadoc) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)replacements);
        IFunctionBinding binding = declaration.resolveBinding();
        if (binding != null) {
            IVariableBinding variable = null;
            SingleVariableDeclaration argument = null;
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            String string = fragment.isDefaultPackage() ? this.fSuperName : String.valueOf(fragment.getElementName()) + "." + this.fSuperName;
            ITypeBinding[] bindings = binding.getParameterTypes();
            String[] names = new String[bindings.length];
            int offset = 0;
            while (offset < names.length) {
                argument = (SingleVariableDeclaration)declaration.parameters().get(offset);
                variable = argument.resolveBinding();
                if (variable != null) {
                    names[offset] = replacements.contains(variable.getKey()) ? string : (binding.isVarargs() && bindings[offset].isArray() && offset == names.length - 1 ? Bindings.getFullyQualifiedName(bindings[offset].getElementType()) : Bindings.getFullyQualifiedName(bindings[offset]));
                }
                ++offset;
            }
            String comment = CodeGeneration.getMethodComment(this.fSubType.getJavaScriptUnit(), this.fSubType.getElementName(), declaration, false, binding.getName(), string, names, StubUtility.getLineDelimiterUsed(this.fSubType.getJavaScriptProject()));
            if (comment != null) {
                ASTRewrite rewrite = sourceRewrite.getASTRewrite();
                if (declaration.getJavadoc() != null) {
                    rewrite.replace((ASTNode)declaration.getJavadoc(), rewrite.createStringPlaceholder(comment, 29), (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_rewrite_comment, SET_EXTRACT_INTERFACE));
                } else if (javadoc) {
                    rewrite.set((ASTNode)declaration, (StructuralPropertyDescriptor)FunctionDeclaration.JAVADOC_PROPERTY, (Object)rewrite.createStringPlaceholder(comment, 29), (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_add_comment, SET_EXTRACT_INTERFACE));
                }
            }
        }
    }

    protected final void createMethodComments(CompilationUnitRewrite sourceRewrite, Set replacements) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)replacements);
        if (this.fComments && this.fMembers.length > 0) {
            IJavaScriptProject project = this.fSubType.getJavaScriptProject();
            boolean javadoc = project.getOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", true).equals("enabled");
            IMember member = null;
            int index = 0;
            while (index < this.fMembers.length) {
                member = this.fMembers[index];
                if (member instanceof IFunction) {
                    this.createMethodComment(sourceRewrite, ASTNodeSearchUtil.getMethodDeclarationNode((IFunction)member, sourceRewrite.getRoot()), replacements, javadoc);
                }
                ++index;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createMethodDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, FunctionDeclaration declaration) throws CoreException {
        Assert.isNotNull((Object)targetDeclaration);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaration);
        ImportRewriteUtil.collectImports(this.fSubType.getJavaScriptProject(), (ASTNode)declaration, this.fTypeBindings, this.fStaticBindings, true);
        ASTRewrite rewrite = ASTRewrite.create((AST)declaration.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)declaration);
        if (declaration.getBody() != null) {
            rewrite.remove((ASTNode)declaration.getBody(), null);
        }
        ListRewrite list = rewrite.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
        boolean publicFound = false;
        boolean abstractFound = false;
        Modifier modifier = null;
        IExtendedModifier extended = null;
        Iterator iterator = declaration.modifiers().iterator();
        while (iterator.hasNext()) {
            extended = (IExtendedModifier)iterator.next();
            if (extended.isAnnotation()) continue;
            modifier = (Modifier)extended;
            if (this.fPublic && modifier.getKeyword().equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD)) {
                publicFound = true;
                continue;
            }
            if (this.fAbstract && modifier.getKeyword().equals(Modifier.ModifierKeyword.ABSTRACT_KEYWORD)) {
                abstractFound = true;
                continue;
            }
            list.remove((ASTNode)modifier, null);
        }
        ModifierRewrite rewriter = ModifierRewrite.create(rewrite, (ASTNode)declaration);
        if (this.fPublic && !publicFound) {
            rewriter.setVisibility(1, null);
        }
        if (this.fAbstract && !abstractFound) {
            rewriter.setModifiers(1024, 0, null);
        }
        IJavaScriptUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 31), null);
            }
            catch (MalformedTreeException exception) {
                JavaScriptPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            RefactoringFileBuffers.release(unit);
            throw throwable;
        }
        RefactoringFileBuffers.release(unit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createTypeSignature(CompilationUnitRewrite rewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            AST ast = declaration.getAST();
            ITypeParameter[] parameters = this.fSubType.getTypeParameters();
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(this.fSuperName));
            if (parameters.length > 0) {
                ParameterizedType parameterized = ast.newParameterizedType((Type)type);
                int index = 0;
                while (true) {
                    if (index >= parameters.length) {
                        type = parameterized;
                        break;
                    }
                    parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                    ++index;
                }
            }
            ASTRewrite rewriter = rewrite.getASTRewrite();
            if (declaration instanceof TypeDeclaration) {
                rewriter.getListRewrite((ASTNode)declaration, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_add_super_interface, SET_EXTRACT_INTERFACE));
            }
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        monitor.done();
    }

    public final boolean getAbstract() {
        return this.fAbstract;
    }

    public final Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public final IMember[] getExtractableMembers() throws JavaScriptModelException {
        ArrayList<IJavaScriptElement> list = new ArrayList<IJavaScriptElement>();
        IJavaScriptElement[] children = this.fSubType.getChildren();
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IMember && ExtractInterfaceProcessor.isExtractableMember((IMember)children[index])) {
                list.add(children[index]);
            }
            ++index;
        }
        IMember[] members = new IMember[list.size()];
        list.toArray(members);
        return members;
    }

    protected final IField[] getExtractedFields(IJavaScriptUnit unit) {
        Assert.isNotNull((Object)unit);
        ArrayList<IJavaScriptElement> list = new ArrayList<IJavaScriptElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaScriptElement element;
            if (this.fMembers[index] instanceof IField && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaScriptElement)this.fMembers[index])) instanceof IField) {
                list.add(element);
            }
            ++index;
        }
        IField[] fields = new IField[list.size()];
        list.toArray(fields);
        return fields;
    }

    protected final IFunction[] getExtractedMethods(IJavaScriptUnit unit) {
        Assert.isNotNull((Object)unit);
        ArrayList<IJavaScriptElement> list = new ArrayList<IJavaScriptElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaScriptElement element;
            if (this.fMembers[index] instanceof IFunction && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaScriptElement)this.fMembers[index])) instanceof IFunction) {
                list.add(element);
            }
            ++index;
        }
        IFunction[] methods = new IFunction[list.size()];
        list.toArray(methods);
        return methods;
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.ExtractInterfaceProcessor_name;
    }

    public final boolean getPublic() {
        return this.fPublic;
    }

    public final IType getType() {
        return this.fSubType;
    }

    public final String getTypeName() {
        return this.fSuperName;
    }

    public final RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.interface");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fSubType = (IType)element;
            String name = extended.getAttribute("name");
            if (name != null) {
                this.fSuperName = name;
                RefactoringStatus status = this.checkTypeName(name);
                if (status.hasError()) {
                    return status;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            String deferred = extended.getAttribute(ATTRIBUTE_ABSTRACT);
            if (deferred == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
            }
            this.fAbstract = Boolean.valueOf(deferred);
            String comment = extended.getAttribute(ATTRIBUTE_COMMENTS);
            if (comment == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
            }
            this.fComments = Boolean.valueOf(comment);
            String instance = extended.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
            }
            this.fInstanceOf = Boolean.valueOf(instance);
            String visibility = extended.getAttribute(ATTRIBUTE_PUBLIC);
            if (visibility == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PUBLIC));
            }
            this.fPublic = Boolean.valueOf(visibility);
            String replace = extended.getAttribute("replace");
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
            }
            this.fReplace = Boolean.valueOf(replace);
            int count = 1;
            ArrayList<IJavaScriptElement> elements = new ArrayList<IJavaScriptElement>();
            String attribute = "element" + count;
            RefactoringStatus status = new RefactoringStatus();
            while ((handle = extended.getAttribute(attribute)) != null) {
                IJavaScriptElement element2 = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element2 == null || !element2.exists()) {
                    status.merge(ScriptableRefactoring.createInputWarningStatus(element2, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.interface"));
                } else {
                    elements.add(element2);
                }
                attribute = "element" + ++count;
            }
            this.fMembers = elements.toArray(new IMember[elements.size()]);
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fSubType.getJavaScriptProject());
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaScriptElement)this.fSubType) && !this.fSubType.isBinary() && !this.fSubType.isReadOnly() && !this.fSubType.isAnnotation() && !this.fSubType.isAnonymous();
    }

    public final boolean isComments() {
        return this.fComments;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected final String normalizeText(String code) throws JavaScriptModelException {
        Assert.isNotNull((Object)code);
        String[] lines = Strings.convertIntoLines(code);
        IJavaScriptProject project = this.fSubType.getJavaScriptProject();
        Strings.trimIndentation(lines, project, false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(project));
    }

    protected void resetEnvironment() {
        this.fSuperSource = null;
        this.resetWorkingCopies();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, IJavaScriptUnit unit, JavaScriptUnit node, Set replacements, IProgressMonitor monitor) throws CoreException {
        try {
            CompilationUnitChange change;
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            CompilationUnitRewrite currentRewrite = null;
            boolean isSubUnit = rewrite.getCu().equals(unit.getPrimary());
            currentRewrite = isSubUnit ? rewrite : new CompilationUnitRewrite(unit, node);
            Collection collection = (Collection)this.fTypeOccurrences.get(unit);
            if (collection != null && !collection.isEmpty()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    subMonitor.beginTask("", collection.size() * 10);
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                    TType estimate = null;
                    ISourceConstraintVariable variable = null;
                    ITypeConstraintVariable constraint = null;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        variable = (ISourceConstraintVariable)iterator.next();
                        if (!(variable instanceof ITypeConstraintVariable) || (estimate = (TType)(constraint = (ITypeConstraintVariable)variable).getData("te")) == null) continue;
                        CompilationUnitRange range = constraint.getRange();
                        if (isSubUnit) {
                            this.rewriteTypeOccurrence(range, estimate, requestor, currentRewrite, node, replacements, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        } else {
                            ASTNode result = NodeFinder.perform((ASTNode)node, range.getSourceRange());
                            if (result != null) {
                                this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                            }
                        }
                        subMonitor.worked(10);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_19 = null;
                    subMonitor.done();
                    throw throwable;
                }
                {
                    Object var18_20 = null;
                }
                subMonitor.done();
            }
            if (!isSubUnit && (change = currentRewrite.createChange()) != null) {
                manager.manage(unit, (TextEditBasedChange)change);
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var20_23 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, final IJavaScriptUnit superUnit, final Set replacements, final RefactoringStatus status, final IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)superUnit);
        Assert.isNotNull((Object)replacements);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            IJavaScriptUnit subUnit = this.getSharedWorkingCopy(this.fSubType.getJavaScriptUnit().getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.fSubType.getJavaScriptUnit());
            ASTRewrite rewrite = sourceRewrite.getASTRewrite();
            try {
                Document document = new Document(buffer.getDocument().get());
                try {
                    rewrite.rewriteAST((IDocument)document, this.fSubType.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaScriptPlugin.log(exception);
                }
                catch (BadLocationException exception) {
                    JavaScriptPlugin.log(exception);
                }
                subUnit.getBuffer().setContents(document.get());
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                RefactoringFileBuffers.release(this.fSubType.getJavaScriptUnit());
                throw throwable;
            }
            {
                Object var12_16 = null;
            }
            RefactoringFileBuffers.release(this.fSubType.getJavaScriptUnit());
            JavaModelUtil.reconcile(subUnit);
            IJavaScriptProject project = subUnit.getJavaScriptProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project));
            parser.createASTs(new IJavaScriptUnit[]{subUnit}, new String[0], new ASTRequestor(){

                public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                    block7: {
                        try {
                            TextEdit edit;
                            TextEditBasedChange change;
                            ITypeBinding subBinding;
                            IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaScriptElement)ExtractInterfaceProcessor.this.fSubType);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                            if (subDeclaration == null || (subBinding = subDeclaration.resolveBinding()) == null) break block7;
                            String name = null;
                            ITypeBinding superBinding = null;
                            ITypeBinding[] superBindings = subBinding.getInterfaces();
                            int index = 0;
                            while (index < superBindings.length) {
                                name = superBindings[index].getName();
                                if (name.startsWith(ExtractInterfaceProcessor.this.fSuperName) && superBindings[index].getTypeArguments().length == subBinding.getTypeParameters().length) {
                                    superBinding = superBindings[index];
                                }
                                ++index;
                            }
                            if (superBinding == null) break block7;
                            ExtractInterfaceProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 80), status);
                            if (status.hasFatalError()) break block7;
                            ExtractInterfaceProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                            if (!manager.containsChangesIn(superUnit) || !((change = manager.get(superUnit)) instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null) break block7;
                            Document document = new Document(superUnit.getBuffer().getContents());
                            try {
                                edit.apply((IDocument)document, 2);
                            }
                            catch (MalformedTreeException exception) {
                                JavaScriptPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                            }
                            catch (BadLocationException exception) {
                                JavaScriptPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                            }
                            ExtractInterfaceProcessor.this.fSuperSource = document.get();
                            manager.remove(superUnit);
                        }
                        catch (JavaScriptModelException exception) {
                            JavaScriptPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                        }
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var14_19 = null;
        }
        monitor.done();
    }

    public final void setAbstract(boolean declare) {
        this.fAbstract = declare;
    }

    public final void setComments(boolean comments) {
        this.fComments = comments;
    }

    public final void setExtractedMembers(IMember[] members) throws JavaScriptModelException {
        this.fMembers = members;
    }

    public final void setPublic(boolean declare) {
        this.fPublic = declare;
    }

    public final void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fSuperName = name;
    }
}

