/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.section;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.ProjectWebPageSelectionDialog;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PropertyMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.section.AbstractEditPartGroup;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

class PageGroup
extends AbstractEditPartGroup {
    private StringButtonDialogField fromViewField;
    private PageflowPage pfPage = null;
    private StringDialogField largeIconField;
    private StringDialogField smallIconField;

    PageGroup() {
    }

    public void initialize() {
        this.fromViewField = new StringButtonDialogField((IStringButtonAdapter)new StringButtonAdapter());
        this.fromViewField.setLabelText(PropertyMessages.property_fromView);
        this.fromViewField.setButtonLabel("...");
        this.fromViewField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.largeIconField = new StringDialogField();
        this.largeIconField.setLabelText(PropertyMessages.property_largeIcon);
        this.largeIconField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.smallIconField = new StringDialogField();
        this.smallIconField.setLabelText(PropertyMessages.property_smallIcon);
        this.smallIconField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        super.initialize();
    }

    public void refreshData() {
        if (this.pfPage != null) {
            this.fromViewField.setTextWithoutUpdate(PageGroup.assertString(this.pfPage.getPath()));
            this.largeIconField.setTextWithoutUpdate(PageGroup.assertString(this.pfPage.getLargeicon()));
            this.smallIconField.setTextWithoutUpdate(PageGroup.assertString(this.pfPage.getSmallicon()));
            super.refreshData(this.pfPage);
        }
    }

    private static String assertString(String value) {
        return value == null ? "" : value;
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        Composite top = toolkit == null ? new Composite(parent, 0) : toolkit.createComposite(parent);
        FillLayout fillLayout = new FillLayout(512);
        parent.setLayout((Layout)fillLayout);
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        top.setLayout((Layout)layout);
        this.fromViewField.doFillIntoGrid(toolkit, top, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.fromViewField.getTextControl(toolkit, top));
        this.largeIconField.doFillIntoGrid(toolkit, top, numberOfColumns);
        this.smallIconField.doFillIntoGrid(toolkit, top, numberOfColumns);
        super.layoutDialogFields(toolkit, top, 4);
        GridData data = new GridData();
        data.widthHint = 20;
        data.heightHint = 18;
        this.fromViewField.getChangeControl(toolkit, top).setLayoutData((Object)data);
    }

    public void setPropertyProvider(PageflowPage elem) {
        this.pfPage = elem;
        this.refreshData();
    }

    public StringButtonDialogField getFromViewField() {
        return this.fromViewField;
    }

    public StringDialogField getLargeIconField() {
        return this.largeIconField;
    }

    public StringDialogField getSmallIconField() {
        return this.smallIconField;
    }

    class StringButtonAdapter
    implements IStringButtonAdapter {
        StringButtonAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IProject project = WebrootUtil.getProject(PageGroup.this.pfPage);
            ProjectWebPageSelectionDialog dlg = new ProjectWebPageSelectionDialog(field.getLabelControl(null, null).getShell(), project);
            if (dlg.open() == 0) {
                PageGroup.this.fromViewField.setText(dlg.getResultFilePath());
            }
        }
    }
}

