/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;

public class TaglibController
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    static final boolean _debugCache = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/cache"));
    static TaglibController _instance = null;
    private static boolean fIsShutdown = false;
    IFileBufferListener fBufferListener = new FileBufferListener();
    Map fDocumentMap;
    List fJSPdocuments = new ArrayList(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPath getLocation(IDocument document) {
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            DocumentInfo info = (DocumentInfo)TaglibController._instance.fDocumentMap.get(document);
            if (info != null) {
                return info.location;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPath getLocation(TLDCMDocumentManager manager) {
        if (_instance == null) {
            return null;
        }
        IPath location = null;
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            Iterator docInfos = TaglibController._instance.fDocumentMap.values().iterator();
            while (docInfos.hasNext() && location == null) {
                DocumentInfo info = (DocumentInfo)docInfos.next();
                if (!info.tldDocumentManager.equals(manager)) continue;
                location = info.location;
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TLDCMDocumentManager getTLDCMDocumentManager(IDocument document) {
        if (_instance == null) {
            return null;
        }
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            DocumentInfo info = (DocumentInfo)TaglibController._instance.fDocumentMap.get(document);
            if (info != null) {
                return info.tldDocumentManager;
            }
            return null;
        }
    }

    private static synchronized boolean isShutdown() {
        return fIsShutdown;
    }

    private static synchronized void setShutdown(boolean isShutdown) {
        fIsShutdown = isShutdown;
    }

    public static synchronized void shutdown() {
        TaglibController.setShutdown(true);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(TaglibController._instance.fBufferListener);
        _instance = null;
    }

    public static synchronized void startup() {
        if (_instance == null) {
            _instance = new TaglibController();
            FileBuffers.getTextFileBufferManager().addFileBufferListener(TaglibController._instance.fBufferListener);
        }
        TaglibController.setShutdown(false);
    }

    public TaglibController() {
        this.fDocumentMap = new HashMap(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(IDocument document) {
        if (TaglibController.isShutdown()) {
            return;
        }
        List list = TaglibController._instance.fJSPdocuments;
        synchronized (list) {
            TaglibController._instance.fJSPdocuments.add(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(IDocument document, IPath location, LocationKind locationKind) {
        if (TaglibController.isShutdown()) {
            return;
        }
        List list = TaglibController._instance.fJSPdocuments;
        synchronized (list) {
            TaglibController._instance.fJSPdocuments.add(document);
        }
        DocumentInfo info = new DocumentInfo();
        info.document = (IStructuredDocument)document;
        info.textFileBuffer = null;
        info.location = location;
        info.locationKind = locationKind;
        info.tldDocumentManager = new TLDCMDocumentManager();
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            TaglibController._instance.fDocumentMap.put(document, info);
        }
        info.tldDocumentManager.setSourceParser((JSPSourceParser)info.document.getParser());
        if (document instanceof BasicStructuredDocument && document.getLength() > 0) {
            ((BasicStructuredDocument)document).reparse((Object)this);
        }
        TaglibIndex.addTaglibIndexListener(info);
    }

    class DocumentInfo
    implements ITaglibIndexListener {
        IStructuredDocument document;
        ITextFileBuffer textFileBuffer;
        IPath location;
        LocationKind locationKind;
        TLDCMDocumentManager tldDocumentManager;

        DocumentInfo() {
        }

        public void indexChanged(ITaglibIndexDelta delta) {
            int type = delta.getKind();
            if (type == 4 || type == 2) {
                ITaglibIndexDelta[] deltas = delta.getAffectedChildren();
                boolean affected = false;
                int i = 0;
                while (i < deltas.length) {
                    Object key = TLDCMDocumentManager.getUniqueIdentifier(deltas[i].getTaglibRecord());
                    if (this.tldDocumentManager.getDocuments().containsKey(key)) {
                        affected = true;
                    }
                    ++i;
                }
                if (affected) {
                    if (_debugCache) {
                        System.out.println("TLDCMDocumentManager cleared its private CMDocument cache");
                    }
                    this.tldDocumentManager.getDocuments().clear();
                    this.tldDocumentManager.getSourceParser().resetHandlers();
                    if (this.document instanceof BasicStructuredDocument) {
                        ((BasicStructuredDocument)this.document).reparse((Object)this);
                    }
                }
            }
            this.tldDocumentManager.indexChanged(delta);
        }
    }

    class FileBufferListener
    implements IFileBufferListener {
        FileBufferListener() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferCreated(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                IDocument document = ((ITextFileBuffer)buffer).getDocument();
                List list = TaglibController._instance.fJSPdocuments;
                synchronized (list) {
                    if (!TaglibController._instance.fJSPdocuments.contains(document)) {
                        return;
                    }
                }
                Assert.isTrue((boolean)(document instanceof IStructuredDocument), (String)(String.valueOf(this.getClass().getName()) + " SetupParticipant was called for non-IStructuredDocument"));
                DocumentInfo info = null;
                Map map = TaglibController._instance.fDocumentMap;
                synchronized (map) {
                    info = (DocumentInfo)TaglibController._instance.fDocumentMap.get(document);
                }
                if (info != null) {
                    info.textFileBuffer = (ITextFileBuffer)buffer;
                } else {
                    info = new DocumentInfo();
                    info.document = (IStructuredDocument)document;
                    info.textFileBuffer = (ITextFileBuffer)buffer;
                    info.location = buffer.getLocation();
                    info.locationKind = LocationKind.NORMALIZE;
                    info.tldDocumentManager = new TLDCMDocumentManager();
                    info.tldDocumentManager.setSourceParser((JSPSourceParser)info.document.getParser());
                    map = TaglibController._instance.fDocumentMap;
                    synchronized (map) {
                        TaglibController._instance.fDocumentMap.put(document, info);
                    }
                    TaglibIndex.addTaglibIndexListener(info);
                    if (document instanceof BasicStructuredDocument && document.getLength() > 0) {
                        ((BasicStructuredDocument)document).reparse((Object)this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferDisposed(IFileBuffer buffer) {
            Object object;
            if (buffer instanceof ITextFileBuffer) {
                IDocument document = ((ITextFileBuffer)buffer).getDocument();
                object = TaglibController._instance.fJSPdocuments;
                synchronized (object) {
                    if (!TaglibController._instance.fJSPdocuments.remove(document)) {
                        return;
                    }
                }
            }
            DocumentInfo info = null;
            object = TaglibController.this.fDocumentMap;
            synchronized (object) {
                Map.Entry[] entries = TaglibController.this.fDocumentMap.entrySet().toArray(new Map.Entry[TaglibController.this.fDocumentMap.size()]);
                int i = 0;
                while (i < entries.length) {
                    info = (DocumentInfo)entries[i].getValue();
                    if (info != null && info.textFileBuffer != null && info.textFileBuffer.equals(buffer)) {
                        TaglibController.this.fDocumentMap.remove(entries[i].getKey());
                        break;
                    }
                    ++i;
                }
            }
            if (info != null) {
                info.tldDocumentManager.clearCache();
                TaglibIndex.removeTaglibIndexListener(info);
            }
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }
    }
}

