/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.query.execute;

import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;
import org.eclipse.wst.rdb.server.internal.ui.ServerUIPlugin;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.ISQLExecutionProvider;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class QueryOutputHelper {
    private String objectName = "";
    private String statementSource = "";
    private OutputItem stmtOutput = null;
    private Vector sqlExecutionProviders = null;
    private Connection jdbcConnection = null;
    private boolean updateOutputItemStatus = true;

    public QueryOutputHelper(Connection connection) {
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public QueryOutputHelper(String statementString, Connection connection) {
        this.statementSource = statementString;
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setOutputItem(OutputItem stmtOutput) {
        this.stmtOutput = stmtOutput;
    }

    public void setUpdateOutputItemStatus(boolean updateOutputItemStatus) {
        this.updateOutputItemStatus = updateOutputItemStatus;
    }

    public void setStatement(String statementSource) {
        this.statementSource = statementSource;
    }

    /*
     * Exception decompiling
     */
    public boolean runQueryForAdminEditor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 587->593)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean runSQLScrapbookQuery() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 587->593)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean runQuery() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 406->412)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean executeDDL(String source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 206->212)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCallStatement(String sql) {
        int len = sql.length();
        int i = 0;
        while (i < len) {
            if (sql.charAt(i) != ' ') {
                int end = Math.min(i + 4, len);
                String sub = sql.substring(i, end);
                return sub.toUpperCase().equals("CALL");
            }
            ++i;
        }
        return false;
    }

    private boolean isCreateStatement(String sql) {
        int len = sql.length();
        int i = 0;
        while (i < len) {
            if (sql.charAt(i) != ' ') {
                int end = Math.min(i + 6, len);
                String sub = sql.substring(i, end);
                return sub.toUpperCase().equals("CREATE");
            }
            ++i;
        }
        return false;
    }

    private void showErrors(String messageText, int newStatus) {
        if (this.updateOutputItemStatus) {
            OutputViewAPI.getInstance().updateStatus(this.getOutputItem(), newStatus);
        }
        this.showMessage(messageText);
    }

    private void showMessage(String messageText) {
        OutputViewAPI.getInstance().showMessage(this.getOutputItem(), messageText, false);
    }

    private OutputItem getOutputItem() {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OutputItem(1, 23, this.objectName);
        }
        return this.stmtOutput;
    }

    private OutputItem getOutputItem(String source) {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OutputItem(1, 23, source);
        }
        return this.stmtOutput;
    }

    private void displayMessages(SQLWarning except) {
        String reason = "";
        reason = except instanceof DataTruncation ? ResourceLoader.INSTANCE.queryString("_WARN_DATA_WAS_TRUNCATED") : ResourceLoader.INSTANCE.queryString("_WARN_SQL_WARNINGS_FOUND");
        OutputViewAPI.getInstance().showMessage(this.getOutputItem(), reason, false);
        do {
            OutputViewAPI.getInstance().showMessage(this.getOutputItem(), "SQLState=" + except.getSQLState() + " " + except.getMessage(), false);
        } while ((except = except.getNextWarning()) != null);
    }

    private Vector getSQLExecutionProviders() {
        Vector<SQLExecutionProviderExtension> providers = new Vector<SQLExecutionProviderExtension>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.ui", "SQLExecutionProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    try {
                        SQLExecutionProviderExtension sepe = new SQLExecutionProviderExtension(configElements[j]);
                        providers.add(sepe);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "An error was detected when creating the SQL Execution Provider.", (Throwable)e);
                        ServerUIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return providers;
    }

    private ISQLExecutionProvider getProviderFor(Connection con, String stmt) {
        Database db = this.getDatabaseFor(con);
        if (db != null) {
            Iterator it = this.sqlExecutionProviders.iterator();
            while (it.hasNext()) {
                SQLExecutionProviderExtension sepe = (SQLExecutionProviderExtension)it.next();
                if (!sepe.vendor.equals("*") && !db.getVendor().equals(sepe.vendor) || !sepe.version.equals("*") && !db.getVersion().equals(sepe.version) || !sepe.getExecutionProvider().isProviderFor(stmt)) continue;
                return sepe.getExecutionProvider();
            }
        }
        return null;
    }

    private Database getDatabaseFor(Connection con) {
        ConnectionInfo[] conInfos = ConnectionManagerImpl.INSTANCE.getAllNamedConnectionInfo();
        int i = 0;
        while (i < conInfos.length) {
            ConnectionInfo conInfo = conInfos[i];
            if (conInfo.getSharedConnection() == con) {
                return conInfo.getSharedDatabase();
            }
            ++i;
        }
        return null;
    }

    private class SQLExecutionProviderExtension {
        ISQLExecutionProvider executionProvider;
        String vendor;
        String version;

        public SQLExecutionProviderExtension(IConfigurationElement element) throws CoreException {
            this.vendor = element.getAttribute("vendor");
            this.version = element.getAttribute("version");
            this.executionProvider = (ISQLExecutionProvider)element.createExecutableExtension("class");
        }

        public ISQLExecutionProvider getExecutionProvider() {
            return this.executionProvider;
        }
    }
}

