/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelFactory;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.AbstractModelElement;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.parser.IModelParser;
import org.eclipse.vorto.core.ui.parser.ParseModelResult;

public class InformationModelElement
extends AbstractModelElement {
    private IFile modelFile;
    private InformationModel model;
    private Collection<Resource.Diagnostic> diagnostics;
    private ModelType[] possibleReferenceTypes = new ModelType[]{ModelType.Functionblock};
    private IModelParser modelParser = null;

    public InformationModelElement(IModelProject modelProject, IFile modelFile, IModelParser modelParser) {
        super(modelProject);
        this.modelFile = modelFile;
        this.modelParser = modelParser;
        ParseModelResult<InformationModel> parseResult = modelParser.parseModelWithError(modelFile, InformationModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    @Override
    public IFile getModelFile() {
        return this.modelFile;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Collection<Resource.Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    protected String getImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/im-20x20.png";
    }

    @Override
    protected String getErrorImageURLAsString() {
        return "platform:/plugin/org.eclipse.vorto.core.ui/icons/im-error.png";
    }

    @Override
    protected ModelType[] getPossibleReferenceTypes() {
        return this.possibleReferenceTypes;
    }

    @Override
    public void addModelReference(IModelElement modelElementReference) {
        ModelReference modelReference = modelElementReference.getId().asModelReference();
        if (!this.containsModelReference(modelReference)) {
            this.getModel().getReferences().add((Object)modelReference);
            this.getModel().eResource().getContents().add((Object)modelElementReference.getModel());
        }
        InformationModel infomodel = (InformationModel)this.getModel();
        infomodel.getProperties().add((Object)this.createFunctionblockProperty((FunctionblockModel)modelElementReference.getModel(), this.getVariableNames((EList<FunctionblockProperty>)infomodel.getProperties())));
    }

    private boolean containsModelReference(ModelReference reference) {
        for (ModelReference ref : this.getModel().getReferences()) {
            if (!ref.getImportedNamespace().equals(reference.getImportedNamespace())) continue;
            return true;
        }
        return false;
    }

    private Set<String> getVariableNames(EList<FunctionblockProperty> properties) {
        HashSet<String> variableNames = new HashSet<String>();
        for (FunctionblockProperty property : properties) {
            variableNames.add(property.getName());
        }
        return variableNames;
    }

    private FunctionblockProperty createFunctionblockProperty(FunctionblockModel fbm, Set<String> existingVariableNames) {
        FunctionblockProperty fbp = InformationModelFactory.eINSTANCE.createFunctionblockProperty();
        fbp.setType(fbm);
        fbp.setName(this.generateFunctionBlockVariableName(fbm, existingVariableNames));
        return fbp;
    }

    private String generateFunctionBlockVariableName(FunctionblockModel fbm, Set<String> variableNames) {
        String variableName = fbm.getName().toLowerCase();
        int i = 0;
        while (variableNames.contains(variableName)) {
            variableName = String.valueOf(variableName) + ++i;
        }
        return variableName;
    }

    @Override
    public void reload() {
        ParseModelResult<InformationModel> parseResult = this.modelParser.parseModelWithError(this.modelFile, InformationModel.class);
        this.model = parseResult.getModel();
        this.diagnostics = parseResult.getErrors();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.modelFile == null ? 0 : this.modelFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InformationModelElement other = (InformationModelElement)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.modelFile == null ? other.modelFile != null : !this.modelFile.equals((Object)other.modelFile));
    }
}

