/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.jobs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.concurrent.future.AbstractExecutor;
import org.eclipse.equinox.concurrent.future.AbstractFuture;
import org.eclipse.equinox.concurrent.future.FutureProgressMonitor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ISafeProgressRunner;
import org.eclipse.equinox.concurrent.future.SingleOperationFuture;

public class JobsExecutor
extends AbstractExecutor {
    protected int fJobCounter = 1;
    protected String fExecutorName;
    protected boolean fSystem;
    protected ISchedulingRule fSchedulingRule;
    protected long delay;

    public JobsExecutor(String executorName) {
        this(executorName, false);
    }

    public JobsExecutor(String executorName, boolean system) {
        this(executorName, system, null);
    }

    public JobsExecutor(String executorName, boolean system, ISchedulingRule schedulingRule) {
        this(executorName, system, schedulingRule, 0L);
    }

    public JobsExecutor(String executorName, boolean system, ISchedulingRule schedulingRule, long delay) {
        this.fExecutorName = executorName;
        this.fSystem = system;
        this.fSchedulingRule = schedulingRule;
        this.delay = delay;
    }

    protected void setChildProgressMonitor(IProgressMonitor parent, IProgressMonitor child) {
        if (parent instanceof FutureProgressMonitor) {
            ((FutureProgressMonitor)parent).setChildProgressMonitor(child);
        }
    }

    protected void safeRun(ISafeProgressRunner runner, IProgressRunnable progressRunnable) {
        runner.runWithProgress(progressRunnable);
    }

    protected String createJobName(String executorName, int jobCounter, IProgressRunnable runnable) {
        return "JobsExecutor(" + executorName + ")." + jobCounter;
    }

    protected AbstractFuture createFuture(IProgressMonitor progressMonitor) {
        return new SingleOperationFuture(progressMonitor);
    }

    public IFuture execute(final IProgressRunnable runnable, IProgressMonitor clientProgressMonitor) {
        Assert.isNotNull((Object)runnable);
        final AbstractFuture sof = this.createFuture(clientProgressMonitor);
        Job job = new Job(this.createJobName(this.fExecutorName, this.fJobCounter++, runnable)){
            {
                this.setSystem(JobsExecutor.this.fSystem);
                this.setRule(JobsExecutor.this.fSchedulingRule);
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (sof.isCanceled()) {
                    return sof.getStatus();
                }
                JobsExecutor.this.setChildProgressMonitor(sof.getProgressMonitor(), monitor);
                JobsExecutor.this.safeRun((ISafeProgressRunner)sof, runnable);
                return sof.getStatus();
            }
        };
        this.configureJobForExecution(job);
        job.schedule(this.delay);
        return sof;
    }

    protected void configureJobForExecution(Job job) {
    }
}

