/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class ChunkedInputFilter
implements InputFilter {
    private static final StringManager sm = StringManager.getManager((String)ChunkedInputFilter.class.getPackage().getName());
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected int pos = 0;
    protected int lastValid = 0;
    protected byte[] buf = null;
    protected ByteChunk readChunk = new ByteChunk();
    protected boolean endChunk = false;
    protected ByteChunk trailingHeaders = new ByteChunk();
    protected boolean needCRLFParse = false;
    private Request request;
    private final long maxExtensionSize;
    private final int maxTrailerSize;
    private long extensionSize;
    private final int maxSwallowSize;
    private boolean error;
    private final Set<String> allowedTrailerHeaders;

    public ChunkedInputFilter(int maxTrailerSize, Set<String> allowedTrailerHeaders, int maxExtensionSize, int maxSwallowSize) {
        this.trailingHeaders.setLimit(maxTrailerSize);
        this.allowedTrailerHeaders = allowedTrailerHeaders;
        this.maxExtensionSize = maxExtensionSize;
        this.maxTrailerSize = maxTrailerSize;
        this.maxSwallowSize = maxSwallowSize;
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.endChunk) {
            return -1;
        }
        this.checkError();
        if (this.needCRLFParse) {
            this.needCRLFParse = false;
            this.parseCRLF(false);
        }
        if (this.remaining <= 0) {
            if (!this.parseChunkHeader()) {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidHeader"));
            }
            if (this.endChunk) {
                this.parseEndChunk();
                return -1;
            }
        }
        int result = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            this.throwIOException(sm.getString("chunkedInputFilter.eos"));
        }
        if (this.remaining > this.lastValid - this.pos) {
            result = this.lastValid - this.pos;
            this.remaining -= result;
            chunk.setBytes(this.buf, this.pos, result);
            this.pos = this.lastValid;
        } else {
            result = this.remaining;
            chunk.setBytes(this.buf, this.pos, this.remaining);
            this.pos += this.remaining;
            this.remaining = 0;
            if (this.pos + 1 >= this.lastValid) {
                this.needCRLFParse = true;
            } else {
                this.parseCRLF(false);
            }
        }
        return result;
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public long end() throws IOException {
        long swallowed = 0L;
        int read = 0;
        while ((read = this.doRead(this.readChunk, null)) >= 0) {
            if (this.maxSwallowSize <= -1 || (swallowed += (long)read) <= (long)this.maxSwallowSize) continue;
            this.throwIOException(sm.getString("inputFilter.maxSwallow"));
        }
        return this.lastValid - this.pos;
    }

    @Override
    public int available() {
        return this.lastValid - this.pos;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        this.pos = 0;
        this.lastValid = 0;
        this.endChunk = false;
        this.needCRLFParse = false;
        this.trailingHeaders.recycle();
        this.trailingHeaders.setLimit(this.maxTrailerSize);
        this.extensionSize = 0L;
        this.error = false;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    protected int readBytes() throws IOException {
        int nRead = this.buffer.doRead(this.readChunk, null);
        this.pos = this.readChunk.getStart();
        this.lastValid = this.pos + nRead;
        this.buf = this.readChunk.getBytes();
        return nRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseChunkHeader() throws IOException {
        int result = 0;
        boolean eol = false;
        int readDigit = 0;
        boolean extension = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                return false;
            }
            if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                this.parseCRLF(false);
                eol = true;
            } else if (this.buf[this.pos] == 59 && !extension) {
                extension = true;
                ++this.extensionSize;
            } else if (!extension) {
                int charValue = HexUtils.getDec(this.buf[this.pos]);
                if (charValue == -1 || readDigit >= 8) return false;
                ++readDigit;
                result = result << 4 | charValue;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    this.throwIOException(sm.getString("chunkedInputFilter.maxExtension"));
                }
            }
            if (eol) continue;
            ++this.pos;
        }
        if (readDigit == 0 || result < 0) {
            return false;
        }
        if (result == 0) {
            this.endChunk = true;
        }
        this.remaining = result;
        return this.remaining >= 0;
    }

    @Deprecated
    protected boolean parseCRLF() throws IOException {
        this.parseCRLF(false);
        return true;
    }

    protected void parseCRLF(boolean tolerant) throws IOException {
        boolean eol = false;
        boolean crfound = false;
        while (!eol) {
            if (this.pos >= this.lastValid && this.readBytes() <= 0) {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfNoData"));
            }
            if (this.buf[this.pos] == 13) {
                if (crfound) {
                    this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfCRCR"));
                }
                crfound = true;
            } else if (this.buf[this.pos] == 10) {
                if (!tolerant && !crfound) {
                    this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlfNoCR"));
                }
                eol = true;
            } else {
                this.throwIOException(sm.getString("chunkedInputFilter.invalidCrlf"));
            }
            ++this.pos;
        }
    }

    protected void parseEndChunk() throws IOException {
        while (this.parseHeader()) {
        }
    }

    private boolean parseHeader() throws IOException {
        MimeHeaders headers = this.request.getMimeHeaders();
        byte chr = 0;
        if (this.pos >= this.lastValid && this.readBytes() < 0) {
            this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
        }
        if ((chr = this.buf[this.pos]) == 13 || chr == 10) {
            this.parseCRLF(false);
            return false;
        }
        int startPos = this.trailingHeaders.getEnd();
        boolean colon = false;
        while (!colon) {
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((chr = this.buf[this.pos]) >= 65 && chr <= 90) {
                chr = (byte)(chr - -32);
            }
            if (chr == 58) {
                colon = true;
            } else {
                this.trailingHeaders.append(chr);
            }
            ++this.pos;
        }
        int colonPos = this.trailingHeaders.getEnd();
        boolean eol = false;
        boolean validLine = true;
        int lastSignificantChar = 0;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((chr = this.buf[this.pos]) == 32 || chr == 9) {
                    ++this.pos;
                    int newlimit = this.trailingHeaders.getLimit() - 1;
                    if (this.trailingHeaders.getEnd() > newlimit) {
                        this.throwIOException(sm.getString("chunkedInputFilter.maxTrailer"));
                    }
                    this.trailingHeaders.setLimit(newlimit);
                    continue;
                }
                space = false;
            }
            while (!eol) {
                if (this.pos >= this.lastValid && this.readBytes() < 0) {
                    this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
                }
                if ((chr = this.buf[this.pos]) == 13 || chr == 10) {
                    this.parseCRLF(true);
                    eol = true;
                } else if (chr == 32) {
                    this.trailingHeaders.append(chr);
                } else {
                    this.trailingHeaders.append(chr);
                    lastSignificantChar = this.trailingHeaders.getEnd();
                }
                if (eol) continue;
                ++this.pos;
            }
            if (this.pos >= this.lastValid && this.readBytes() < 0) {
                this.throwEOFException(sm.getString("chunkedInputFilter.eosTrailer"));
            }
            if ((chr = this.buf[this.pos]) != 32 && chr != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.trailingHeaders.append(chr);
        }
        String headerName = new String(this.trailingHeaders.getBytes(), startPos, colonPos - startPos, "ISO_8859_1");
        if (this.allowedTrailerHeaders.contains(headerName.trim().toLowerCase(Locale.ENGLISH))) {
            MessageBytes headerValue = headers.addValue(headerName);
            headerValue.setBytes(this.trailingHeaders.getBytes(), colonPos, lastSignificantChar - colonPos);
        }
        return true;
    }

    private void throwIOException(String msg) throws IOException {
        this.error = true;
        throw new IOException(msg);
    }

    private void throwEOFException(String msg) throws IOException {
        this.error = true;
        throw new EOFException(msg);
    }

    private void checkError() throws IOException {
        if (this.error) {
            throw new IOException(sm.getString("chunkedInputFilter.error"));
        }
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(Charset.defaultCharset()), 0, ENCODING_NAME.length());
    }
}

