/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import org.apache.openejb.core.timer.EJBCronTrigger;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerType;
import org.quartz.impl.triggers.AbstractTrigger;

public class CalendarTimerData
extends TimerData {
    private static final long serialVersionUID = 1L;
    private final ScheduleExpression scheduleExpression;

    public CalendarTimerData(long id, EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, TimerConfig timerConfig, ScheduleExpression scheduleExpression) {
        super(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig);
        this.scheduleExpression = scheduleExpression;
    }

    @Override
    public TimerType getType() {
        return TimerType.Calendar;
    }

    public ScheduleExpression getSchedule() {
        return this.scheduleExpression;
    }

    @Override
    public AbstractTrigger<?> initializeTrigger() {
        try {
            return new EJBCronTrigger(this.scheduleExpression);
        }
        catch (EJBCronTrigger.ParseException e) {
            throw new IllegalArgumentException("Fail to parse schedule expression " + this.scheduleExpression, e);
        }
    }

    public String toString() {
        return TimerType.Calendar.name() + " scheduleExpression = [" + this.scheduleExpression + "]";
    }
}

