/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.decorator.Delegate;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.webbeans.annotation.NamedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.impl.InjectionPointImpl;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointFactory {
    private final WebBeansContext webBeansContext;

    public InjectionPointFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public InjectionPoint getFieldInjectionPointData(Bean<?> owner, Field member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        Annotation[] annots = null;
        annots = member.getAnnotations();
        AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
        AnnotatedType<?> annotated = annotatedElementFactory.newAnnotatedType(member.getDeclaringClass());
        return this.getGenericInjectionPoint(owner, annots, member.getGenericType(), member, (Annotated)annotatedElementFactory.newAnnotatedField(member, annotated));
    }

    public <X> InjectionPoint getFieldInjectionPointData(Bean<?> owner, AnnotatedField<X> annotField) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(annotField, "annotField parameter can not be null");
        Field member = annotField.getJavaMember();
        Annotation[] annots = AnnotationUtil.getAnnotationsFromSet(annotField.getAnnotations());
        return this.getGenericInjectionPoint(owner, annots, annotField.getBaseType(), member, (Annotated)annotField);
    }

    private InjectionPoint getGenericInjectionPoint(Bean<?> owner, Annotation[] annots, Type type, Member member, Annotated annotated) {
        Annotation[] qualifierAnnots = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(annots);
        if (member instanceof Field) {
            for (int i = 0; i < qualifierAnnots.length; ++i) {
                Annotation qualifier = qualifierAnnots[i];
                if (!qualifier.annotationType().equals(Named.class)) continue;
                Named named = (Named)qualifier;
                String value = named.value();
                if (value != null && !value.equals("")) break;
                NamedLiteral namedLiteral = new NamedLiteral();
                namedLiteral.setValue(member.getName());
                qualifierAnnots[i] = namedLiteral;
                break;
            }
        }
        InjectionPointImpl injectionPoint = new InjectionPointImpl(owner, type, member, annotated);
        if (AnnotationUtil.hasAnnotation(annots, Delegate.class)) {
            injectionPoint.setDelegate(true);
        }
        if (Modifier.isTransient(member.getModifiers())) {
            injectionPoint.setTransient(true);
        }
        InjectionPointFactory.addAnnotation(injectionPoint, qualifierAnnots, true);
        return injectionPoint;
    }

    public List<InjectionPoint> getMethodInjectionPointData(Bean<?> owner, Method member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
        AnnotatedType<?> annotated = annotatedElementFactory.newAnnotatedType(member.getDeclaringClass());
        AnnotatedMethod<?> method = annotatedElementFactory.newAnnotatedMethod(member, annotated);
        List parameters = method.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.getAnnotation(Observes.class) != null) continue;
            point = this.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), member, (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    public <X> List<InjectionPoint> getMethodInjectionPointData(Bean<?> owner, AnnotatedMethod<X> method) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        List parameters = method.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.getAnnotation(Observes.class) != null) continue;
            point = this.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), method.getJavaMember(), (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    public static InjectionPoint getPartialInjectionPoint(Bean<?> owner, Type type, Member member, Annotated annotated, Annotation ... bindings) {
        InjectionPointImpl impl = new InjectionPointImpl(owner, type, member, annotated);
        for (Annotation annot : bindings) {
            impl.addBindingAnnotation(annot);
        }
        return impl;
    }

    public <T> List<InjectionPoint> getConstructorInjectionPointData(Bean<T> owner, AnnotatedConstructor<T> constructor) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(constructor, "constructor parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        List parameters = constructor.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            point = this.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), constructor.getJavaMember(), (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    public List<InjectionPoint> getConstructorInjectionPointData(Bean<?> owner, Constructor<?> member) {
        Asserts.assertNotNull(owner, "owner parameter can not be null");
        Asserts.assertNotNull(member, "member parameter can not be null");
        ArrayList<InjectionPoint> lists = new ArrayList<InjectionPoint>();
        AnnotatedType<?> annotated = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(member.getDeclaringClass());
        AnnotatedConstructor<?> constructor = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedConstructor(member, annotated);
        List parameters = constructor.getParameters();
        InjectionPoint point = null;
        for (AnnotatedParameter parameter : parameters) {
            point = this.getGenericInjectionPoint(owner, parameter.getAnnotations().toArray(new Annotation[parameter.getAnnotations().size()]), parameter.getBaseType(), member, (Annotated)parameter);
            lists.add(point);
        }
        return lists;
    }

    private static void addAnnotation(InjectionPointImpl impl, Annotation[] annots, boolean isBinding) {
        for (Annotation ann : annots) {
            if (!isBinding) continue;
            impl.addBindingAnnotation(ann);
        }
    }
}

