/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class ReferenceResolver {
    public static final String KEY = "REFERENCE_RESOLVER";
    private ArrayList<Reference> references = new ArrayList();
    private ReferenceKey lookupKey = new ReferenceKey(null, null);

    public static ReferenceResolver getInstance(Session unitOfWork) {
        if (unitOfWork == null) {
            return null;
        }
        return (ReferenceResolver)unitOfWork.getProperty(KEY);
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    private void createPKVectorsFromMap(Reference reference, XMLCollectionReferenceMapping mapping) {
        ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
        Vector<CacheId> pks = new Vector<CacheId>();
        if (referenceDescriptor == null) {
            CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(null);
            if (pkVals == null) {
                return;
            }
            int x = 0;
            while (x < pkVals.getPrimaryKey().length) {
                Object[] values = new Object[]{pkVals.getPrimaryKey()[x]};
                pks.add(new CacheId(values));
                ++x;
            }
        } else {
            Vector<String> pkFields = referenceDescriptor.getPrimaryKeyFieldNames();
            if (pkFields.isEmpty()) {
                return;
            }
            boolean init = true;
            Iterator<String> pkFieldNameIt = pkFields.iterator();
            while (pkFieldNameIt.hasNext()) {
                int i;
                CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(pkFieldNameIt.next());
                if (pkVals == null) {
                    return;
                }
                if (init) {
                    i = 0;
                    while (i < pkVals.getPrimaryKey().length) {
                        pks.add(new CacheId(new Object[0]));
                        ++i;
                    }
                    init = false;
                }
                i = 0;
                while (i < pkVals.getPrimaryKey().length) {
                    Object val = pkVals.getPrimaryKey()[i];
                    ((CacheId)pks.get(i)).add(val);
                    ++i;
                }
            }
        }
        reference.setPrimaryKey(pks);
    }

    public Reference getReference(XMLObjectReferenceMapping mapping, Object sourceObject) {
        int x = 0;
        while (x < this.references.size()) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() == mapping && reference.getSourceObject() == sourceObject) {
                return reference;
            }
            ++x;
        }
        return null;
    }

    public Reference getReference(XMLObjectReferenceMapping mapping, Object sourceObject, XMLField xmlField) {
        XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(xmlField);
        String tgtXpath = null;
        if (mapping.getReferenceClass() != null && mapping.getReferenceClass() != Object.class && targetField != null) {
            tgtXpath = targetField.getXPath();
        }
        int x = 0;
        while (x < this.references.size()) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() == mapping && reference.getSourceObject() == sourceObject && reference.getPrimaryKeyMap().get(tgtXpath) == null) {
                return reference;
            }
            ++x;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void resolveReferences(AbstractSession session, IDResolver userSpecifiedResolver) {
        x = 0;
        referencesSize = this.references.size();
        while (x < referencesSize) {
            reference = this.references.get(x);
            referenceSourceObject = reference.getSourceObject();
            if (reference.getMapping() instanceof XMLCollectionReferenceMapping) {
                mapping = (XMLCollectionReferenceMapping)reference.getMapping();
                cPolicy = mapping.getContainerPolicy();
                container = reference.getContainer();
                this.createPKVectorsFromMap(reference, mapping);
                if (reference.getPrimaryKey() != null) {
                    value = null;
                    if (!mapping.isWriteOnly()) {
                        for (CacheId primaryKey : (Vector)reference.getPrimaryKey()) {
                            value = this.getValue(session, reference, primaryKey);
                            if (value == null) continue;
                            cPolicy.addInto(value, container, session);
                        }
                    }
                    mapping.setAttributeValueInObject(referenceSourceObject, container);
                    inverseReferenceMapping = mapping.getInverseReferenceMapping();
                    if (inverseReferenceMapping != null && value != null) {
                        backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                        backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                        if (backpointerContainerPolicy == null) {
                            backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                        } else {
                            backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                            if (backpointerContainer == null) {
                                backpointerContainer = backpointerContainerPolicy.containerInstance();
                                backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                            }
                            backpointerContainerPolicy.addInto(referenceSourceObject, backpointerContainer, session);
                        }
                    }
                }
            } else if (reference.getMapping() instanceof XMLObjectReferenceMapping) {
                primaryKey = (CacheId)reference.getPrimaryKey();
                value = null;
                if (userSpecifiedResolver != null) {
                    try {
                        if (primaryKey.getPrimaryKey().length > 1) {
                            idWrapper = new HashMap<String, Object>();
                            y = 0;
                            while (y < primaryKey.getPrimaryKey().length) {
                                refMapping = (XMLObjectReferenceMapping)reference.getMapping();
                                idName = refMapping.getReferenceDescriptor().getPrimaryKeyFieldNames().elementAt(y);
                                idValue = primaryKey.getPrimaryKey()[y];
                                idWrapper.put(idName, idValue);
                                ++y;
                            }
                            c = userSpecifiedResolver.resolve(idWrapper, reference.getTargetClass());
                        } else {
                            c = userSpecifiedResolver.resolve(primaryKey.getPrimaryKey()[0], reference.getTargetClass());
                        }
                        if (c == null) ** GOTO lbl60
                        value = c.call();
                    }
                    catch (Exception e) {
                        throw XMLMarshalException.unmarshalException(e);
                    }
                } else {
                    value = this.getValue(session, reference, primaryKey);
                }
lbl60:
                // 3 sources

                mapping = (XMLObjectReferenceMapping)reference.getMapping();
                if (value != null) {
                    mapping.setAttributeValueInObject(reference.getSourceObject(), value);
                }
                if (reference.getSetting() != null) {
                    reference.getSetting().setValue(value);
                }
                if ((inverseReferenceMapping = mapping.getInverseReferenceMapping()) != null) {
                    backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                    backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                    if (backpointerContainerPolicy == null) {
                        backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                    } else {
                        backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                        if (backpointerContainer == null) {
                            backpointerContainer = backpointerContainerPolicy.containerInstance();
                            backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                        }
                        backpointerContainerPolicy.addInto(reference.getSourceObject(), backpointerContainer, session);
                    }
                }
            }
            ++x;
        }
        if (session.isUnitOfWork()) {
            ((UnitOfWork)session).release();
        }
        this.references = new ArrayList<E>();
    }

    private Object getValue(AbstractSession session, Reference reference, CacheId primaryKey) {
        Class referenceTargetClass = reference.getTargetClass();
        if (referenceTargetClass == null || referenceTargetClass == ClassConstants.OBJECT) {
            for (ClassDescriptor entry : session.getDescriptors().values()) {
                Object value = null;
                XMLDescriptor targetDescriptor = (XMLDescriptor)entry;
                List<DatabaseField> pkFields = targetDescriptor.getPrimaryKeyFields();
                if (pkFields == null || 1 != pkFields.size()) continue;
                XMLField pkField = (XMLField)pkFields.get(0);
                Class targetType = (pkField = (XMLField)targetDescriptor.getTypedField(pkField)).getType();
                if (targetType == ClassConstants.STRING || targetType == ClassConstants.OBJECT) {
                    value = session.getIdentityMapAccessor().getFromIdentityMap(primaryKey, targetDescriptor.getJavaClass());
                } else {
                    try {
                        Object[] pkValues = primaryKey.getPrimaryKey();
                        Object[] convertedPkValues = new Object[pkValues.length];
                        int x = 0;
                        while (x < pkValues.length) {
                            convertedPkValues[x] = session.getDatasourcePlatform().getConversionManager().convertObject(pkValues[x], targetType);
                            ++x;
                        }
                        value = session.getIdentityMapAccessor().getFromIdentityMap(new CacheId(convertedPkValues), targetDescriptor.getJavaClass());
                    }
                    catch (ConversionException conversionException) {}
                }
                if (value == null) continue;
                return value;
            }
            return null;
        }
        return session.getIdentityMapAccessor().getFromIdentityMap(primaryKey, referenceTargetClass);
    }

    private class ReferenceKey {
        private Object sourceObject;
        private XMLMapping mapping;

        public ReferenceKey(Object sourceObject, XMLMapping mapping) {
            this.sourceObject = sourceObject;
            this.mapping = mapping;
        }

        public Object getSourceObject() {
            return this.sourceObject;
        }

        public XMLMapping getMapping() {
            return this.mapping;
        }

        public void setSourceObject(Object obj) {
            this.sourceObject = obj;
        }

        public void setMapping(XMLMapping mapping) {
            this.mapping = mapping;
        }

        public int hashCode() {
            return this.mapping.hashCode() ^ this.sourceObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ReferenceKey key = (ReferenceKey)obj;
            return this.sourceObject == key.getSourceObject() && this.mapping == key.getMapping();
        }
    }
}

