/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile
extends File
implements StorageFile {
    DirFile(String string) {
        super(string);
    }

    DirFile(String string, String string2) {
        super(string, string2);
    }

    DirFile(DirFile dirFile, String string) {
        super(dirFile, string);
    }

    public StorageFile getParentDir() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new DirFile(string);
    }

    static StorageFile getTempDir() throws IOException {
        File file = File.createTempFile("derby", "tmp");
        DirFile dirFile = new DirFile(file.getParent());
        file.delete();
        return dirFile;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this);
    }

    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        return new FileOutputStream(this.getPath(), bl);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    public synchronized int getExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this, "rw");
            randomAccessFile.getFD().sync();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public synchronized void releaseExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        if ("rws".equals(string) || "rwd".equals(string)) {
            string = "rw";
        }
        return new DirRandomAccessFile(this, string);
    }

    public boolean renameTo(StorageFile storageFile) {
        return super.renameTo((File)((Object)storageFile));
    }

    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            String[] stringArray = super.list();
            String string = this.getPath();
            for (int i = 0; i < stringArray.length; ++i) {
                DirFile dirFile;
                if (stringArray[i].equals(".") || stringArray[i].equals("..") || (dirFile = new DirFile(string, stringArray[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    public URL getURL() throws MalformedURLException {
        return this.toURL();
    }
}

