/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public class DynamicByteArrayOutputStream
extends OutputStream {
    private static int INITIAL_SIZE = 4096;
    private byte[] buf;
    private int position;
    private int used;
    private int beginPosition;

    public DynamicByteArrayOutputStream() {
        this(INITIAL_SIZE);
    }

    public DynamicByteArrayOutputStream(int n) {
        this.buf = new byte[n];
    }

    public DynamicByteArrayOutputStream(byte[] byArray) {
        this.buf = byArray;
    }

    public DynamicByteArrayOutputStream(DynamicByteArrayOutputStream dynamicByteArrayOutputStream) {
        byte[] byArray = dynamicByteArrayOutputStream.getByteArray();
        this.buf = new byte[byArray.length];
        this.write(byArray, 0, byArray.length);
        this.position = dynamicByteArrayOutputStream.getPosition();
        this.used = dynamicByteArrayOutputStream.getUsed();
        this.beginPosition = dynamicByteArrayOutputStream.getBeginPosition();
    }

    public void write(int n) {
        if (this.position >= this.buf.length) {
            this.expandBuffer(INITIAL_SIZE);
        }
        this.buf[this.position++] = (byte)n;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.position + n2 > this.buf.length) {
            this.expandBuffer(n2);
        }
        System.arraycopy(byArray, n, this.buf, this.position, n2);
        this.position += n2;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    void writeCompleteStream(InputStream inputStream, int n) throws IOException {
        if (this.position + n > this.buf.length) {
            this.expandBuffer(n);
        }
        InputStreamUtil.readFully(inputStream, this.buf, this.position, n);
        this.position += n;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    public void close() {
        this.buf = null;
        this.reset();
    }

    public void reset() {
        this.position = 0;
        this.beginPosition = 0;
        this.used = 0;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public int getUsed() {
        return this.used;
    }

    public int getPosition() {
        return this.position;
    }

    public int getBeginPosition() {
        return this.beginPosition;
    }

    public void setPosition(int n) {
        if (n > this.position && n > this.buf.length) {
            this.expandBuffer(n - this.buf.length);
        }
        this.position = n;
        if (this.position > this.used) {
            this.used = this.position;
        }
    }

    public void setBeginPosition(int n) {
        if (n > this.buf.length) {
            return;
        }
        this.beginPosition = n;
    }

    public void discardLeft(int n) {
        System.arraycopy(this.buf, n, this.buf, 0, this.used - n);
        this.position -= n;
        this.used -= n;
    }

    private void expandBuffer(int n) {
        if (this.buf.length < 131072) {
            if (n < INITIAL_SIZE) {
                n = INITIAL_SIZE;
            }
        } else if (this.buf.length < 0x100000) {
            if (n < 131072) {
                n = 131072;
            }
        } else if (n < 0x100000) {
            n = 0x100000;
        }
        int n2 = this.buf.length + n;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
        this.buf = byArray;
    }
}

