/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.se;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.bytecode.ClassFile;
import org.apache.webbeans.corespi.scanner.AnnotationDB;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.ClassUtil;

public class BeansXmlAnnotationDB
extends AnnotationDB {
    private static final long serialVersionUID = 4321069777044090278L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(BeansXmlAnnotationDB.class);
    private String beansXml;
    private ScannerService scannerService;
    Map<String, String> beansXmlResources = new HashMap<String, String>();

    public void setBdaBeansXmlScanner(ScannerService scannerService) {
        this.scannerService = scannerService;
    }

    public void setCurrentBeansXml(String beansXml) {
        this.beansXml = beansXml;
    }

    protected void scanClass(ClassFile cf) {
        super.scanClass(cf);
        if (this.beansXml != null && this.scannerService.isBDABeansXmlScanningEnabled()) {
            this.scannerService.getBDABeansXmlScanner().setBeansXml(ClassUtil.getClassFromName(cf.getName()), this.beansXml);
        }
    }

    public void scanArchives(String ... urls) throws IOException {
        this.scanArchivesBeansXml(urls);
    }

    public void setResourceBeansXml(String resource, String beansXml) {
        if (logger.isLoggable(Level.FINE)) {
            logger.info("resource=" + resource + ", beansXml=" + beansXml);
        }
        this.beansXmlResources.put(resource, beansXml);
    }

    private void scanArchivesBeansXml(String ... urls) throws IOException {
        this.populateResourceToBeansXml(urls);
        for (int i = 0; i < urls.length; ++i) {
            String currentBeansXml = this.beansXmlResources.get(urls[i]);
            if (currentBeansXml == null) {
                throw new IllegalStateException("Could not locate beans.xml for resource: " + urls[i]);
            }
            this.setCurrentBeansXml(currentBeansXml);
            super.scanArchives(urls[i]);
        }
        this.setCurrentBeansXml(null);
    }

    private void populateResourceToBeansXml(String[] resourceURLs) throws IOException {
        Iterator it = this.scannerService.getBeanXmls().iterator();
        while (it.hasNext()) {
            boolean isMatchFound = false;
            String beanXmlUrl = ((URL)it.next()).toExternalForm();
            if (this.beansXmlResources.containsValue(beanXmlUrl)) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("beans.xml mapping already set: " + beanXmlUrl);
                continue;
            }
            for (int i = 0; !isMatchFound && i < resourceURLs.length; ++i) {
                if (!beanXmlUrl.startsWith(resourceURLs[i])) continue;
                this.beansXmlResources.put(resourceURLs[i], beanXmlUrl);
                isMatchFound = true;
            }
            if (isMatchFound) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Could not find resource URL to match beans.xml: ");
            sb.append(beanXmlUrl);
            sb.append(", available resource URLs=");
            for (int i = 0; i < resourceURLs.length; ++i) {
                sb.append(resourceURLs[i]).append(", ");
            }
            throw new IOException(sb.toString());
        }
    }
}

