/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public final class TimeWatcherExecutor {
    private TimeWatcherExecutor() {
    }

    public static TimerWatcherResult execute(Method mtd, Object instance, Object[] args, boolean watch) throws Throwable {
        Object result;
        long start = 0L;
        long duration = 0L;
        if (watch) {
            start = System.nanoTime();
        }
        try {
            result = mtd.invoke(instance, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        if (watch) {
            duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        }
        return new TimerWatcherResult(duration, result);
    }

    public static class TimerWatcherResult {
        private final Object result;
        private final long duration;

        public TimerWatcherResult(long duration, Object result) {
            this.duration = duration;
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

