/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.interceptor.AroundInvoke;
import javax.xml.ws.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Pool;
import org.apache.xbean.finder.ClassFinder;

public class StatelessContainer
implements RpcContainer {
    private final ConcurrentMap<Class<?>, List<Method>> interceptorCache = new ConcurrentHashMap();
    private StatelessInstanceManager instanceManager;
    private HashMap<String, BeanContext> deploymentRegistry = new HashMap();
    private Object containerID = null;
    private SecurityService securityService;

    public StatelessContainer(Object id, SecurityService securityService, Duration accessTimeout, Duration closeTimeout, Pool.Builder poolBuilder, int callbackThreads) {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new StatelessInstanceManager(securityService, accessTimeout, closeTimeout, poolBuilder, callbackThreads);
        for (BeanContext beanContext : this.deploymentRegistry.values()) {
            beanContext.setContainer(this);
        }
    }

    @Override
    public synchronized BeanContext[] getBeanContexts() {
        return this.deploymentRegistry.values().toArray(new BeanContext[this.deploymentRegistry.size()]);
    }

    @Override
    public synchronized BeanContext getBeanContext(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.STATELESS;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        EjbTimerService timerService;
        String id = (String)beanContext.getDeploymentID();
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            this.deploymentRegistry.put(id, beanContext);
            beanContext.setContainer(this);
        }
        if (StatsInterceptor.isStatsActivated()) {
            StatsInterceptor stats = new StatsInterceptor(beanContext.getBeanClass());
            beanContext.addFirstSystemInterceptor(stats);
        }
        if ((timerService = beanContext.getEjbTimerService()) != null) {
            timerService.start();
        }
    }

    @Override
    public void start(BeanContext beanContext) throws OpenEJBException {
        this.instanceManager.deploy(beanContext);
    }

    @Override
    public void stop(BeanContext beanContext) throws OpenEJBException {
        beanContext.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) {
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        this.instanceManager.undeploy(beanContext);
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            String id = (String)beanContext.getDeploymentID();
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    @Override
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    @Override
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Object object;
        ThreadContext oldCallContext;
        block20: {
            Object bean;
            ThreadContext callContext;
            block21: {
                Object retValue;
                Method runMethod;
                block17: {
                    Object var14_16;
                    block18: {
                        block19: {
                            Class<?> declaringClass;
                            block11: {
                                Object var14_15;
                                block15: {
                                    block16: {
                                        block12: {
                                            ProxyInfo proxyInfo;
                                            block13: {
                                                block14: {
                                                    BeanContext beanContext = this.getBeanContext(deployID);
                                                    if (beanContext == null) {
                                                        throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                                                    }
                                                    if (type == null) {
                                                        type = beanContext.getInterfaceType(callInterface);
                                                    }
                                                    runMethod = beanContext.getMatchingBeanMethod(callMethod);
                                                    callContext = new ThreadContext(beanContext, primKey);
                                                    oldCallContext = ThreadContext.enter(callContext);
                                                    bean = null;
                                                    try {
                                                        boolean authorized;
                                                        boolean bl = authorized = type == InterfaceType.TIMEOUT || this.getSecurityService().isCallerAuthorized(callMethod, type);
                                                        if (!authorized) {
                                                            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                                                        }
                                                        declaringClass = callMethod.getDeclaringClass();
                                                        if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block11;
                                                        if (!callMethod.getName().startsWith("create")) break block12;
                                                        proxyInfo = this.createEJBObject(beanContext, callMethod);
                                                        if (bean == null) break block13;
                                                        if (!callContext.isDiscardInstance()) break block14;
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (bean != null) {
                                                            if (callContext.isDiscardInstance()) {
                                                                this.instanceManager.discardInstance(callContext, bean);
                                                            } else {
                                                                this.instanceManager.poolInstance(callContext, bean);
                                                            }
                                                        }
                                                        ThreadContext.exit(oldCallContext);
                                                        throw throwable;
                                                    }
                                                    this.instanceManager.discardInstance(callContext, bean);
                                                    break block13;
                                                }
                                                this.instanceManager.poolInstance(callContext, bean);
                                            }
                                            ThreadContext.exit(oldCallContext);
                                            return proxyInfo;
                                        }
                                        var14_15 = null;
                                        if (bean == null) break block15;
                                        if (!callContext.isDiscardInstance()) break block16;
                                        this.instanceManager.discardInstance(callContext, bean);
                                        break block15;
                                    }
                                    this.instanceManager.poolInstance(callContext, bean);
                                }
                                ThreadContext.exit(oldCallContext);
                                return var14_15;
                            }
                            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass) break block17;
                            var14_16 = null;
                            if (bean == null) break block18;
                            if (!callContext.isDiscardInstance()) break block19;
                            this.instanceManager.discardInstance(callContext, bean);
                            break block18;
                        }
                        this.instanceManager.poolInstance(callContext, bean);
                    }
                    ThreadContext.exit(oldCallContext);
                    return var14_16;
                }
                bean = this.instanceManager.getInstance(callContext);
                callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
                callContext.set(Method.class, runMethod);
                callContext.setInvokedInterface(callInterface);
                object = retValue = this._invoke(callMethod, runMethod, args, (Instance)bean, callContext, type);
                if (bean == null) break block20;
                if (!callContext.isDiscardInstance()) break block21;
                this.instanceManager.discardInstance(callContext, bean);
                break block20;
            }
            this.instanceManager.poolInstance(callContext, bean);
        }
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    public StatelessInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    protected Object _invoke(Class callInterface, Method callMethod, Method runMethod, Object[] args, Object object, ThreadContext callContext) throws OpenEJBException {
        return this._invoke(callMethod, runMethod, args, (Instance)object, callContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _invoke(Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext, InterfaceType type) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, type), callContext);
        Object returnValue = null;
        try {
            if (type == InterfaceType.SERVICE_ENDPOINT) {
                callContext.setCurrentOperation(Operation.BUSINESS_WS);
                returnValue = this.invokeWebService(args, beanContext, runMethod, instance, returnValue);
            } else {
                List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, instance.interceptors);
                returnValue = interceptorStack.invoke(args);
            }
        }
        catch (Throwable re) {
            ExceptionType exceptionType = beanContext.getExceptionType(re);
            if (exceptionType == ExceptionType.SYSTEM) {
                callContext.setDiscardInstance(true);
                EjbTransactionUtil.handleSystemException(txPolicy, re, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, re, exceptionType == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            try {
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            }
            catch (SystemException e) {
                callContext.setDiscardInstance(true);
                throw e;
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                callContext.setDiscardInstance(true);
                throw e;
            }
        }
        return returnValue;
    }

    private Object invokeWebService(Object[] args, BeanContext beanContext, Method runMethod, Instance instance, Object returnValue) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        Object interceptor = args[1];
        Class<?> interceptorClass = interceptor.getClass();
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptor.getClass().getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>();
        InterceptorData providerData = new InterceptorData(interceptorClass);
        List<Method> aroundInvokes = (List<Method>)this.interceptorCache.get(interceptorClass);
        if (aroundInvokes == null) {
            aroundInvokes = new ClassFinder(new Class[]{interceptorClass}).findAnnotatedMethods(AroundInvoke.class);
            if (StatelessContainer.class.getClassLoader() == interceptorClass.getClassLoader()) {
                CopyOnWriteArrayList<Method> value = new CopyOnWriteArrayList<Method>(aroundInvokes);
                if ((aroundInvokes = this.interceptorCache.putIfAbsent(interceptorClass, aroundInvokes)) == null) {
                    aroundInvokes = value;
                }
            }
        }
        providerData.getAroundInvoke().addAll((Collection<Method>)aroundInvokes);
        interceptorDatas.add(0, providerData);
        interceptorDatas.addAll(beanContext.getMethodInterceptors(runMethod));
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof javax.xml.rpc.handler.MessageContext) {
            ThreadContext.getThreadContext().set(javax.xml.rpc.handler.MessageContext.class, (javax.xml.rpc.handler.MessageContext)messageContext);
            returnValue = interceptorStack.invoke((javax.xml.rpc.handler.MessageContext)messageContext, params);
        } else if (messageContext instanceof MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            returnValue = interceptorStack.invoke((MessageContext)messageContext, params);
        }
        return returnValue;
    }

    protected ProxyInfo createEJBObject(BeanContext beanContext, Method callMethod) {
        return new ProxyInfo(beanContext, null);
    }
}

