/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateExtractor
implements Extractor {
    @Override
    public Class getType() {
        return Date.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        if (!jsonify) {
            return pValue;
        }
        Date date = (Date)pValue;
        if (!pExtraArgs.isEmpty()) {
            String attribute = pExtraArgs.pop();
            if (!"time".equals(attribute)) {
                throw new IllegalArgumentException("A date accepts only a single inner path element of value 'time' (and not '" + attribute + "'");
            }
            return date.getTime();
        }
        return DateUtil.toISO8601(date);
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Date date = (Date)pInner;
        if ("time".equals(pAttribute)) {
            long oldValue = date.getTime();
            long time = pValue instanceof String ? Long.parseLong((String)pValue) : (Long)pValue;
            date.setTime(time);
            return oldValue;
        }
        if ("iso8601".equals(pAttribute)) {
            Date newDate = DateUtil.fromISO8601(pValue.toString());
            String oldValue = DateUtil.toISO8601(date);
            date.setTime(newDate.getTime());
            return oldValue;
        }
        throw new UnsupportedOperationException("Setting of date values is not yet supported directly. Use a path/attribute 'time' to set the epoch seconds on a date");
    }

    @Override
    public boolean canSetValue() {
        return true;
    }
}

