/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateClause
extends AbstractExpression {
    private boolean hasSet;
    private boolean hasSpaceAfterRangeVariableDeclaration;
    private boolean hasSpaceAfterSet;
    private boolean hasSpaceAfterUpdate;
    private AbstractExpression rangeVariableDeclaration;
    private String setIdentifier;
    private String updateIdentifier;
    private AbstractExpression updateItems;

    public UpdateClause(AbstractExpression parent) {
        super(parent, "UPDATE");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRangeVariableDeclaration().accept(visitor);
        this.getUpdateItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRangeVariableDeclaration());
        children.add(this.getUpdateItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("UPDATE"));
        if (this.hasSpaceAfterUpdate) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.rangeVariableDeclaration != null) {
            children.add(this.rangeVariableDeclaration);
        }
        if (this.hasSpaceAfterRangeVariableDeclaration) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasSet) {
            children.add(this.buildStringExpression("SET"));
        }
        if (this.hasSpaceAfterSet) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.updateItems != null) {
            children.add(this.updateItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getUpdateItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public String getActualSetIdentifier() {
        return this.setIdentifier != null ? this.setIdentifier : "";
    }

    public String getActualUpdateIdentifier() {
        return this.updateIdentifier;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("update_clause");
    }

    public Expression getRangeVariableDeclaration() {
        if (this.rangeVariableDeclaration == null) {
            this.rangeVariableDeclaration = this.buildNullExpression();
        }
        return this.rangeVariableDeclaration;
    }

    public Expression getUpdateItems() {
        if (this.updateItems == null) {
            this.updateItems = this.buildNullExpression();
        }
        return this.updateItems;
    }

    public boolean hasRangeVariableDeclaration() {
        return this.rangeVariableDeclaration != null && !this.rangeVariableDeclaration.isNull();
    }

    public boolean hasSet() {
        return this.hasSet;
    }

    public boolean hasSpaceAfterRangeVariableDeclaration() {
        return this.hasSpaceAfterRangeVariableDeclaration;
    }

    public boolean hasSpaceAfterSet() {
        return this.hasSpaceAfterSet;
    }

    public boolean hasSpaceAfterUpdate() {
        return this.hasSpaceAfterUpdate;
    }

    public boolean hasUpdateItems() {
        return this.updateItems != null && !this.updateItems.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("SET") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.updateIdentifier = wordParser.moveForward("UPDATE");
        boolean bl = this.hasSpaceAfterUpdate = wordParser.skipLeadingWhitespace() > 0;
        if (tolerant && !wordParser.startsWithIdentifier("SET")) {
            this.rangeVariableDeclaration = this.parse(wordParser, "range_variable_declaration", tolerant);
        } else if (!tolerant) {
            this.rangeVariableDeclaration = new RangeVariableDeclaration(this);
            this.rangeVariableDeclaration.parse(wordParser, tolerant);
        }
        this.hasSpaceAfterRangeVariableDeclaration = wordParser.skipLeadingWhitespace() > 0;
        boolean bl2 = this.hasSet = tolerant ? wordParser.startsWithIdentifier("SET") : true;
        if (this.hasSet) {
            this.setIdentifier = wordParser.moveForward("SET");
            this.hasSpaceAfterSet = wordParser.skipLeadingWhitespace() > 0;
        }
        this.updateItems = this.parse(wordParser, "update_item*", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.updateIdentifier : "UPDATE");
        if (this.hasSpaceAfterUpdate) {
            writer.append(' ');
        }
        if (this.rangeVariableDeclaration != null) {
            this.rangeVariableDeclaration.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterRangeVariableDeclaration) {
            writer.append(' ');
        }
        if (this.hasSet) {
            writer.append(actual ? this.setIdentifier : "SET");
        }
        if (this.hasSpaceAfterSet) {
            writer.append(' ');
        }
        if (this.updateItems != null) {
            this.updateItems.toParsedText(writer, actual);
        }
    }
}

